/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class SurveyorCommands {
    private static final Multimap<UUID, UUID> requests = HashMultimap.create();

    private static void informGroup(ServerPlayer player, Set<PlayerSummary> group, Consumer<Component> feedback) {
        feedback.accept((Component)Component.literal((String)"You're sharing your map with ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%d".formatted(group.size() - 1)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).withStyle(ChatFormatting.GOLD)));
        feedback.accept((Component)TextUtil.highlightStrings(group.stream().map(PlayerSummary::username).filter(u -> !u.equals(player.getGameProfile().getName())).toList(), s -> ChatFormatting.WHITE).withStyle(ChatFormatting.GOLD));
    }

    private static int informGlobal(ServerSummary serverSummary, ServerPlayer player, Consumer<Component> feedback) {
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The server has global sharing enabled!").withStyle(ChatFormatting.YELLOW)));
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You can't leave or modify the global sharing group!").withStyle(ChatFormatting.YELLOW)));
        SurveyorCommands.informGroup(player, serverSummary.groupPlayers(Surveyor.getUuid(player), player.getServer()), feedback);
        return 0;
    }

    private static int info(ServerSummary serverSummary, ServerPlayer player, SurveyorExploration exploration, Consumer<Component> feedback) {
        Set<PlayerSummary> group = serverSummary.groupPlayers(Surveyor.getUuid(player), player.getServer());
        SurveyorExploration groupExploration = SurveyorExploration.ofShared(player);
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        for (ServerLevel world : player.getServer().getAllLevels()) {
            WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
            if (summary == null) continue;
            summary.asMap(exploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? landmarks : waypoints).add(landmark)));
            summary.asMap(groupExploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? groupLandmarks : groupWaypoints).add(landmark)));
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---Map Exploration Summary---").withStyle(ChatFormatting.GRAY)));
        feedback.accept((Component)Component.literal((String)"You've explored ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"%d".formatted(exploration.chunkCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" total chunks!").withStyle(ChatFormatting.AQUA)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"%d".formatted(groupExploration.chunkCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.AQUA)))));
        feedback.accept((Component)Component.literal((String)"You've explored ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)"%d".formatted(exploration.structureCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" structures!").withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)"%d".formatted(groupExploration.structureCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.LIGHT_PURPLE)))));
        feedback.accept((Component)Component.literal((String)"You've explored ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(landmarks.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" landmarks!").withStyle(ChatFormatting.GREEN)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(groupLandmarks.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.GREEN)))));
        feedback.accept((Component)Component.literal((String)"...and created ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(waypoints.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" waypoints!").withStyle(ChatFormatting.GREEN)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"%d".formatted(groupWaypoints.size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" with friends)").withStyle(ChatFormatting.GREEN)))));
        if (group.size() > 1) {
            SurveyorCommands.informGroup(player, group, feedback);
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"-------End Summary-------").withStyle(ChatFormatting.GRAY)));
        return 1;
    }

    private static int landmarkInfo(ServerSummary serverSummary, ServerPlayer player, SurveyorExploration exploration, Consumer<Component> feedback) {
        Set<PlayerSummary> group = serverSummary.groupPlayers(Surveyor.getUuid(player), player.getServer());
        SurveyorExploration groupExploration = SurveyorExploration.ofShared(player);
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---Landmark Types---").withStyle(ChatFormatting.GRAY)));
        HashSet<LandmarkType> waypoints = new HashSet<LandmarkType>();
        HashMultimap keys = HashMultimap.create();
        HashMultimap groupKeys = HashMultimap.create();
        HashMultimap personalKeys = HashMultimap.create();
        for (ServerLevel world : player.getServer().getAllLevels()) {
            WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
            if (summary == null) continue;
            waypoints.addAll(summary.asMap(null).values().stream().flatMap(e -> e.values().stream().filter(l -> l.owner() != null)).map(Landmark::type).toList());
            keys.putAll(summary.keySet(null));
            groupKeys.putAll(summary.keySet(groupExploration));
            personalKeys.putAll(summary.keySet(exploration));
        }
        keys.asMap().forEach((arg_0, arg_1) -> SurveyorCommands.lambda$landmarkInfo$8(feedback, waypoints, (Multimap)personalKeys, group, (Multimap)groupKeys, player, (Multimap)keys, arg_0, arg_1));
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"-------End Landmarks-------").withStyle(ChatFormatting.GRAY)));
        return 1;
    }

    private static int share(ServerSummary serverSummary, ServerPlayer player, Consumer<Component> feedback, String username) {
        ServerPlayer sharePlayer = player.getServer().getPlayerList().getPlayerByName(username);
        if (sharePlayer == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"Can't find an online player named ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)username).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (sharePlayer == player) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You can't share map exploration with yourself!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (requests.containsEntry((Object)Surveyor.getUuid(player), (Object)Surveyor.getUuid(sharePlayer))) {
            if (serverSummary.groupSize(Surveyor.getUuid(player)) > 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) > 1) {
                feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You're in a group! leave your group first with:").withStyle(ChatFormatting.YELLOW)));
                feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"/surveyor unshare").withStyle(ChatFormatting.GOLD)));
                return 0;
            }
            requests.removeAll((Object)Surveyor.getUuid(player));
            ServerSummary.of(player.getServer()).joinGroup(Surveyor.getUuid(player), Surveyor.getUuid(sharePlayer), player.getServer());
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You're now sharing map exploration with ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).withStyle(ChatFormatting.GREEN)));
            feedback.accept((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.getServer()).stream().map(PlayerSummary::username).filter(u -> !u.equals(player.getGameProfile().getName())).toList(), s -> ChatFormatting.WHITE).withStyle(ChatFormatting.GREEN));
            for (ServerPlayer friend : serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.getServer())) {
                friend.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)player.getDisplayName().copy().withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" is now sharing their map with you.").withStyle(ChatFormatting.AQUA)));
                friend.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You're now sharing map exploration with ").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).withStyle(ChatFormatting.AQUA)));
                friend.sendSystemMessage((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.getServer()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.getGameProfile().getName())).toList(), s -> ChatFormatting.WHITE).withStyle(ChatFormatting.AQUA));
            }
            return 1;
        }
        if (!requests.containsEntry((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player))) {
            requests.put((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player));
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"Share request sent to ").withStyle(ChatFormatting.GREEN)).append((Component)sharePlayer.getDisplayName().copy().withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.GREEN)));
            sharePlayer.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)player.getDisplayName().copy().withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" wants to share map exploration!").withStyle(ChatFormatting.AQUA)));
            if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) <= 1) {
                feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"If accepted, you'll share your map exploration.").withStyle(ChatFormatting.GREEN)));
                sharePlayer.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"To share your explored map area, enter:").withStyle(ChatFormatting.AQUA)));
            } else if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1) {
                feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"If accepted, you'll share with their group of ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.GREEN)));
                sharePlayer.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"To share your group of ").append((Component)Component.literal((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)", enter:").withStyle(ChatFormatting.AQUA)));
            } else {
                feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"If accepted, they'll share with your group of ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)".").withStyle(ChatFormatting.GREEN)));
                sharePlayer.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"To share with their group of ").append((Component)Component.literal((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)", enter:").withStyle(ChatFormatting.AQUA)));
            }
            sharePlayer.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"/surveyor share %s".formatted(player.getGameProfile().getName())).withStyle(ChatFormatting.GOLD)));
            return 1;
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You've already sent this player a share request!").withStyle(ChatFormatting.YELLOW)));
        return 0;
    }

    private static int unshare(ServerSummary serverSummary, ServerPlayer player, Consumer<Component> feedback) {
        int shareNumber = serverSummary.groupSize(Surveyor.getUuid(player)) - 1;
        if (shareNumber == 0) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You're not sharing map exploration with anyone!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Set<ServerPlayer> friends = serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.getServer());
        ServerSummary.of(player.getServer()).leaveGroup(Surveyor.getUuid(player), player.getServer());
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"Stopped sharing map exploration with ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"%d".formatted(shareNumber)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(shareNumber > 1 ? " players." : " player.")).withStyle(ChatFormatting.GREEN)));
        for (ServerPlayer friend : friends) {
            int groupSize = serverSummary.groupSize(Surveyor.getUuid(friend)) - 1;
            friend.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)player.getDisplayName().copy().withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" is no longer sharing with you.").withStyle(ChatFormatting.AQUA)));
            friend.sendSystemMessage((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You're now sharing map exploration with ").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"%d".formatted(groupSize)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(groupSize == 0 ? " players." : (groupSize > 1 ? " players:" : " player:"))).withStyle(ChatFormatting.AQUA)));
            if (groupSize <= 0) continue;
            friend.sendSystemMessage((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(friend), friend.getServer()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.getGameProfile().getName())).toList(), s -> ChatFormatting.WHITE).withStyle(ChatFormatting.AQUA));
        }
        return 1;
    }

    private static int getLandmarks(WorldSummary summary, ServerPlayer player, SurveyorExploration exploration, Consumer<Component> feedback, ResourceLocation type) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The landmark system is dynamically disabled!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Map<BlockPos, ?> landmarks = summary.landmarks().asMap(Landmarks.getType(type), player.hasPermissions(2) ? null : exploration);
        if (landmarks.isEmpty()) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"There are no landmarks of that type in this world!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---World %s Landmarks---".formatted(type)).withStyle(ChatFormatting.GRAY)));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((Component)Component.literal((String)"[").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)landmark.pos().toShortString()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)" - ").withStyle(landmark.owner() != null ? ChatFormatting.GREEN : ChatFormatting.RED)).append((Component)Component.literal((String)"\"").withStyle(ChatFormatting.GOLD)).append((Component)(landmark.name() == null ? Component.nullToEmpty((String)"") : landmark.name().copy().withStyle(s -> s.withColor(landmark.color() != null ? landmark.color().getFireworkColor() : ChatFormatting.WHITE.getColor().intValue())))).append((Component)Component.literal((String)"\"").withStyle(ChatFormatting.GOLD)));
        }
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"---End %s Landmarks---".formatted(type)).withStyle(ChatFormatting.GRAY)));
        return landmarks.size();
    }

    private static int removeLandmark(WorldSummary summary, ServerPlayer player, ServerLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The landmark system is dynamically disabled!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"No landmark exists of that type and position!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark<?> landmark = summary.landmarks().get(Landmarks.getType(type), pos);
        if (!(landmark.owner() != null && landmark.owner() == Surveyor.getUuid(player) || player.hasPermissions(2))) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You don't have permission to delete that landmark!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().remove((Level)world, Landmarks.getType(type), pos);
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"%s removed successfully!".formatted(landmark.owner() == null ? "Landmark" : "Waypoint")).withStyle(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addLandmark(WorldSummary summary, ServerPlayer player, ServerLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos, DyeColor color, String name, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"The landmark system is dynamically disabled!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!SimplePointLandmark.TYPE.id().equals((Object)type)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You can't create a landmark of that type!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (global && !player.hasPermissions(2)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"You don't have permission to add that landmark!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        if (summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"A landmark exists of that type and position!").withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().put((Level)world, new SimplePointLandmark(pos, global ? null : Surveyor.getUuid(player), color, Component.nullToEmpty((String)(name.contains("\\n") ? name.substring(0, name.indexOf("\\n")) : name)), name.contains("\\n") ? Component.nullToEmpty((String)name.substring(name.indexOf("\\n") + 2)) : null, null));
        feedback.accept((Component)Component.literal((String)"[Surveyor] ").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)"%s added successfully!".formatted(global ? "Landmark" : "Waypoint")).withStyle(ChatFormatting.GREEN)));
        return 1;
    }

    public static int execute(CommandContext<CommandSourceStack> context, SurveyorCommandExecutor<Integer> executor) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            Surveyor.LOGGER.error("[Surveyor] Commands cannot be invoked by a non-player");
            return 0;
        }
        SurveyorExploration exploration = SurveyorExploration.of(player);
        try {
            return executor.execute(ServerSummary.of(player.getServer()), WorldSummary.of((Level)((CommandSourceStack)context.getSource()).getLevel()), player, ((CommandSourceStack)context.getSource()).getLevel(), exploration, t -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> t, false));
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Command failed! Check log for details.").withStyle(ChatFormatting.RED), false);
            Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            return 0;
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"surveyor").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.info(s, p, e, f)))).then(Surveyor.CONFIG.networking.globalSharing ? Commands.literal((String)"share").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.informGlobal(s, p, f))) : Commands.literal((String)"share").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(((CommandSourceStack)c.getSource()).getServer().getPlayerList().getPlayers().stream().filter(p -> ((CommandSourceStack)c.getSource()).getPlayer() != p).map(p -> p.getGameProfile().getName()), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.share(s, p, f, (String)c.getArgument("player", String.class))))))).then(Surveyor.CONFIG.networking.globalSharing ? Commands.literal((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.informGlobal(s, p, f))) : Commands.literal((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.unshare(s, p, f))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.landmarkInfo(s, p, e, f)))).then(Commands.literal((String)"get").then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(Landmarks.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.getLandmarks(w, p, e, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(Landmarks.keySet(), (SuggestionsBuilder)b)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.removeLandmark(w, p, sw, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)c.getSource())))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(DyeColor.values()).map(DyeColor::getName), (SuggestionsBuilder)b)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.addLandmark(w, p, sw, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)c.getSource()), DyeColor.byName((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), false))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"global").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).requires(c -> c.getPlayer() == null || c.getPlayer().hasPermissions(2))).then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(DyeColor.values()).map(DyeColor::getName), (SuggestionsBuilder)b)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.addLandmark(w, p, sw, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).getBlockPos((CommandSourceStack)c.getSource()), DyeColor.byName((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), true))))))))));
    }

    private static /* synthetic */ void lambda$landmarkInfo$8(Consumer feedback, Set waypoints, Multimap personalKeys, Set group, Multimap groupKeys, ServerPlayer player, Multimap keys, LandmarkType type, Collection list) {
        feedback.accept(Component.literal((String)"%s".formatted(type.id())).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(waypoints.contains(type) ? ": created " : ": explored ")).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"%d".formatted(personalKeys.get((Object)type).size())).withStyle(ChatFormatting.WHITE)).append((Component)(group.size() <= 1 ? Component.empty() : Component.literal((String)" (").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)"%d".formatted(groupKeys.get((Object)type).size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" shared)").withStyle(ChatFormatting.LIGHT_PURPLE)))).append((Component)(!player.hasPermissions(2) ? Component.empty() : Component.literal((String)" {of ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"%d".formatted(keys.get((Object)type).size())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"}").withStyle(ChatFormatting.GOLD)))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(ServerSummary var1, WorldSummary var2, ServerPlayer var3, ServerLevel var4, SurveyorExploration var5, Consumer<Component> var6);
    }
}

