/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.SurveyorCommands;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SurveyorConfig;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.MapUtil;
import folk.sisby.surveyor.util.RaycastUtil;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Surveyor
implements ModInitializer {
    public static final String ID = "surveyor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"surveyor");
    public static final String DATA_SUBFOLDER = "data";
    public static final SurveyorConfig CONFIG = (SurveyorConfig)SurveyorConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"surveyor", SurveyorConfig.class);

    public static File getSavePath(ResourceKey<Level> worldKey, MinecraftServer server) {
        return DimensionType.getStorageFolder(worldKey, (Path)server.getWorldPath(LevelResource.ROOT)).resolve(DATA_SUBFOLDER).resolve(ID).toFile();
    }

    public static void checkStructureExploration(ServerLevel world, ServerPlayer player, BlockPos pos) {
        if (!world.hasChunk(pos.getX() >> 4, pos.getZ() >> 4)) {
            return;
        }
        WorldStructureSummary worldStructures = WorldSummary.of((Level)world).structures();
        if (worldStructures == null) {
            return;
        }
        Registry structureRegistry = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
        SurveyorExploration exploration = SurveyorExploration.of(player);
        Map structureReferences = world.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
        if (!structureReferences.isEmpty()) {
            Multimap unexploredStructures = MapUtil.asMultiMap(structureReferences.entrySet().stream().collect(Collectors.toMap(e -> (ResourceKey)structureRegistry.getResourceKey((Object)((Structure)e.getKey())).orElseThrow(), e -> ((LongSet)e.getValue()).longStream().mapToObj(ChunkPos::new).toList())));
            unexploredStructures.entries().removeIf(e -> exploration.exploredStructure((ResourceKey<Level>)world.dimension(), (ResourceKey<Structure>)((ResourceKey)e.getKey()), (ChunkPos)e.getValue()));
            unexploredStructures.entries().removeIf(e -> !worldStructures.contains((ResourceKey<Structure>)((ResourceKey)e.getKey()), (ChunkPos)e.getValue()));
            unexploredStructures.forEach((structureKey, startPos) -> {
                Structure structure = (Structure)structureRegistry.get(structureKey);
                StructureStart start = world.getChunk(startPos.x, startPos.z, ChunkStatus.STRUCTURE_STARTS).getStartForStructure(structure);
                boolean found = false;
                if (start != null && start.isValid() && start.getBoundingBox().isInside((Vec3i)pos)) {
                    for (StructurePiece piece : start.getPieces()) {
                        if (!piece.getBoundingBox().inflatedBy(2).isInside((Vec3i)pos)) continue;
                        exploration.addStructure((ResourceKey<Level>)world.dimension(), (ResourceKey<Structure>)structureKey, start.getChunkPos());
                        found = true;
                        break;
                    }
                }
                if (found && Surveyor.CONFIG.debugMode) {
                    player.sendSystemMessage((Component)Component.literal((String)"Discovered ").append((Component)Component.literal((String)StringUtils.capitalize((String)structureKey.location().getPath().replace("_", " "))).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" at ")).append((Component)Component.literal((String)"[%s,%s]".formatted(startPos.x << 4, startPos.z << 4)).withStyle(ChatFormatting.GOLD)).withStyle(ChatFormatting.GRAY), true);
                }
            });
        }
    }

    public static UUID getUuid(ServerPlayer player) {
        return player.getServer() != null && player.getServer().isSingleplayerOwner(player.getGameProfile()) ? ServerSummary.HOST : player.getUUID();
    }

    public static ServerPlayer getPlayer(MinecraftServer server, UUID uuid) {
        return server.getPlayerList().getPlayer(uuid == ServerSummary.HOST && server.getSingleplayerProfile() != null ? server.getSingleplayerProfile().getId() : uuid);
    }

    public void onInitialize() {
        SurveyorNetworking.init();
        CommandRegistrationCallback.EVENT.register(SurveyorCommands::registerCommands);
        ServerPlayConnectionEvents.JOIN.register(ServerSummary::onPlayerJoin);
        ServerChunkEvents.CHUNK_LOAD.register(WorldTerrainSummary::onChunkLoad);
        ServerChunkEvents.CHUNK_LOAD.register(WorldStructureSummary::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(WorldTerrainSummary::onChunkUnload);
        ServerTickEvents.END_SERVER_TICK.register(ServerSummary::onTick);
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if ((world.getGameTime() & 7L) != 0L) {
                return;
            }
            for (ServerPlayer player : world.players()) {
                Surveyor.checkStructureExploration(world, player, player.blockPosition());
                Surveyor.checkStructureExploration(world, player, BlockPos.containing((Position)RaycastUtil.playerViewRaycast(player, PlayerSummary.of(player).viewDistance()).getLocation()));
            }
        });
        LOGGER.info("[Surveyor] is not a map mod");
    }
}

