/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorServer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public final class ServerSummary {
    public static final String KEY_GROUPS = "groups";
    public static final UUID HOST = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final Map<UUID, PlayerSummary> offlineSummaries;
    private final Map<UUID, Set<UUID>> shareGroups;
    private boolean dirty = false;

    public ServerSummary(Map<UUID, PlayerSummary> offlineSummaries, @Nullable Map<UUID, Set<UUID>> shareGroups) {
        this.offlineSummaries = offlineSummaries;
        this.shareGroups = shareGroups;
    }

    public static ServerSummary of(MinecraftServer server) {
        return ((SurveyorServer)server).surveyor$getSummary();
    }

    public static Map<UUID, Set<UUID>> loadShareGroups(MinecraftServer server) {
        File folder = Surveyor.getSavePath((ResourceKey<Level>)Level.OVERWORLD, server);
        CompoundTag sharingNbt = new CompoundTag();
        File sharingFile = new File(folder, "sharing.dat");
        if (sharingFile.exists()) {
            try {
                sharingNbt = NbtIo.readCompressed((Path)sharingFile.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading sharing file.", (Throwable)e);
            }
        }
        ConcurrentHashMap<UUID, Set<UUID>> shareGroups = new ConcurrentHashMap<UUID, Set<UUID>>();
        sharingNbt.getList(KEY_GROUPS, 9).stream().map(l -> ((ListTag)l).stream().map(s -> UUID.fromString(s.getAsString())).collect(Collectors.toCollection(HashSet::new))).forEach(set -> {
            for (UUID uuid : set) {
                shareGroups.put(uuid, (Set<UUID>)set);
            }
        });
        return shareGroups;
    }

    public static ServerSummary load(MinecraftServer server) {
        Map<UUID, Set<UUID>> shareGroups = Surveyor.CONFIG.networking.globalSharing ? null : ServerSummary.loadShareGroups(server);
        File playerFolder = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).toFile();
        ConcurrentHashMap<UUID, PlayerSummary> offlineSummaries = new ConcurrentHashMap<UUID, PlayerSummary>();
        CompoundTag hostData = server.getWorldData().getLoadedPlayerTag();
        UUID hostProfile = Optional.ofNullable(server.getSingleplayerProfile()).map(GameProfile::getId).orElse(null);
        if (hostData != null) {
            if (hostProfile != null) {
                hostData.putString("username", server.getSingleplayerProfile().getName());
            }
            offlineSummaries.put(HOST, new PlayerSummary.OfflinePlayerSummary(HOST, hostData, false));
        }
        for (File file : Optional.ofNullable(playerFolder.listFiles((dir, name) -> name.endsWith(".dat"))).orElse(new File[0])) {
            UUID uuid;
            try {
                uuid = UUID.fromString(file.getName().substring(0, file.getName().length() - ".dat".length()));
                if (uuid.equals(hostProfile)) {
                }
            }
            catch (IllegalArgumentException ex) {}
            continue;
            if (shareGroups != null && !shareGroups.containsKey(uuid)) continue;
            try {
                CompoundTag playerNbt = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                offlineSummaries.put(uuid, new PlayerSummary.OfflinePlayerSummary(uuid, playerNbt, false));
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading offline player data for {}!", (Object)uuid, (Object)e);
            }
        }
        if (shareGroups != null) {
            for (UUID uuid : shareGroups.keySet()) {
                if (offlineSummaries.containsKey(uuid)) continue;
                Surveyor.LOGGER.warn("[Surveyor] Player data was missing for shared player {}! Removing from groups...", (Object)uuid);
                shareGroups.get(uuid).remove(uuid);
                shareGroups.remove(uuid);
            }
        }
        return new ServerSummary(offlineSummaries, shareGroups);
    }

    public static void onPlayerJoin(ServerGamePacketListenerImpl handler, PacketSender sender, MinecraftServer server) {
        ServerSummary serverSummary = ServerSummary.of(server);
        UUID uuid = Surveyor.getUuid(handler.player);
        boolean known = serverSummary.offlineSummaries.containsKey(uuid);
        serverSummary.updatePlayer(uuid, handler.player.saveWithoutId(new CompoundTag()), true, server);
        if (serverSummary.groupSize(uuid) > 1) {
            SurveyorExploration groupExploration = serverSummary.groupExploration(uuid, server);
            new S2CGroupChangedPacket(serverSummary.getGroupSummaries(uuid, server), groupExploration.terrain().getOrDefault(handler.player.level().dimension(), new HashMap()), groupExploration.structures().getOrDefault(handler.player.level().dimension(), new HashMap())).send(handler.player);
            if (!known && Surveyor.CONFIG.networking.globalSharing) {
                for (ServerPlayer friend : serverSummary.groupOtherServerPlayers(uuid, server)) {
                    new S2CGroupChangedPacket(serverSummary.getGroupSummaries(uuid, server), groupExploration.terrain().getOrDefault(friend.level().dimension(), new HashMap()), groupExploration.structures().getOrDefault(friend.level().dimension(), new HashMap())).send(friend);
                }
            }
        }
    }

    public static void onTick(MinecraftServer server) {
        if (Surveyor.CONFIG.networking.positions.atMost(NetworkMode.SOLO) || server.getTickCount() % Surveyor.CONFIG.networking.positionTicks != 0) {
            return;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            Map<UUID, PlayerSummary> group = Surveyor.CONFIG.networking.positions.atLeast(NetworkMode.SERVER) ? ServerSummary.of(server).getOfflineSummaries(server) : ServerSummary.of(server).getGroupSummaries(Surveyor.getUuid(player), server);
            PlayerSummary playerSummary = group.get(Surveyor.getUuid(player));
            group.entrySet().removeIf(e -> ((UUID)e.getKey()).equals(Surveyor.getUuid(player)));
            group.entrySet().removeIf(e -> !((PlayerSummary)e.getValue()).online());
            group.entrySet().removeIf(e -> !((PlayerSummary)e.getValue()).dimension().equals(playerSummary.dimension()));
            group.entrySet().removeIf(e -> {
                ServerPlayer friend = server.getPlayerList().getPlayer((UUID)e.getKey());
                return (friend == null || !friend.isSpectator()) && ((PlayerSummary)e.getValue()).pos().distanceToSqr(playerSummary.pos()) < (double)(playerSummary.viewDistance() * playerSummary.viewDistance() + 1 << 4);
            });
            if (group.isEmpty()) continue;
            new S2CGroupUpdatedPacket(group).send(player);
        }
    }

    public void save(MinecraftServer server, boolean force, boolean suppressLogs) {
        if (!this.isDirty() && StreamSupport.stream(server.getAllLevels().spliterator(), false).map(WorldSummary::of).noneMatch(WorldSummary::isDirty)) {
            return;
        }
        if (!suppressLogs) {
            Surveyor.LOGGER.info("[Surveyor] Saving server data...");
        }
        for (ServerLevel world : server.getAllLevels()) {
            if (world.noSave && !force) continue;
            WorldSummary.of((Level)world).save((Level)world, Surveyor.getSavePath((ResourceKey<Level>)world.dimension(), server), suppressLogs);
        }
        File folder = Surveyor.getSavePath((ResourceKey<Level>)Level.OVERWORLD, server);
        if (this.isDirty()) {
            File sharingFile = new File(folder, "sharing.dat");
            try {
                NbtIo.writeCompressed((CompoundTag)this.writeNbt(new CompoundTag()), (Path)sharingFile.toPath());
                this.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing sharing file.", (Throwable)e);
            }
        }
        if (!suppressLogs) {
            Surveyor.LOGGER.info("[Surveyor] Finished saving server data.");
        }
    }

    private CompoundTag writeNbt(CompoundTag nbt) {
        nbt.put(KEY_GROUPS, (Tag)new ListTag(this.getGroups().stream().filter(s -> s.size() > 1).map(s -> new ListTag(s.stream().map(u -> StringTag.valueOf((String)u.toString())).toList(), 8)).toList(), 9));
        return nbt;
    }

    public PlayerSummary getPlayer(UUID uuid, MinecraftServer server) {
        ServerPlayer player = Surveyor.getPlayer(server, uuid);
        if (player != null) {
            return PlayerSummary.of(player);
        }
        return this.offlineSummaries.get(uuid);
    }

    public SurveyorExploration getExploration(UUID player, MinecraftServer server) {
        PlayerSummary summary = this.getPlayer(player, server);
        return summary == null ? null : summary.exploration();
    }

    public void updatePlayer(UUID uuid, CompoundTag nbt, boolean online, MinecraftServer server) {
        PlayerSummary.OfflinePlayerSummary newSummary = new PlayerSummary.OfflinePlayerSummary(uuid, nbt, online);
        this.offlineSummaries.put(uuid, newSummary);
        for (ServerPlayer friend : this.groupOtherServerPlayers(uuid, server)) {
            S2CGroupUpdatedPacket.of(uuid, newSummary).send(friend);
        }
    }

    public Set<Set<UUID>> getGroups() {
        return this.shareGroups == null ? new HashSet<Set<UUID>>() : new HashSet<Set<UUID>>(this.shareGroups.values());
    }

    public Map<UUID, PlayerSummary> getOfflineSummaries(MinecraftServer server) {
        return this.offlineSummaries.keySet().stream().filter(u -> this.getPlayer((UUID)u, server) != null).collect(Collectors.toMap(u -> u, u -> this.getPlayer((UUID)u, server)));
    }

    public Set<UUID> getGroup(UUID player) {
        return this.shareGroups == null ? new HashSet<UUID>(this.offlineSummaries.keySet()) : this.shareGroups.computeIfAbsent(player, p -> new HashSet<UUID>(Set.of(p)));
    }

    public Map<UUID, PlayerSummary> getGroupSummaries(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().filter(u -> this.getPlayer((UUID)u, server) != null).collect(Collectors.toMap(u -> u, u -> this.getPlayer((UUID)u, server)));
    }

    public void joinGroup(UUID player1, UUID player2, MinecraftServer server) {
        if (this.shareGroups == null) {
            return;
        }
        if (this.getGroup(player1).size() > 1 && this.getGroup(player2).size() > 1) {
            throw new IllegalStateException("Can't merge two groups!");
        }
        if (this.getGroup(player1).size() > 1) {
            this.getGroup(player1).add(player2);
            this.shareGroups.put(player2, this.getGroup(player1));
        } else {
            this.getGroup(player2).add(player1);
            this.shareGroups.put(player1, this.getGroup(player2));
        }
        SurveyorExploration groupExploration = this.groupExploration(player1, server);
        for (ServerPlayer friend : this.groupServerPlayers(player1, server)) {
            new S2CGroupChangedPacket(this.getGroupSummaries(player1, server), groupExploration.terrain().getOrDefault(friend.level().dimension(), new HashMap()), groupExploration.structures().getOrDefault(friend.level().dimension(), new HashMap())).send(friend);
        }
        this.dirty();
    }

    public void leaveGroup(UUID player, MinecraftServer server) {
        if (this.shareGroups == null) {
            return;
        }
        this.getGroup(player).remove(player);
        SurveyorExploration groupExploration = this.groupExploration(player, server);
        for (ServerPlayer friend : this.groupOtherServerPlayers(player, server)) {
            new S2CGroupChangedPacket(this.getGroupSummaries(Surveyor.getUuid(friend), server), groupExploration.terrain().getOrDefault(friend.level().dimension(), new HashMap()), groupExploration.structures().getOrDefault(friend.level().dimension(), new HashMap())).send(friend);
        }
        this.shareGroups.put(player, new HashSet());
        this.getGroup(player).add(player);
        ServerPlayer serverPlayer = Surveyor.getPlayer(server, player);
        if (serverPlayer != null) {
            new S2CGroupChangedPacket(this.getGroupSummaries(player, server), new HashMap<ChunkPos, BitSet>(), new HashMap<ResourceKey<Structure>, LongSet>()).send(serverPlayer);
        }
        this.dirty();
    }

    public int groupSize(UUID player) {
        return this.getGroup(player).size();
    }

    public Set<PlayerSummary> groupPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().map(u -> this.getPlayer((UUID)u, server)).collect(Collectors.toSet());
    }

    public SurveyorExploration groupExploration(UUID player, MinecraftServer server) {
        return PlayerSummary.OfflinePlayerSummary.OfflinePlayerExploration.ofMerged(this.getGroup(player).stream().map(u -> this.getExploration((UUID)u, server)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public Set<ServerPlayer> groupServerPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().map(uuid -> Surveyor.getPlayer(server, player)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<ServerPlayer> groupOtherServerPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().filter(u -> !u.equals(player)).map(arg_0 -> ((PlayerList)server.getPlayerList()).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean isDirty() {
        return this.dirty && this.shareGroups != null;
    }

    private void dirty() {
        this.dirty = true;
    }
}

