/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorPlayer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.ArrayUtil;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;

public interface PlayerSummary {
    public static final String KEY_DATA = "surveyor";
    public static final String KEY_USERNAME = "username";

    public static PlayerSummary of(ServerPlayer player) {
        return ((SurveyorPlayer)player).surveyor$getSummary();
    }

    public static PlayerSummary of(UUID uuid, MinecraftServer server) {
        return ServerSummary.of(server).getPlayer(uuid, server);
    }

    public SurveyorExploration exploration();

    public String username();

    public ResourceKey<Level> dimension();

    public Vec3 pos();

    public float yaw();

    public int viewDistance();

    public boolean online();

    default public void copyFrom(PlayerSummary oldSummary) {
        this.exploration().copyFrom(oldSummary.exploration());
    }

    public static class ServerPlayerEntitySummary
    extends PlayerEntitySummary
    implements PlayerSummary {
        private final ServerPlayerExploration exploration;

        public ServerPlayerEntitySummary(ServerPlayer player) {
            super((Player)player);
            this.exploration = new ServerPlayerExploration(player, new ConcurrentHashMap<ResourceKey<Level>, Map<ChunkPos, BitSet>>(), new ConcurrentHashMap<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>>());
        }

        @Override
        public SurveyorExploration exploration() {
            return this.exploration;
        }

        @Override
        public int viewDistance() {
            return ((ServerPlayer)this.player).requestedViewDistance();
        }

        public void copyExploration(ServerPlayerEntitySummary oldSummary) {
            this.exploration.copyFrom(oldSummary.exploration);
        }

        public void read(CompoundTag nbt) {
            this.exploration.read(nbt.getCompound(PlayerSummary.KEY_DATA));
        }

        public void writeNbt(CompoundTag nbt) {
            CompoundTag surveyorNbt = new CompoundTag();
            this.exploration.write(surveyorNbt);
            surveyorNbt.putString(PlayerSummary.KEY_USERNAME, this.username());
            nbt.put(PlayerSummary.KEY_DATA, (Tag)surveyorNbt);
        }

        public record ServerPlayerExploration(ServerPlayer player, Map<ResourceKey<Level>, Map<ChunkPos, BitSet>> terrain, Map<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>> structures) implements SurveyorExploration
        {
            @Override
            public Set<UUID> sharedPlayers() {
                return Set.of(Surveyor.getUuid(this.player));
            }

            @Override
            public boolean personal() {
                return true;
            }

            @Override
            public void mergeRegion(ResourceKey<Level> worldKey, ChunkPos regionPos, BitSet bitSet) {
                SurveyorExploration.super.mergeRegion(worldKey, regionPos, bitSet);
                if (this.player.getServer().isSingleplayerOwner(this.player.getGameProfile())) {
                    this.updateClientForMergeRegion((Level)this.player.serverLevel(), regionPos, bitSet);
                }
                if (Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.SOLO)) {
                    return;
                }
                for (ServerPlayer friend : ServerSummary.of(this.player.getServer()).groupOtherServerPlayers(Surveyor.getUuid(this.player), this.player.getServer())) {
                    if (!friend.level().dimension().equals(worldKey)) continue;
                    SurveyorExploration friendExploration = SurveyorExploration.of(friend);
                    BitSet sendSet = (BitSet)bitSet.clone();
                    if (friendExploration.terrain().containsKey(worldKey) && friendExploration.terrain().get(worldKey).containsKey(regionPos)) {
                        sendSet.andNot(friendExploration.terrain().get(worldKey).get(regionPos));
                    }
                    WorldTerrainSummary summary = WorldSummary.of(this.player.level()).terrain();
                    if (sendSet.isEmpty() || summary == null) continue;
                    S2CUpdateRegionPacket.of(true, regionPos, summary.getRegion(regionPos), sendSet).send(friend);
                }
            }

            @Override
            public void addChunk(ResourceKey<Level> worldKey, ChunkPos pos) {
                SurveyorExploration.super.addChunk(worldKey, pos);
                if (this.player.getServer().isSingleplayerOwner(this.player.getGameProfile())) {
                    this.updateClientForAddChunk((Level)this.player.serverLevel(), pos);
                }
                if (Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.SOLO)) {
                    return;
                }
                for (ServerPlayer friend : ServerSummary.of(this.player.getServer()).groupOtherServerPlayers(Surveyor.getUuid(this.player), this.player.getServer())) {
                    if (!friend.level().dimension().equals(worldKey) || SurveyorExploration.of(friend).exploredChunk(worldKey, pos)) continue;
                    ChunkPos regionPos = new ChunkPos(pos.getRegionX(), pos.getRegionZ());
                    WorldTerrainSummary summary = WorldSummary.of((Level)this.player.getServer().getLevel(worldKey)).terrain();
                    if (summary == null) continue;
                    RegionSummary region = summary.getRegion(regionPos);
                    BitSet sendSet = new BitSet();
                    sendSet.set(RegionSummary.bitForChunk(pos));
                    S2CUpdateRegionPacket.of(true, regionPos, region, sendSet).send(friend);
                }
            }

            @Override
            public void addStructure(ResourceKey<Level> worldKey, ResourceKey<Structure> structureKey, ChunkPos pos) {
                SurveyorExploration.super.addStructure(worldKey, structureKey, pos);
                ServerLevel world = this.player.serverLevel();
                if (this.player.getServer().isSingleplayerOwner(this.player.getGameProfile())) {
                    this.updateClientForAddStructure((Level)world, structureKey, pos);
                }
                WorldStructureSummary summary = WorldSummary.of((Level)world).structures();
                if (Surveyor.CONFIG.networking.structures.atMost(NetworkMode.NONE)) {
                    return;
                }
                S2CStructuresAddedPacket.of(false, structureKey, pos, summary).send(this.player);
                if (Surveyor.CONFIG.networking.structures.atMost(NetworkMode.SOLO)) {
                    return;
                }
                for (ServerPlayer friend : ServerSummary.of(this.player.getServer()).groupOtherServerPlayers(Surveyor.getUuid(this.player), this.player.getServer())) {
                    if (!friend.level().dimension().equals(worldKey) || SurveyorExploration.of(friend).exploredStructure(worldKey, structureKey, pos)) continue;
                    S2CStructuresAddedPacket.of(true, structureKey, pos, summary).send(friend);
                }
            }
        }
    }

    public static class PlayerEntitySummary
    implements PlayerSummary {
        protected final Player player;

        public PlayerEntitySummary(Player player) {
            this.player = player;
        }

        @Override
        public SurveyorExploration exploration() {
            return null;
        }

        @Override
        public String username() {
            return this.player.getGameProfile().getName();
        }

        @Override
        public ResourceKey<Level> dimension() {
            return this.player.level().dimension();
        }

        @Override
        public Vec3 pos() {
            return this.player.position();
        }

        @Override
        public float yaw() {
            return this.player.getYRot();
        }

        @Override
        public int viewDistance() {
            return 0;
        }

        @Override
        public boolean online() {
            return true;
        }
    }

    public record OfflinePlayerSummary(SurveyorExploration exploration, String username, ResourceKey<Level> dimension, Vec3 pos, float yaw, boolean online) implements PlayerSummary
    {
        public OfflinePlayerSummary(UUID uuid, CompoundTag nbt, boolean online) {
            this(OfflinePlayerExploration.from(uuid, nbt.getCompound(PlayerSummary.KEY_DATA)), nbt.getCompound(PlayerSummary.KEY_DATA).contains(PlayerSummary.KEY_USERNAME) ? nbt.getCompound(PlayerSummary.KEY_DATA).getString(PlayerSummary.KEY_USERNAME) : "???", (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("Dimension"))), nbt.contains("Pos", 9) ? ArrayUtil.toVec3d(nbt.getList("Pos", 6).stream().mapToDouble(e -> ((DoubleTag)e).getAsDouble()).toArray()) : new Vec3(0.0, 0.0, 0.0), nbt.getList("Rotation", 5).getFloat(0), online);
        }

        public static void writeBuf(PlayerSummary summary, RegistryFriendlyByteBuf buf) {
            buf.writeUtf(summary.username());
            buf.writeResourceKey(summary.dimension());
            buf.writeDouble(summary.pos().x);
            buf.writeDouble(summary.pos().y);
            buf.writeDouble(summary.pos().z);
            buf.writeFloat(summary.yaw());
            buf.writeBoolean(summary.online());
        }

        public static PlayerSummary readBuf(RegistryFriendlyByteBuf buf) {
            return new OfflinePlayerSummary(null, buf.readUtf(), (ResourceKey<Level>)buf.readResourceKey(Registries.DIMENSION), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat(), buf.readBoolean());
        }

        @Override
        public int viewDistance() {
            return 0;
        }

        public record OfflinePlayerExploration(Set<UUID> sharedPlayers, Map<ResourceKey<Level>, Map<ChunkPos, BitSet>> terrain, Map<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>> structures, boolean personal) implements SurveyorExploration
        {
            public static OfflinePlayerExploration ofMerged(Set<SurveyorExploration> explorations) {
                HashSet<UUID> sharedPlayers = new HashSet<UUID>();
                HashMap<ResourceKey<Level>, Map<ChunkPos, BitSet>> terrain = new HashMap<ResourceKey<Level>, Map<ChunkPos, BitSet>>();
                HashMap<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>> structures = new HashMap<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>>();
                OfflinePlayerExploration outExploration = new OfflinePlayerExploration(sharedPlayers, terrain, structures, false);
                for (SurveyorExploration exploration : explorations) {
                    sharedPlayers.addAll(exploration.sharedPlayers());
                    exploration.terrain().forEach((wKey, map) -> map.forEach((rPos, bits) -> outExploration.mergeRegion((ResourceKey<Level>)wKey, (ChunkPos)rPos, (BitSet)bits)));
                    exploration.structures().forEach((wKey, map) -> map.forEach((sKey, longs) -> outExploration.mergeStructures((ResourceKey<Level>)wKey, (ResourceKey<Structure>)sKey, (LongSet)longs)));
                }
                return outExploration;
            }

            public static SurveyorExploration from(UUID uuid, CompoundTag nbt) {
                OfflinePlayerExploration mutable = new OfflinePlayerExploration(new HashSet<UUID>(Set.of(uuid)), new HashMap<ResourceKey<Level>, Map<ChunkPos, BitSet>>(), new HashMap<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>>(), true);
                mutable.read(nbt);
                return mutable;
            }
        }
    }
}

