/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block.entity;

import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class WellBehavedDropperBlockEntity
extends BlockEntity {
    boolean hasChanged = true;
    int counter = 20;
    public ItemStackHandler inventoryHandler = new ItemStackHandler(9){

        public boolean isItemValid(int slot, ItemStack stack) {
            return super.isItemValid(slot, stack) && WellBehavedDropperBlockEntity.this.getBlockState().getOptionalValue((Property)BlockStateProperties.ENABLED).orElse(true) != false;
        }

        protected void onContentsChanged(int slot) {
            WellBehavedDropperBlockEntity.this.hasChanged = true;
            super.onContentsChanged(slot);
        }
    };

    public WellBehavedDropperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)UtilityBlockModule.WELL_BEHAVED_DROPPER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier) {
        if (!pLevel.isClientSide && pLevel.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !pLevel.restoringBlockSnapshots) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.setDefaultPickUpDelay();
            pLevel.addFreshEntity((Entity)itementity);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, WellBehavedDropperBlockEntity blockEntity) {
        if (blockState.getOptionalValue((Property)BlockStateProperties.ENABLED).orElse(true).booleanValue() && (blockEntity.hasChanged || --blockEntity.counter <= 0 && blockEntity.level != null)) {
            for (int i = 0; i < blockEntity.inventoryHandler.getSlots(); ++i) {
                ItemStack stack = blockEntity.inventoryHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                BlockPos p = blockEntity.getBlockPos();
                WellBehavedDropperBlockEntity.popResource(level, () -> new ItemEntity(blockEntity.level, (double)p.getX() + 0.5, (double)p.getY() - 0.51, (double)p.getZ() + 0.5, stack, 0.0, -0.1, 0.0));
                blockEntity.inventoryHandler.setStackInSlot(i, ItemStack.EMPTY);
            }
            blockEntity.counter = 21;
            blockEntity.hasChanged = false;
        }
    }
}

