/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.SnadModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DritBlock
extends Block {
    public DritBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        super.stepOn(pLevel, pPos, pState, pEntity);
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            Holder.Reference damageType = pEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SnadModule.DRIT_DAMAGE);
            livingEntity.hurt(new DamageSource((Holder)damageType), ((Double)Config.SNAD_DRIT_DAMAGE.get()).floatValue());
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 3)) {
            return;
        }
        if (pLevel.getMaxLocalRawBrightness(pPos.above()) >= 9) {
            BlockState blockstate = ((Block)SnadModule.GRRASS_BLOCK.get()).defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pPos.offset(pRandom.nextInt(3) - 1, pRandom.nextInt(5) - 3, pRandom.nextInt(3) - 1);
                if (!pLevel.getBlockState(blockpos).is(Blocks.GRASS_BLOCK)) continue;
                pLevel.setBlockAndUpdate(pPos, (BlockState)blockstate.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(pLevel.getBlockState(blockpos.above()).is(Blocks.SNOW))));
                break;
            }
        }
    }
}

