/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import com.mojang.serialization.DynamicOps;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.client.handler.DyeChannelLidController;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.inventory.LinkedMenu;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.DyeChannelManager;
import fuzs.linkedchests.world.level.block.entity.DyeChannelStorage;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LinkedChestBlockEntity
extends BlockEntity
implements ListBackedContainer,
MenuProvider,
LidBlockEntity {
    static final String KEY_DYE_CHANNEL = LinkedChests.id("dye_channel").toString();
    static final String KEY_LATCH_ITEM = LinkedChests.id("latch_item").toString();
    private DyeChannel dyeChannel = DyeChannel.DEFAULT;
    private ItemStack latchItem = ItemStack.EMPTY;
    @Nullable
    private DyeChannelStorage storage;

    public LinkedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.LINKED_CHEST_BLOCK_ENTITY.value(), pos, state);
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.loadAdditional(compoundTag, registries);
        this.dyeChannel = DyeChannel.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.getCompound(KEY_DYE_CHANNEL)).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).orElse(DyeChannel.DEFAULT);
        this.latchItem = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compoundTag.getCompound(KEY_LATCH_ITEM));
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.saveAdditional(compoundTag, registries);
        DyeChannel.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.dyeChannel).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(KEY_DYE_CHANNEL, tag));
        if (!this.latchItem.isEmpty()) {
            compoundTag.put(KEY_LATCH_ITEM, this.latchItem.save(registries));
        }
    }

    public DyeChannel getDyeChannel() {
        return this.dyeChannel;
    }

    public void setDyeChannel(DyeChannel dyeChannel) {
        Objects.requireNonNull(dyeChannel, "dye channel is null");
        if (!Objects.equals(dyeChannel, this.dyeChannel)) {
            this.dyeChannel = dyeChannel;
            this.storage = null;
            this.markUpdated();
        }
    }

    public void setLatchItem(ItemStack itemStack) {
        this.latchItem = itemStack;
        this.setChanged();
    }

    public ItemStack removeLatchItem() {
        ItemStack itemStack = this.latchItem;
        this.latchItem = ItemStack.EMPTY;
        this.setChanged();
        return itemStack;
    }

    private DyeChannelStorage getStorage() {
        DyeChannelStorage storage = this.storage;
        if (storage == null) {
            this.storage = DyeChannelManager.getStorage(this.dyeChannel);
            return this.storage;
        }
        return storage;
    }

    private void markUpdated() {
        this.setChanged();
        if (this.hasLevel()) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void startOpen(Player player) {
        if (!this.remove && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.isSpectator()) {
                this.getStorage().openersCounter().incrementOpeners(this.dyeChannel, serverPlayer, this.getBlockPos(), SoundSource.BLOCKS);
            }
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.isSpectator()) {
                this.getStorage().openersCounter().decrementOpeners(this.dyeChannel, serverPlayer, this.getBlockPos(), SoundSource.BLOCKS);
            }
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public float getOpenNess(float partialTicks) {
        if (this.hasLevel() && this.getLevel().isClientSide) {
            return DyeChannelLidController.getChestLidController(this.dyeChannel).getOpenness(partialTicks);
        }
        return 0.0f;
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.getStorage().items();
    }

    public Component getDisplayName() {
        return ((Block)ModRegistry.LINKED_CHEST_BLOCK.value()).getName();
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new LinkedMenu(containerId, inventory, (Container)this, this.dyeChannel.uuid().isPresent(), false);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.dyeChannel = (DyeChannel)componentInput.get((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)this.dyeChannel);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove(KEY_DYE_CHANNEL);
    }
}

