/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.DyeChannelStorage;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public final class DyeChannelManager
extends SavedData {
    static final String KEY_CHANNELS = LinkedChests.id("channels").toString();
    public static final Codec<Map<DyeChannel, DyeChannelStorage>> CODEC = Codec.mapPair((MapCodec)DyeChannel.CODEC.fieldOf("dye_channel"), (MapCodec)DyeChannelStorage.CODEC.fieldOf("storage")).codec().listOf().xmap(list -> (Map)list.stream().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(entry -> new Pair((Object)((DyeChannel)entry.getKey()), (Object)((DyeChannelStorage)entry.getValue()))).toList());
    private static DyeChannelManager instance;
    private final Map<DyeChannel, DyeChannelStorage> channels;

    private DyeChannelManager() {
        this.channels = new HashMap<DyeChannel, DyeChannelStorage>();
    }

    private DyeChannelManager(Map<DyeChannel, DyeChannelStorage> channels) {
        this.channels = new HashMap<DyeChannel, DyeChannelStorage>(channels);
    }

    private static SavedData.Factory<DyeChannelManager> factory() {
        return new SavedData.Factory(DyeChannelManager::new, DyeChannelManager::load, null);
    }

    private static DyeChannelManager load(CompoundTag compoundTag, HolderLookup.Provider registries) {
        return CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.getList(KEY_CHANNELS, 10)).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).map(DyeChannelManager::new).orElseGet(DyeChannelManager::new);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider registries) {
        CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.channels).resultOrPartial(arg_0 -> ((Logger)LinkedChests.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(KEY_CHANNELS, tag));
        return compoundTag;
    }

    public static void registerEventHandlers() {
        ServerLifecycleEvents.STARTED.register(server -> {
            instance = (DyeChannelManager)server.overworld().getDataStorage().computeIfAbsent(DyeChannelManager.factory(), "linkedchests");
        });
        ServerLifecycleEvents.STOPPED.register(server -> {
            instance = null;
        });
        ServerTickEvents.END.register(server -> {
            DyeChannelManager channelManager;
            if (server.getTickCount() % 20 == 0 && (channelManager = instance) != null) {
                channelManager.channels.forEach((dyeChannel, storage) -> storage.openersCounter().recheckOpeners((DyeChannel)dyeChannel, server));
            }
        });
    }

    public static DyeChannelStorage getStorage(DyeChannel dyeChannel) {
        DyeChannelManager channelManager = instance;
        if (channelManager != null) {
            return channelManager.channels.computeIfAbsent(dyeChannel, DyeChannel::createStorage);
        }
        return new DyeChannelStorage(3);
    }

    public boolean isDirty() {
        return true;
    }
}

