/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.data.client;

import fuzs.linkedchests.client.LinkedChestsClient;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.client.data.v2.ItemModelProperties;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class ModModelProvider
extends AbstractModelProvider {
    public static final ModelTemplate CHEST_TEMPLATE = new ModelTemplate(Optional.of(ModModelProvider.decorateItemModelLocation((ResourceLocation)ResourceLocationHelper.withDefaultNamespace((String)"chest"))), Optional.empty(), new TextureSlot[]{TextureSlot.PARTICLE});

    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public void addBlockModels(BlockModelGenerators builder) {
        builder.blockEntityModels(ModelLocationUtils.getModelLocation((Block)((Block)ModRegistry.LINKED_CHEST_BLOCK.value())), Blocks.END_STONE).createWithoutBlockItem(new Block[]{(Block)ModRegistry.LINKED_CHEST_BLOCK.value()});
    }

    public void addItemModels(ItemModelGenerators builder) {
        CHEST_TEMPLATE.create(ModelLocationUtils.getModelLocation((Item)((Item)ModRegistry.LINKED_CHEST_ITEM.value())), TextureMapping.particle((Block)Blocks.END_STONE), builder.output);
        ModModelProvider.createLinkedPouchItem(builder, (Item)ModRegistry.LINKED_POUCH_ITEM.value());
        ModModelProvider.createLinkedPouchItem(builder, (Item)ModRegistry.LINKED_POUCH_ITEM.value(), LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN, null, LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN, LinkedChestsClient.ITEM_MODEL_PROPERTY_PERSONAL);
        ModModelProvider.createLinkedPouchItem(builder, (Item)ModRegistry.LINKED_POUCH_ITEM.value(), null, null, LinkedChestsClient.ITEM_MODEL_PROPERTY_PERSONAL);
        ModModelProvider.createLinkedPouchItem(builder, (Item)ModRegistry.LINKED_POUCH_ITEM.value(), LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN, null, LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN);
    }

    private static void createLinkedPouchItem(ItemModelGenerators builder, Item item) {
        ResourceLocation modelLocation = ModModelProvider.getModelLocation((Item)item);
        ItemModelProperties[] itemModelProperties = new ItemModelProperties[3];
        itemModelProperties[2] = ItemModelProperties.twoOverrides((ResourceLocation)ModModelProvider.getModelLocationWithSuffix(modelLocation, LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN, LinkedChestsClient.ITEM_MODEL_PROPERTY_PERSONAL), (ResourceLocation)LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN, (float)1.0f, (ResourceLocation)LinkedChestsClient.ITEM_MODEL_PROPERTY_PERSONAL, (float)1.0f);
        itemModelProperties[1] = ItemModelProperties.singleOverride((ResourceLocation)ModModelProvider.getModelLocationWithSuffix(modelLocation, LinkedChestsClient.ITEM_MODEL_PROPERTY_PERSONAL), (ResourceLocation)LinkedChestsClient.ITEM_MODEL_PROPERTY_PERSONAL, (float)1.0f);
        itemModelProperties[0] = ItemModelProperties.singleOverride((ResourceLocation)ModModelProvider.getModelLocationWithSuffix(modelLocation, LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN), (ResourceLocation)LinkedChestsClient.ITEM_MODEL_PROPERTY_OPEN, (float)1.0f);
        ModelTemplate.JsonFactory jsonFactory = ItemModelProperties.overridesFactory((ModelTemplate)ModelTemplates.FLAT_ITEM, (ItemModelProperties[])itemModelProperties);
        ModModelProvider.createLinkedPouchItem(builder, item, null, jsonFactory, new ResourceLocation[0]);
    }

    private static void createLinkedPouchItem(ItemModelGenerators builder, Item item, @Nullable ResourceLocation layerLocation, @Nullable ModelTemplate.JsonFactory jsonFactory, ResourceLocation ... itemModelProperties) {
        layerLocation = layerLocation == null ? ModModelProvider.getModelLocation((Item)item) : ModModelProvider.getModelLocation((Item)item).withSuffix("_" + layerLocation.getPath());
        ResourceLocation modelLocation = ModModelProvider.getModelLocationWithSuffix(ModModelProvider.getModelLocation((Item)item), itemModelProperties);
        TextureSlot[] textureSlots = ModModelProvider.createTextureSlotLayers(4);
        TextureMapping textureMapping = ModModelProvider.layered(modelLocation, layerLocation, textureSlots, "_button1", "_button2", "_button3");
        ModelTemplate modelTemplate = ModelTemplates.createItem((String)"generated", (TextureSlot[])textureSlots);
        if (jsonFactory != null) {
            modelTemplate.create(modelLocation, textureMapping, builder.output, jsonFactory);
        } else {
            modelTemplate.create(modelLocation, textureMapping, builder.output);
        }
    }

    public static ResourceLocation getModelLocationWithSuffix(ResourceLocation modelLocation, ResourceLocation ... itemModelProperties) {
        String suffix = Arrays.stream(itemModelProperties).map(ResourceLocation::getPath).collect(Collectors.joining("_"));
        if (!suffix.isEmpty()) {
            return modelLocation.withSuffix("_" + suffix);
        }
        return modelLocation;
    }

    public static TextureSlot[] createTextureSlotLayers(int size) {
        TextureSlot[] textureSlots = new TextureSlot[size];
        for (int i = 0; i < textureSlots.length; ++i) {
            textureSlots[i] = TextureSlot.create((String)("layer" + i));
        }
        return textureSlots;
    }

    public static TextureMapping layered(ResourceLocation initialLayerLocation, ResourceLocation layerLocation, TextureSlot[] textureSlots, String ... layerSuffixes) {
        TextureMapping textureMapping = new TextureMapping();
        for (int i = 0; i < textureSlots.length; ++i) {
            ResourceLocation textureLocation = i == 0 ? initialLayerLocation : layerLocation.withSuffix(layerSuffixes[i - 1]);
            textureMapping.put(textureSlots[i], textureLocation);
        }
        return textureMapping;
    }
}

