/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task.task;

import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.PlantableConfigurableItemStack;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.component.farmer.planting.FarmerPlantable;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantingContext;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;

public final class PlantingFarmerTask
extends FarmerTask {
    private final PlantableBehaviorHolder plantingHandlers;

    public PlantingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.PLANTING, component);
        this.plantingHandlers = component.getPlantableBehaviorHolder();
    }

    @Override
    protected boolean run() {
        List<PlantableConfigurableItemStack> plantables = this.plantableStacks.getItems();
        plantables.removeIf(plantable -> !plantable.isPlantable() || !this.plantingMode.includeEmptyStacks() && plantable.getStack().isEmpty());
        if (plantables.isEmpty()) {
            return false;
        }
        for (FarmerTile tile : this.blockMap) {
            BlockState state;
            int index = this.plantingMode.index(tile, plantables);
            PlantableConfigurableItemStack plantable2 = plantables.get(index);
            if (plantable2.getStack().isEmpty() || (state = tile.crop().state(this.level)) != state.getFluidState().createLegacyBlock()) continue;
            PlantingContext plantingContext = new PlantingContext(this.level, tile, plantable2.getStack().toStack());
            FarmerPlantable farmerPlantable = plantable2.asPlantable();
            if (!farmerPlantable.canPlant(plantingContext)) continue;
            plantable2.getStack().decrement(1L);
            farmerPlantable.plant(plantingContext);
            if (!this.operations.operate()) continue;
            return true;
        }
        return this.operations.didOperate();
    }
}

