/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.tesla;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.CableTierHolder;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.machines.component.tesla.AestheticTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.extended_industrialization.machines.guicomponent.teslanetwork.TeslaNetworkBar;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;
import org.joml.Vector3f;

public final class TeslaReceiverHatchBlockEntity
extends HatchBlockEntity
implements EnergyComponentHolder,
CableTierHolder,
TeslaReceiver.Delegate,
TeslaBehavior {
    private final CableTier tier;
    private final IsActiveComponent isActive;
    private final EnergyComponent energy;
    private final MIEnergyStorage insertable;
    private final AestheticTeslaCoilComponent aesthetic;
    private final TeslaReceiverComponent receiver;

    public TeslaReceiverHatchBlockEntity(BEP bep, CableTier tier) {
        super(bep, new MachineGuiParameters.Builder(EI.id("tesla_receiver_hatch"), false).build(), new OrientationComponent.Params(false, false, false));
        this.tier = tier;
        this.isActive = new IsActiveComponent();
        this.energy = new EnergyComponent((BlockEntity)this, () -> 600L * tier.getEu());
        this.insertable = this.energy.buildInsertable(other -> other == tier);
        this.aesthetic = new AestheticTeslaCoilComponent();
        this.receiver = new TeslaReceiverComponent((MachineBlockEntity)this, this.insertable, () -> true, () -> tier);
        this.registerComponents(new IComponent[]{this.isActive, this.energy, this.aesthetic, this.receiver});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(61, 34), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new TeslaNetworkBar.Server(new TeslaNetworkBar.Parameters(101, 34), () -> {
            if (this.hasNetwork()) {
                TeslaNetwork network = this.getNetwork();
                if (network.isTransmitterLoaded()) {
                    TeslaReceiverState state = this.checkReceiveFrom(network);
                    return Optional.of(new TeslaNetworkBar.ReceiverData(state, Optional.of(this.getNetworkKey()), Optional.of(network.getCableTier())));
                }
                return Optional.of(new TeslaNetworkBar.ReceiverData(TeslaReceiverState.UNLOADED_TRANSMITTER, Optional.of(this.getNetworkKey()), Optional.empty()));
            }
            return Optional.of(new TeslaNetworkBar.ReceiverData(TeslaReceiverState.NO_LINK, Optional.empty(), Optional.empty()));
        })});
        ConfigurationPanelBuilder configPanel = new ConfigurationPanelBuilder((Component)EIText.CONFIGURATION_PANEL.text(), (Component)EIText.CONFIGURATION_PANEL_DESCRIPTION.text().withStyle(MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))), (lineIndex, delta) -> this.sync());
        this.receiver.appendSelectionPanel((MachineBlockEntity)this, configPanel);
        this.aesthetic.appendSelectionPanel((MachineBlockEntity)this, configPanel);
        this.registerGuiComponent(new GuiComponent.Server[]{configPanel.build()});
    }

    private void onCasingUpdate(CableTier from, CableTier to) {
        if (this.level != null && !this.level.isClientSide()) {
            this.receiver.addToNetwork();
        }
    }

    @Override
    public boolean shouldTeslaRender() {
        return this.isActive.isActive;
    }

    @Override
    public ResourceLocation getTeslaModelLocation() {
        return EI.id("tesla/tesla_hatch");
    }

    @Override
    public Vector3f getTeslaColor() {
        return this.aesthetic.getColor();
    }

    @Override
    public TeslaReceiver getDelegateReceiver() {
        return this.receiver;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = super.getMachineModelData();
        data.isActive = this.isActive.isActive;
        return data;
    }

    @Override
    public CableTier getCableTier() {
        return this.tier;
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public HatchType getHatchType() {
        return HatchType.ENERGY_INPUT;
    }

    public boolean upgradesToSteel() {
        return false;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public void appendEnergyInputs(List<EnergyComponent> list) {
        list.add(this.energy);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        this.receiver.addToNetwork();
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).removeTesla(this.worldPosition);
            return;
        }
        this.receiver.removeFromNetwork();
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).tickTesla(this.worldPosition);
            return;
        }
        if (this.hasNetwork() && this.getNetwork().isTransmitterLoaded()) {
            TeslaNetwork network = this.getNetwork();
            this.isActive.updateActive(network.isTransmitterLoaded() && this.checkReceiveFrom(network).isSuccess(), (MachineBlockEntity)this);
        } else {
            this.isActive.updateActive(false, (MachineBlockEntity)this);
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.aesthetic.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        return List.of(MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_RECEIVER_HELP_1), MICompatibleTextLine.line((TranslatableTextEnum)EIText.TESLA_RECEIVER_HELP_2));
    }
}

