/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.machineconfig;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigApplicable;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigSlot;
import net.swedz.extended_industrialization.mixin.mi.accessor.ConfigurableItemStackAccessor;

public record MachineConfigSlots(List<MachineConfigSlot> slots, int itemSlotCount, int fluidSlotCount) implements MachineConfigApplicable<MachineBlockEntity>
{
    public static final Codec<MachineConfigSlots> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(MachineConfigSlot.CODEC).fieldOf("slots").forGetter(MachineConfigSlots::slots)).apply((Applicative)instance, slots -> {
        int itemSlotCount = 0;
        int fluidSlotCount = 0;
        for (MachineConfigSlot slot : slots) {
            if (slot instanceof MachineConfigSlot.ItemSlot) {
                ++itemSlotCount;
                continue;
            }
            if (!(slot instanceof MachineConfigSlot.FluidSlot)) continue;
            ++fluidSlotCount;
        }
        return new MachineConfigSlots((List<MachineConfigSlot>)slots, itemSlotCount, fluidSlotCount);
    }));

    public static MachineConfigSlots from(MachineBlockEntity machine) {
        MIInventory inventory = machine.getInventory();
        ArrayList slots = Lists.newArrayList();
        int itemIndex = 0;
        for (ConfigurableItemStack itemStack : inventory.getItemStacks()) {
            slots.add(new MachineConfigSlot.ItemSlot(itemIndex, itemStack.getAdjustedCapacity(), (Item)itemStack.getLockedInstance()));
            ++itemIndex;
        }
        int fluidIndex = 0;
        for (ConfigurableFluidStack fluidStack : inventory.getFluidStacks()) {
            slots.add(new MachineConfigSlot.FluidSlot(fluidIndex, (Fluid)fluidStack.getLockedInstance()));
            ++fluidIndex;
        }
        return new MachineConfigSlots(slots, itemIndex, fluidIndex);
    }

    @Override
    public boolean matches(MachineBlockEntity target) {
        return target.getInventory().getItemStacks().size() == this.itemSlotCount && target.getInventory().getFluidStacks().size() == this.fluidSlotCount;
    }

    @Override
    public boolean apply(Player player, MachineBlockEntity target, Simulation simulation) {
        if (!this.matches(target)) {
            return false;
        }
        boolean success = true;
        for (MachineConfigSlot slot : this.slots) {
            MachineConfigSlot.ItemSlot itemSlot;
            Object stack = slot.stack(target.getInventory());
            if (slot.lock() != null && stack.canPlayerLock() && !stack.playerLock(slot.lock(), simulation)) {
                success = false;
            }
            if (!(slot instanceof MachineConfigSlot.ItemSlot) || (itemSlot = (MachineConfigSlot.ItemSlot)slot).capacity() < 0) continue;
            ConfigurableItemStack itemStack = (ConfigurableItemStack)stack;
            if (itemStack.getAmount() <= (long)itemSlot.capacity()) {
                if (!simulation.isActing()) continue;
                ConfigurableItemStackAccessor capacityAccessor = (ConfigurableItemStackAccessor)stack;
                capacityAccessor.setAdjustedCapacity(itemSlot.capacity());
                continue;
            }
            success = false;
        }
        return success;
    }
}

