/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.entity.goal;

import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.network.packet.CatHammerPacket;

public final class MeowTradeGoal
extends Goal {
    private final Cat cat;
    private int ticks;
    private boolean hammered;
    private boolean poof2;
    private boolean poof3;
    private boolean turn;

    public MeowTradeGoal(Cat cat) {
        this.cat = cat;
    }

    private boolean isNanoHelmet(ItemStack stack) {
        return !stack.isEmpty() && (stack.is(EIItems.NANO_HELMET.asItem()) || stack.is(EIItems.NANO_QUANTUM_HELMET.asItem())) && (Boolean)stack.getOrDefault(EIComponents.MEOW, (Object)false) == false;
    }

    private List<ItemEntity> findItems() {
        return this.cat.level().getEntitiesOfClass(ItemEntity.class, this.cat.getBoundingBox().inflate(1.0, 1.0, 1.0), item -> item.getOwner() != null && item.getOwner().getUUID().equals(this.cat.getOwnerUUID()) && this.isNanoHelmet(item.getItem()));
    }

    private Player findOwnerNearby() {
        Player owner = this.cat.level().getPlayerByUUID(this.cat.getOwnerUUID());
        return owner != null && owner.isAlive() && owner.distanceTo((Entity)this.cat) <= 10.0f ? owner : null;
    }

    public boolean canUse() {
        return !this.cat.isLying() && this.cat.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.findItems().isEmpty();
    }

    public boolean canContinueToUse() {
        return this.isNanoHelmet(this.cat.getItemInHand(InteractionHand.MAIN_HAND)) && this.ticks < 100;
    }

    private void enforceSitting() {
        if (!this.cat.isOrderedToSit()) {
            this.cat.setOrderedToSit(true);
        }
    }

    public void start() {
        this.ticks = 0;
        this.hammered = false;
        this.poof2 = false;
        this.poof3 = false;
        this.turn = false;
        this.enforceSitting();
    }

    public void tick() {
        ItemStack heldItem;
        this.enforceSitting();
        if (!this.hammered && (double)this.ticks > 30.0) {
            this.cat.playSound(SoundEvents.ANVIL_USE, 1.0f, 1.0f);
            new CatHammerPacket(this.cat.getId()).broadcastToClients((ServerLevel)this.cat.level(), (Position)this.cat.position(), 32.0);
            this.hammered = true;
        }
        if (!this.poof2 && (double)this.ticks > 38.0) {
            new CatHammerPacket(this.cat.getId()).broadcastToClients((ServerLevel)this.cat.level(), (Position)this.cat.position(), 32.0);
            this.poof2 = true;
        }
        if (!this.poof3 && (double)this.ticks > 46.0) {
            new CatHammerPacket(this.cat.getId()).broadcastToClients((ServerLevel)this.cat.level(), (Position)this.cat.position(), 32.0);
            this.poof3 = true;
        }
        if ((heldItem = this.cat.getItemInHand(InteractionHand.MAIN_HAND)).isEmpty()) {
            List<ItemEntity> items = this.findItems();
            if (!items.isEmpty()) {
                ItemEntity item = items.getFirst();
                ItemStack itemStack = item.getItem().copy();
                this.cat.take((Entity)item, itemStack.getCount());
                this.cat.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
                item.discard();
                this.cat.onItemPickup(item);
                this.cat.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
                this.cat.playSound(SoundEvents.CAT_PURR, 1.0f, 1.0f);
            }
        } else {
            Player owner = this.findOwnerNearby();
            if (owner != null) {
                if (this.ticks < 60) {
                    double dx = owner.getX() - this.cat.getX();
                    double dz = owner.getZ() - this.cat.getZ();
                    double x = this.cat.getX() - dx;
                    double y = this.cat.getY() - 1.0;
                    double z = this.cat.getZ() - dz;
                    this.cat.getLookControl().setLookAt(x, y, z);
                } else {
                    if (!this.turn) {
                        this.cat.playSound(SoundEvents.CAT_PURR, 1.0f, 1.0f);
                        this.turn = true;
                    }
                    this.cat.getLookControl().setLookAt((Entity)owner);
                }
            }
        }
        this.ticks += 2;
    }

    public void stop() {
        this.drop();
        this.ticks = 0;
    }

    private void drop() {
        ItemStack stack = this.cat.getItemInHand(InteractionHand.MAIN_HAND);
        if (!stack.isEmpty() && this.isNanoHelmet(stack)) {
            Vec3 pos;
            this.cat.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            Player owner = this.findOwnerNearby();
            if (owner == null) {
                Vec3 randomPos = LandRandomPos.getPos((PathfinderMob)this.cat, (int)4, (int)2);
                pos = randomPos == null ? this.cat.position() : randomPos;
            } else {
                pos = owner.position();
                this.cat.getLookControl().setLookAt((Entity)owner);
            }
            stack.set(EIComponents.MEOW, (Object)true);
            BehaviorUtils.throwItem((LivingEntity)this.cat, (ItemStack)stack, (Vec3)pos.add(0.0, 2.0, 0.0));
            this.cat.playSound(SoundEvents.CAT_PURREOW, 1.0f, 1.0f);
        }
    }
}

