/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.api.energy.CableTier;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.datamap.EnchantmentModule;

public final class EIDamageTypes {
    private static final ResourceKey<DamageType> TESLA = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)EI.id("tesla"));

    private static Holder<DamageType> tesla(RegistryAccess registry) {
        return registry.lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(TESLA);
    }

    public static DamageSource tesla(Level level, Vec3 origin) {
        return new DamageSource(EIDamageTypes.tesla(level.registryAccess()), origin);
    }

    public static DamageSource tesla(Level level, Vec3 origin, Entity damager) {
        return new DamageSource(EIDamageTypes.tesla(level.registryAccess()), damager, damager, origin);
    }

    public static DamageSource teslaFakePlayer(Level level, Vec3 origin, UUID ownerUUID, Optional<EnchantmentModule> enchantment, CableTier tier) {
        FakePlayer damager = FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)new GameProfile(ownerUUID, "Tesla"));
        ItemStack item = ItemStack.EMPTY;
        if (enchantment.isPresent()) {
            item = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
            enchantment.get().applyEnchantment((HolderLookup.Provider)level.registryAccess(), item, tier);
        }
        damager.setItemInHand(InteractionHand.MAIN_HAND, item);
        return EIDamageTypes.tesla(level, origin, (Entity)damager);
    }
}

