/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.extended_industrialization.component.RainbowDataComponent;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfig;
import net.swedz.extended_industrialization.item.teslalinkable.SelectedTeslaNetwork;

public final class EIComponents {
    private static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"extended_industrialization");
    public static final Supplier<DataComponentType<Boolean>> HIDE_BAR = EIComponents.create("hide_bar", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final Supplier<DataComponentType<Integer>> SOLAR_TICKS = EIComponents.create("solar_ticks", ExtraCodecs.POSITIVE_INT, ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<MachineConfig>> MACHINE_CONFIG = EIComponents.create("machine_config", MachineConfig.CODEC, MachineConfig.STREAM_CODEC);
    public static final Supplier<DataComponentType<Integer>> ELECTRIC_TOOL_SPEED = EIComponents.create("electric_tool_speed", ExtraCodecs.intRange((int)1, (int)10), ByteBufCodecs.VAR_INT);
    public static final Supplier<DataComponentType<Boolean>> ACTIVATED = EIComponents.create("activated", Codec.BOOL, ByteBufCodecs.BOOL);
    public static final Supplier<DataComponentType<RainbowDataComponent>> RAINBOW = EIComponents.create("rainbow", RainbowDataComponent.CODEC, RainbowDataComponent.STREAM_CODEC);
    public static final Supplier<DataComponentType<SelectedTeslaNetwork>> SELECTED_TESLA_NETWORK = EIComponents.create("selected_tesla_network", SelectedTeslaNetwork.CODEC, SelectedTeslaNetwork.STREAM_CODEC);
    public static final Supplier<DataComponentType<Boolean>> MEOW = EIComponents.create("meow", Codec.BOOL, ByteBufCodecs.BOOL);

    public static void init(IEventBus bus) {
        COMPONENTS.register(bus);
    }

    private static <D> DeferredHolder<DataComponentType<?>, DataComponentType<D>> create(String name, Codec<D> codec, StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec) {
        return COMPONENTS.registerComponentType(name, b -> b.persistent(codec).networkSynchronized(streamCodec));
    }
}

