/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.inventory.ILockable;
import com.buuz135.functionalstorage.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class BigInventoryHandler
implements IItemHandler,
INBTSerializable<CompoundTag>,
ILockable {
    public static String BIG_ITEMS = "BigItems";
    public static String STACK = "Stack";
    public static String AMOUNT = "Amount";
    private final FunctionalStorage.DrawerType type;
    private final List<BigStack> storedStacks;

    public BigInventoryHandler(FunctionalStorage.DrawerType type) {
        this.type = type;
        this.storedStacks = new ArrayList<BigStack>();
        for (int i = 0; i < type.getSlots(); ++i) {
            this.storedStacks.add(i, new BigStack(ItemStack.EMPTY, 0));
        }
    }

    public int getSlots() {
        if (this.isVoid()) {
            return this.type.getSlots() + 1;
        }
        return this.type.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.type.getSlots() == slot) {
            return ItemStack.EMPTY;
        }
        BigStack bigStack = this.storedStacks.get(slot);
        if (this.isCreative()) {
            return bigStack.slotStack.copyWithCount(Integer.MAX_VALUE);
        }
        return bigStack.slotStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isVoid() && this.type.getSlots() == slot && this.isVoidValid(stack) || this.isVoidValid(stack) && this.isCreative()) {
            return ItemStack.EMPTY;
        }
        if (this.isValid(slot, stack)) {
            BigStack bigStack = this.storedStacks.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) - bigStack.getAmount(), stack.getCount());
            if (!simulate) {
                if (bigStack.getStack().isEmpty()) {
                    bigStack.setStack(stack.copyWithCount(stack.getMaxStackSize()));
                }
                bigStack.setAmount(Math.min(bigStack.getAmount() + inserted, this.getSlotLimit(slot)));
                this.onChange();
            }
            if (inserted == stack.getCount() || this.isVoid()) {
                return ItemStack.EMPTY;
            }
            return stack.copyWithCount(stack.getCount() - inserted);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.type.getSlots() == slot) {
            return ItemStack.EMPTY;
        }
        if (slot < this.type.getSlots()) {
            BigStack bigStack = this.storedStacks.get(slot);
            if (bigStack.getStack().isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!this.isCreative() && bigStack.getAmount() <= amount) {
                ItemStack out = bigStack.getStack().copy();
                int newAmount = bigStack.getAmount();
                if (!simulate && !this.isCreative()) {
                    if (!this.isLocked()) {
                        bigStack.setStack(ItemStack.EMPTY);
                    }
                    bigStack.setAmount(0);
                    this.onChange();
                }
                out.setCount(newAmount);
                return out;
            }
            if (!simulate && !this.isCreative()) {
                bigStack.setAmount(bigStack.getAmount() - amount);
                this.onChange();
            }
            return bigStack.getStack().copyWithCount(amount);
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        if (this.type.getSlots() == slot) {
            return Integer.MAX_VALUE;
        }
        double stackSize = 1.0;
        if (!this.getStoredStacks().get(slot).getStack().isEmpty()) {
            stackSize = (double)this.getStoredStacks().get(slot).getStack().getMaxStackSize() / 64.0;
        }
        return (int)Math.floor(this.getTotalAmount() * stackSize);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.isEmpty();
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.type.getSlots()) {
            BigStack bigStack = this.storedStacks.get(slot);
            ItemStack fl = bigStack.getStack();
            if (this.isLocked() && fl.isEmpty()) {
                return false;
            }
            return fl.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    private boolean isVoidValid(ItemStack stack) {
        for (BigStack storedStack : this.storedStacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)storedStack.getStack(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.storedStacks.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.put(STACK, this.storedStacks.get(i).getStack().saveOptional(provider));
            bigStack.putInt(AMOUNT, this.storedStacks.get(i).getAmount());
            items.put("" + i, (Tag)bigStack);
        }
        compoundTag.put(BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        for (String allKey : nbt.getCompound(BIG_ITEMS).getAllKeys()) {
            this.storedStacks.get(Integer.parseInt(allKey)).setStack(Utils.deserialize(provider, nbt.getCompound(BIG_ITEMS).getCompound(allKey).getCompound(STACK)));
            this.storedStacks.get(Integer.parseInt(allKey)).setAmount(nbt.getCompound(BIG_ITEMS).getCompound(allKey).getInt(AMOUNT));
        }
    }

    public abstract void onChange();

    public abstract int getMultiplier();

    public double getTotalAmount() {
        return 64.0 * (double)this.getMultiplier();
    }

    public abstract boolean isVoid();

    @Override
    public abstract boolean isLocked();

    public abstract boolean isCreative();

    public List<BigStack> getStoredStacks() {
        return this.storedStacks;
    }

    public static class BigStack {
        private ItemStack stack;
        private ItemStack slotStack;
        private int amount;

        public BigStack(ItemStack stack, int amount) {
            this.stack = stack.copy();
            this.amount = amount;
            this.slotStack = stack.copyWithCount(amount);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack.copy();
            this.slotStack = stack.copyWithCount(this.amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
            this.slotStack.setCount(amount);
        }
    }
}

