/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.NetworkCapability;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceItem
extends PartTypeInterfacePositionedAddon<IItemNetwork, IItemHandler, PartTypeInterfaceItem, State> {
    public PartTypeInterfaceItem(String name) {
        super(name);
    }

    @Override
    public NetworkCapability<IItemNetwork> getNetworkCapability() {
        return Capabilities.ItemNetwork.NETWORK;
    }

    @Override
    public PartCapability<IItemHandler> getPartCapability() {
        return Capabilities.ItemHandler.PART;
    }

    @Override
    public BlockCapability<IItemHandler, Direction> getBlockCapability() {
        return Capabilities.ItemHandler.BLOCK;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceItemBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<IItemNetwork, IItemHandler, PartTypeInterfaceItem, State> {
        @Override
        public PartCapability<IItemHandler> getTargetCapability() {
            return Capabilities.ItemHandler.PART;
        }

        @Override
        public IItemHandler getCapabilityInstance() {
            return new ItemHandler(this);
        }

        @Override
        public <T> Optional<T> getCapability(PartTypeInterfaceItem partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            if (this.isNetworkAndPositionValid() && capability == Capabilities.ItemHandler.PART) {
                return Optional.of(this.getCapabilityInstance());
            }
            return super.getCapability(partType, capability, network, partNetwork, target);
        }
    }

    public static class ItemHandler
    implements IItemHandler,
    ISlotlessItemHandler {
        private final IPartTypeInterfacePositionedAddon.IState<IItemNetwork, IItemHandler, ?, ?> state;

        public ItemHandler(IPartTypeInterfacePositionedAddon.IState<IItemNetwork, IItemHandler, ?, ?> state) {
            this.state = state;
        }

        protected IItemHandler getItemHandler() {
            return (IItemHandler)this.state.getPositionedAddonsNetwork().getChannelExternal(Capabilities.ItemHandler.BLOCK, this.state.getChannel());
        }

        public int getSlots() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getItemHandler().getSlots();
            this.state.enablePosition();
            return ret;
        }

        public ItemStack getStackInSlot(int slot) {
            if (!this.state.isNetworkAndPositionValid()) {
                return ItemStack.EMPTY;
            }
            this.state.disablePosition();
            ItemStack ret = this.getItemHandler().getStackInSlot(slot);
            this.state.enablePosition();
            return ret;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return stack;
            }
            this.state.disablePosition();
            ItemStack ret = this.getItemHandler().insertItem(slot, stack, simulate);
            this.state.enablePosition();
            return ret;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return ItemStack.EMPTY;
            }
            this.state.disablePosition();
            ItemStack ret = this.getItemHandler().extractItem(slot, amount, simulate);
            this.state.enablePosition();
            return ret;
        }

        public int getSlotLimit(int slot) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getItemHandler().getSlotLimit(slot);
            this.state.enablePosition();
            return ret;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!this.state.isNetworkAndPositionValid()) {
                return false;
            }
            this.state.disablePosition();
            boolean ret = this.getItemHandler().isItemValid(slot, stack);
            this.state.enablePosition();
            return ret;
        }

        public Iterator<ItemStack> getItems() {
            Iterator ret;
            if (!this.state.isNetworkAndPositionValid()) {
                return Iterators.forArray((Object[])new ItemStack[0]);
            }
            this.state.disablePosition();
            if (!this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).iterator().hasNext()) {
                ret = this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).iterator();
            } else {
                IItemNetwork network = this.state.getPositionedAddonsNetwork();
                ret = Iterators.concat((Iterator[])((Iterator[])network.getPositions(this.state.getChannel()).stream().filter(pos -> !network.isPositionDisabled((PartPos)pos)).map(arg_0 -> ((IItemNetwork)network).getRawInstances(arg_0)).toArray(Iterator[]::new)));
            }
            this.state.enablePosition();
            return ret;
        }

        public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
            if (!this.state.isNetworkAndPositionValid()) {
                return Iterators.forArray((Object[])new ItemStack[0]);
            }
            this.state.disablePosition();
            Object ret = !this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).iterator((Object)stack, (Object)matchFlags).hasNext() ? this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).iterator((Object)stack, (Object)matchFlags) : new FilteredIngredientCollectionIterator(this.getItems(), IngredientComponents.ITEMSTACK.getMatcher(), (Object)stack, (Object)matchFlags);
            this.state.enablePosition();
            return ret;
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return stack;
            }
            this.state.disablePosition();
            ItemStack ret = (ItemStack)this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).insert((Object)stack, simulate);
            this.state.enablePosition();
            return ret;
        }

        public ItemStack extractItem(int amount, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return ItemStack.EMPTY;
            }
            this.state.disablePosition();
            ItemStack ret = (ItemStack)this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).extract((long)amount, simulate);
            this.state.enablePosition();
            return ret;
        }

        public ItemStack extractItem(ItemStack matchStack, int matchFlags, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return ItemStack.EMPTY;
            }
            this.state.disablePosition();
            ItemStack ret = (ItemStack)this.state.getPositionedAddonsNetwork().getChannel(this.state.getChannelInterface()).extract((Object)matchStack, (Object)matchFlags, simulate);
            this.state.enablePosition();
            return ret;
        }

        public int getLimit() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int limit = 0;
            IItemHandler itemHandler = this.getItemHandler();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                limit += itemHandler.getSlotLimit(i);
            }
            this.state.enablePosition();
            return limit;
        }
    }
}

