/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.integratedtunnels.GeneralConfig;

public class ItemHandlerWorldEntityExportWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final ServerLevel world;
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final int lifespan;
    private final int delayBeforePickup;
    private final Direction facing;
    private final double velocity;
    private final float yawOffset;
    private final float pitchOffset;
    private final boolean dispense;
    private final IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler;
    private static final DefaultDispenseItemBehavior DISPENSE_ITEM_DIRECTLY = new DefaultDispenseItemBehavior();

    public ItemHandlerWorldEntityExportWrapper(ServerLevel world, BlockPos pos, double offsetX, double offsetY, double offsetZ, int lifespan, int delayBeforePickup, Direction facing, double velocity, double yawOffset, double pitchOffset, boolean dispense, IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler) {
        this.world = world;
        this.pos = pos;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.lifespan = lifespan;
        this.delayBeforePickup = delayBeforePickup;
        this.facing = facing;
        this.velocity = velocity;
        this.yawOffset = (float)yawOffset;
        this.pitchOffset = (float)pitchOffset;
        this.dispense = dispense;
        this.dispenseResultHandler = dispenseResultHandler;
    }

    protected void setThrowableHeading(ItemEntity entity, double x, double y, double z, double velocity) {
        float f = Mth.sqrt((float)((float)(x * x + y * y + z * z)));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        entity.setDeltaMovement(new Vec3(x *= velocity, y *= velocity, z *= velocity));
        float f1 = Mth.sqrt((float)((float)(x * x + z * z)));
        entity.yRotO = (float)(Mth.atan2((double)x, (double)z) * 57.29577951308232);
        entity.xRotO = (float)(Mth.atan2((double)y, (double)f1) * 57.29577951308232);
        entity.yRotO = entity.yRotO;
        entity.xRotO = entity.xRotO;
    }

    protected static void handleDispenseResult(IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler, BlockSource blockSource, ItemStack itemStack) {
        ItemStack remaining = (ItemStack)dispenseResultHandler.insert((Object)itemStack, false);
        if (!remaining.isEmpty()) {
            DISPENSE_ITEM_DIRECTLY.dispense(blockSource, remaining);
        }
    }

    public BlockSource getBlockSource() {
        Wrapper blockSourceWrapper = new Wrapper();
        blockSourceWrapper.set((Object)new BlockSource(this.world, this.getPos().offset((int)this.offsetX, (int)this.offsetY, (int)this.offsetZ), this.getBlockState(), (DispenserBlockEntity)new SimulatedTileEntityDispenser(this.dispenseResultHandler, () -> ((Wrapper)blockSourceWrapper).get())));
        return (BlockSource)blockSourceWrapper.get();
    }

    public BlockPos getPos() {
        return this.pos.relative(this.facing.getOpposite());
    }

    public BlockState getBlockState() {
        return (BlockState)((BlockState)Blocks.DISPENSER.defaultBlockState().setValue((Property)DispenserBlock.TRIGGERED, (Comparable)Boolean.valueOf(false))).setValue((Property)DispenserBlock.FACING, (Comparable)this.facing);
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 64L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (!simulate) {
            DispenseItemBehavior behaviorDispenseItem;
            if (this.dispense && (behaviorDispenseItem = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(stack.getItem())).getClass() != DefaultDispenseItemBehavior.class) {
                BlockSource blockSource = this.getBlockSource();
                ItemStack result = behaviorDispenseItem.dispense(blockSource, stack.copy());
                if (!result.isEmpty()) {
                    ItemHandlerWorldEntityExportWrapper.handleDispenseResult(this.dispenseResultHandler, blockSource, result);
                }
                return ItemStack.EMPTY;
            }
            ItemEntity entity = new ItemEntity((Level)this.world, (double)this.pos.getX() + this.offsetX, (double)this.pos.getY() + this.offsetY, (double)this.pos.getZ() + this.offsetZ, stack.copy());
            entity.lifespan = this.lifespan <= 0 ? stack.getItem().getEntityLifespan(stack, (Level)this.world) : this.lifespan;
            float yaw = this.facing.toYRot() + this.yawOffset;
            float pitch = (this.facing == Direction.UP ? -90.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f)) - this.pitchOffset;
            this.setThrowableHeading(entity, -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))), -Mth.sin((float)(pitch * ((float)Math.PI / 180))), Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))), this.velocity);
            entity.setPickUpDelay(this.delayBeforePickup);
            this.world.addFreshEntity((Entity)entity);
            if (GeneralConfig.worldInteractionEvents) {
                this.world.levelEvent(1000, this.pos, 0);
                this.world.levelEvent(2000, this.pos.relative(this.facing.getOpposite()), this.facing.get3DDataValue());
            }
        } else if (this.dispense) {
            stack = stack.copy();
            stack.split(1);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.EMPTY;
    }

    protected static class SimulatedTileEntityDispenser
    extends DispenserBlockEntity {
        private final IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler;
        private final Supplier<BlockSource> blockSource;

        public SimulatedTileEntityDispenser(IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler, Supplier<BlockSource> blockSource) {
            super(BlockPos.ZERO, Blocks.DISPENSER.defaultBlockState());
            this.dispenseResultHandler = dispenseResultHandler;
            this.blockSource = blockSource;
        }

        public int getContainerSize() {
            return 0;
        }

        public int getRandomSlot(RandomSource randomSource) {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public ItemStack insertItem(ItemStack stack) {
            ItemHandlerWorldEntityExportWrapper.handleDispenseResult(this.dispenseResultHandler, this.blockSource.get(), stack);
            return ItemStack.EMPTY;
        }

        protected NonNullList<ItemStack> getItems() {
            return NonNullList.create();
        }
    }
}

