/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class Helper
extends de.teamlapen.vampirism.util.Helper {
    public static boolean isWerewolf(Entity entity) {
        Player player;
        return entity instanceof Player && Helper.isWerewolf(player = (Player)entity) || WReference.WEREWOLF_FACTION.equals((Object)VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isWerewolf(Player entity) {
        return WReference.WEREWOLF_FACTION.equals((Object)VampirismAPI.factionPlayerHandler((Player)entity).getCurrentFaction());
    }

    public static boolean hasFaction(Entity entity) {
        if (VampirismAPI.factionRegistry().getFaction(entity) != null) {
            return true;
        }
        return Helper.isWerewolf(entity);
    }

    public static BlockPos multiplyBlockPos(BlockPos pos, double amount) {
        return new BlockPos((int)((double)pos.getX() * amount), (int)((double)pos.getY() * amount), (int)((double)pos.getZ() * amount));
    }

    public static boolean canBecomeWerewolf(Player player) {
        return FactionPlayerHandler.get((Player)player).canJoin(WReference.WEREWOLF_FACTION);
    }

    public static boolean isNight(Level world) {
        long time = world.getDayTime() % 24000L;
        return !world.dimensionType().hasFixedTime() && time > 12786L && time < 23216L;
    }

    public static boolean isFullMoon(Level world) {
        long time = world.getDayTime() % 192000L;
        return !world.dimensionType().hasFixedTime() && time > 12786L && time < 23216L;
    }

    public static Map<Item, Integer> getMissingItems(Container inventory, Item[] items, int[] amount) {
        int i;
        HashMap<Item, Integer> missing = new HashMap<Item, Integer>();
        for (i = 0; i < items.length; ++i) {
            missing.put(items[i], amount[i]);
        }
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            missing.computeIfPresent(stack.getItem(), (item, amount1) -> amount1 - stack.getCount());
        }
        missing.entrySet().removeIf(s -> (Integer)s.getValue() <= 0);
        return missing;
    }

    @Deprecated
    public static boolean canWerewolfEatItem(LivingEntity entity, ItemStack stack) {
        return Helper.isMeat(entity, stack);
    }

    @Deprecated
    public static boolean canWerewolfPlayerEatItem(Player player, ItemStack stack) {
        return Helper.canWerewolfEatItem((LivingEntity)player, stack) || WerewolfPlayer.getOpt(player).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.NOT_MEAT.get())).orElse(false) != false;
    }

    public static boolean isMeat(@Nullable LivingEntity entity, ItemStack stack) {
        return stack.getFoodProperties(entity) != null && (stack.is(ModTags.Items.WEREWOLF_FOOD) || WerewolvesConfig.SERVER.isCustomMeatItems(stack.getItem()));
    }

    @Deprecated
    public static boolean isMeat(ItemStack stack) {
        return Helper.isMeat(null, stack);
    }

    public static boolean isRawMeat(@Nullable LivingEntity entity, ItemStack stack) {
        return Helper.isMeat(entity, stack) && (stack.is(ModTags.Items.RAW_FOOD) || WerewolvesConfig.SERVER.isCustomRawMeatItems(stack.getItem()));
    }

    @Deprecated
    public static boolean isRawMeat(ItemStack stack) {
        return Helper.isRawMeat(null, stack);
    }

    public static boolean isRawMeatSkipMeat(ItemStack stack) {
        return stack.is(ModTags.Items.RAW_FOOD);
    }

    public static boolean canEat(LivingEntity entity, ItemStack stack) {
        Player player;
        return Helper.isMeat(entity, stack) || !(entity instanceof Player) || !Helper.isWerewolf(player = (Player)entity) || WerewolfPlayer.get(player).getSkillHandler().isSkillEnabled((ISkill)ModSkills.NOT_MEAT.get());
    }

    public static Optional<IWerewolf> asIWerewolf(LivingEntity entity) {
        if (entity instanceof IWerewolf) {
            IWerewolf werewolf = (IWerewolf)entity;
            return Optional.of(werewolf);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Optional.of(WerewolfPlayer.get(player));
        }
        return Optional.empty();
    }

    public static boolean matchesItem(Ingredient ingredient, ItemStack searchStack) {
        return Arrays.stream(ingredient.getItems()).anyMatch(stack -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)searchStack) && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)searchStack));
    }

    public static MutableComponent joinComponents(String delimiter, MutableComponent ... components) {
        MutableComponent comp = components[0];
        for (int i = 1; i < components.length; ++i) {
            comp.append(delimiter).append((Component)components[i]);
        }
        return comp;
    }

    public static boolean isSilverItem(ItemStack stack) {
        return stack.getItem() instanceof ISilverItem || stack.is(ModTags.Items.SILVER_ITEM);
    }

    public static boolean isNoLiving(LivingEntity entity) {
        return entity.isInvertedHealAndHarm() || Helper.isVampire((Entity)entity);
    }
}

