/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.api.WResourceLocation;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BeastWerewolfFormAction
extends WerewolfFormAction {
    public BeastWerewolfFormAction() {
        super(WerewolfForm.BEAST);
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)ModAttributes.BITE_DAMAGE, WResourceLocation.mod("beast_form_claw_damage")).withValues((Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_bite_damage, AttributeModifier.Operation.ADD_VALUE).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)Attributes.MAX_HEALTH, WResourceLocation.mod("beast_form_health")).withDayModifier(0.5).withValues((Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_health, AttributeModifier.Operation.ADD_VALUE).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)Attributes.ARMOR, WResourceLocation.mod("beast_form_armor")).withDayModifier(0.7).withValues((Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor, AttributeModifier.Operation.ADD_VALUE).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, WResourceLocation.mod("beast_form_armor_toughness")).withDayModifier(0.7).withValues((Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor_toughness, AttributeModifier.Operation.ADD_VALUE).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)Attributes.MOVEMENT_SPEED, WResourceLocation.mod("beast_form_speed_amount")).withDayModifier(0.5).withValues(() -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_speed_amount.get() * 0.8, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).withSkillModifier((Supplier<? extends ISkill<?>>)ModSkills.SPEED, (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_speed_amount).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)Attributes.ATTACK_DAMAGE, WResourceLocation.mod("beast_form_attack_damage")).withValues(() -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_attack_damage.get() * 0.5, AttributeModifier.Operation.ADD_VALUE).withDayModifier(0.5).withSkillModifier((Supplier<? extends ISkill<?>>)ModSkills.DAMAGE, (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_attack_damage).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)ModAttributes.FOOD_CONSUMPTION, WResourceLocation.mod("beast_form_food_consumption")).withValues((Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_food_consumption, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build());
        this.attributes.add(new WerewolfFormAction.Modifier.Builder((Holder<Attribute>)ModAttributes.FOOD_GAIN, WResourceLocation.mod("beast_form_food_gain")).withValues(() -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_food_gain.get() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).build());
    }

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.beast_form_enabled.get();
    }

    public int getCooldown(IWerewolfPlayer werewolf) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.beast_form_cooldown.get() * 20;
    }

    @Override
    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = super.getTimeModifier(werewolf);
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_BEAST_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_BEAST_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_beast_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_beast_1.get() * 20);
        }
        return limit;
    }

    @Override
    public boolean usesTransformationTime(IWerewolfPlayer werewolf) {
        return super.usesTransformationTime(werewolf) && (!werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_RAGE.get()) || !werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.RAGE.get()));
    }

    @Override
    public void checkDayNightModifier(IWerewolfPlayer werewolfPlayer) {
        if (werewolfPlayer.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_RAGE.get()) && werewolfPlayer.getActionHandler().isActionActive((ILastingAction)ModActions.RAGE.get())) {
            this.checkDayNightModifier(werewolfPlayer, true);
        } else {
            super.checkDayNightModifier(werewolfPlayer);
        }
    }

    @Override
    public boolean consumesWerewolfTime(IWerewolfPlayer werewolf) {
        return !werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.RAGE.get()) || !werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.BEAST_RAGE.get());
    }
}

