/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.werewolves.blocks.WolfsbaneBlock;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModDamageTypes;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.core.ModTasks;
import de.teamlapen.werewolves.core.ModVillage;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.extensions.ITagAppenderExtension;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModTagsProvider {
    public static void register(DataGenerator gen, @NotNull GatherDataEvent event, PackOutput output, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper existingFileHelper) {
        ModBlockTagsProvider blocks = new ModBlockTagsProvider(output, future, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blocks);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, future, blocks.contentsGetter(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModPoiTypesProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModVillageProfessionProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModTasksTagProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModEntityTagProvider(output, future, existingFileHelper));
    }

    private static class ModBlockTagsProvider
    extends BlockTagsProvider {
        public ModBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderLookup) {
            this.tag(ModTags.Blocks.SILVER_ORE).add((Object[])new Block[]{(Block)ModBlocks.SILVER_ORE.get(), (Block)ModBlocks.DEEPSLATE_SILVER_ORE.get()});
            this.tag(BlockTags.LOGS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_LOG.get(), (Block)ModBlocks.MAGIC_LOG.get()});
            this.tag(BlockTags.SAPLINGS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_SAPLING.get(), (Block)ModBlocks.MAGIC_SAPLING.get()});
            this.tag(BlockTags.LEAVES).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_LEAVES.get(), (Block)ModBlocks.MAGIC_LEAVES.get()});
            this.tag(BlockTags.PLANKS).add((Object)((Block)ModBlocks.MAGIC_PLANKS.get()));
            this.tag(BlockTags.CAMPFIRES).add((Object[])new Block[]{(Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get(), (Block)ModBlocks.STONE_ALTAR.get()});
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)ModBlocks.STONE_ALTAR.get(), (Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get(), (Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), (Block)ModBlocks.SILVER_ORE.get(), (Block)ModBlocks.SILVER_BLOCK.get(), (Block)ModBlocks.RAW_SILVER_BLOCK.get()});
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_LOG.get(), (Block)ModBlocks.MAGIC_LOG.get(), (Block)ModBlocks.MAGIC_PLANKS.get()});
            this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object[])new Block[]{(Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), (Block)ModBlocks.SILVER_ORE.get(), (Block)ModBlocks.SILVER_BLOCK.get(), (Block)ModBlocks.RAW_SILVER_BLOCK.get()});
            this.tag(Tags.Blocks.ORE_RATES_SINGULAR).add((Object[])new Block[]{(Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), (Block)ModBlocks.SILVER_ORE.get()});
            this.tag(ModTags.Blocks.STORAGE_BLOCKS_SILVER).add((Object)((Block)ModBlocks.SILVER_BLOCK.get()));
            this.tag(ModTags.Blocks.STORAGE_BLOCKS_RAW_SILVER).add((Object)((Block)ModBlocks.RAW_SILVER_BLOCK.get()));
            this.tag(ModTags.Blocks.MAGIC_LOG).add((Object[])new Block[]{(Block)ModBlocks.MAGIC_LOG.get(), (Block)ModBlocks.STRIPPED_MAGIC_LOG.get(), (Block)ModBlocks.MAGIC_WOOD.get(), (Block)ModBlocks.STRIPPED_MAGIC_WOOD.get()});
            this.tag(ModTags.Blocks.JACARANDA_LOG).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_LOG.get(), (Block)ModBlocks.STRIPPED_JACARANDA_LOG.get(), (Block)ModBlocks.JACARANDA_WOOD.get(), (Block)ModBlocks.STRIPPED_JACARANDA_WOOD.get()});
            this.tag(BlockTags.FLOWER_POTS).add((Object[])new Block[]{(Block)ModBlocks.POTTED_WOLFSBANE.get(), (Block)ModBlocks.POTTED_DAFFODIL.get()});
            this.tag(BlockTags.LEAVES).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_LEAVES.get(), (Block)ModBlocks.MAGIC_LEAVES.get()});
            this.tag(BlockTags.SAPLINGS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_SAPLING.get(), (Block)ModBlocks.MAGIC_SAPLING.get()});
            this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_TRAPDOOR.get(), (Block)ModBlocks.MAGIC_TRAPDOOR.get()});
            this.tag(BlockTags.WOODEN_DOORS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_DOOR.get(), (Block)ModBlocks.MAGIC_DOOR.get()});
            this.tag(BlockTags.PLANKS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_PLANKS.get(), (Block)ModBlocks.MAGIC_PLANKS.get()});
            this.tag(BlockTags.WOODEN_BUTTONS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_BUTTON.get(), (Block)ModBlocks.MAGIC_BUTTON.get()});
            this.tag(BlockTags.WOODEN_STAIRS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_STAIRS.get(), (Block)ModBlocks.MAGIC_STAIRS.get()});
            this.tag(BlockTags.WOODEN_SLABS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_SLAB.get(), (Block)ModBlocks.MAGIC_SLAB.get()});
            this.tag(BlockTags.WOODEN_FENCES).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_FENCE.get(), (Block)ModBlocks.MAGIC_FENCE.get()});
            this.tag(BlockTags.LOGS_THAT_BURN).addTags(new TagKey[]{ModTags.Blocks.MAGIC_LOG, ModTags.Blocks.JACARANDA_LOG});
            this.tag(BlockTags.LOGS).addTags(new TagKey[]{ModTags.Blocks.MAGIC_LOG, ModTags.Blocks.JACARANDA_LOG});
            this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_PRESSURE_PLATE.get(), (Block)ModBlocks.MAGIC_PRESSURE_PLATE.get()});
            this.tag(BlockTags.WOODEN_DOORS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_DOOR.get(), (Block)ModBlocks.MAGIC_DOOR.get()});
            this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object[])new Block[]{(Block)ModBlocks.JACARANDA_TRAPDOOR.get(), (Block)ModBlocks.MAGIC_TRAPDOOR.get()});
            this.tag(BlockTags.MINEABLE_WITH_SHOVEL);
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)ModBlocks.WOLFSBANE_DIFFUSER.get())).add((Object)((Block)ModBlocks.WOLFSBANE_DIFFUSER_LONG.get())).add((Object)((Block)ModBlocks.WOLFSBANE_DIFFUSER_IMPROVED.get()));
            this.tag(BlockTags.MINEABLE_WITH_AXE);
            this.tag(BlockTags.MINEABLE_WITH_HOE);
            this.tag(BlockTags.NEEDS_STONE_TOOL);
            this.tag(BlockTags.NEEDS_IRON_TOOL);
            this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object)((Block)ModBlocks.WOLFSBANE_DIFFUSER.get())).add((Object)((Block)ModBlocks.WOLFSBANE_DIFFUSER_LONG.get())).add((Object)((Block)ModBlocks.WOLFSBANE_DIFFUSER_IMPROVED.get()));
            this.tag(ModTags.Blocks.INCORRECT_FOR_SILVER_TOOL).addTag(BlockTags.NEEDS_DIAMOND_TOOL);
        }
    }

    private static class ModItemTagsProvider
    extends ItemTagsProvider {
        public ModItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagsProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderProvider) {
            this.copy(ModTags.Blocks.SILVER_ORE, ModTags.Items.SILVER_ORE);
            this.copy(ModTags.Blocks.STORAGE_BLOCKS_RAW_SILVER, ModTags.Items.STORAGE_BLOCKS_RAW_SILVER);
            this.copy(ModTags.Blocks.STORAGE_BLOCKS_SILVER, ModTags.Items.STORAGE_BLOCKS_SILVER);
            this.copy(ModTags.Blocks.MAGIC_LOG, ModTags.Items.MAGIC_LOG);
            this.copy(ModTags.Blocks.JACARANDA_LOG, ModTags.Items.JACARANDA_LOG);
            this.copy(Tags.Blocks.ORE_RATES_SINGULAR, Tags.Items.ORE_RATES_SINGULAR);
            this.copy(BlockTags.LOGS_THAT_BURN, ItemTags.LOGS_THAT_BURN);
            this.copy(BlockTags.LOGS, ItemTags.LOGS);
            this.copy(BlockTags.WOODEN_TRAPDOORS, ItemTags.WOODEN_TRAPDOORS);
            this.copy(BlockTags.WOODEN_STAIRS, ItemTags.WOODEN_STAIRS);
            this.copy(BlockTags.WOODEN_SLABS, ItemTags.WOODEN_SLABS);
            this.copy(BlockTags.WOODEN_PRESSURE_PLATES, ItemTags.WOODEN_PRESSURE_PLATES);
            this.copy(BlockTags.WOODEN_FENCES, ItemTags.WOODEN_FENCES);
            this.copy(BlockTags.WOODEN_DOORS, ItemTags.WOODEN_DOORS);
            this.copy(BlockTags.WOODEN_BUTTONS, ItemTags.WOODEN_BUTTONS);
            this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
            this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
            this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
            this.tag(ModTags.Items.SILVER_INGOT).add((Object)((Item)ModItems.SILVER_INGOT.get()));
            this.tag(ModTags.Items.SILVER_NUGGET).add((Object)((Item)ModItems.SILVER_NUGGET.get()));
            this.tag(ModTags.Items.RAW_MEAT).add((Object[])new Item[]{Items.BEEF, Items.CHICKEN, Items.MUTTON, Items.PORKCHOP, Items.RABBIT, (Item)ModItems.LIVER.get(), (Item)ModItems.V.HUMAN_HEART.get(), (Item)ModItems.V.WEAK_HUMAN_HEART.get(), Items.SALMON, Items.TROPICAL_FISH, Items.COD});
            this.tag(ModTags.Items.COOKED_MEAT).add((Object[])new Item[]{Items.COOKED_BEEF, Items.COOKED_CHICKEN, Items.COOKED_MUTTON, Items.COOKED_PORKCHOP, Items.COOKED_PORKCHOP, Items.COOKED_COD, Items.COOKED_SALMON});
            this.tag(ModTags.Items.RAW_FISH).add((Object[])new Item[]{Items.COD, Items.SALMON, Items.PUFFERFISH, Items.TROPICAL_FISH});
            this.tag(ModTags.Items.COOKED_FISH).add((Object[])new Item[]{Items.COOKED_COD, Items.COOKED_SALMON});
            this.tag(ModTags.Items.SILVER_TOOL).add((Object[])new Item[]{(Item)ModItems.SILVER_AXE.get(), (Item)ModItems.SILVER_HOE.get(), (Item)ModItems.SILVER_SWORD.get(), (Item)ModItems.SILVER_PICKAXE.get(), (Item)ModItems.SILVER_SHOVEL.get()});
            this.tag(ModTags.Items.RAW_MATERIALS_SILVER).add((Object)((Item)ModItems.RAW_SILVER.get()));
            this.tag(ItemTags.SMALL_FLOWERS).add((Object[])new Item[]{((WolfsbaneBlock)((Object)ModBlocks.WOLFSBANE.get())).asItem(), ((Block)ModBlocks.DAFFODIL.get()).asItem()});
            this.tag(ItemTags.BOATS).add((Object[])new Item[]{(Item)ModItems.JACARANDA_BOAT.get(), (Item)ModItems.MAGIC_BOAT.get()});
            this.tag(ItemTags.CHEST_BOATS).add((Object[])new Item[]{(Item)ModItems.JACARANDA_CHEST_BOAT.get(), (Item)ModItems.MAGIC_CHEST_BOAT.get()});
            this.tag(ModTags.Items.RAW_MEAT, "occultism:datura", "ars_nouveau:mana_berry", "artifacts:everlasting_beef", "blue_skies:venison", "blue_skies:carabeef", "blue_skies:monitor_tail", "twilightforest:raw_meef", "twilightforest:raw_venison", "twilightforest:experiment_115", "undergarden:raw_dweller_meat", "undergarden:raw_gwibling", "undergarden:raw_gloomper_leg", "quark:crab_leg", "quark:frog_leg", "farmersdelight:mutton_chops", "farmersdelight:bacon", "farmersdelight:chicken_cuts", "farmersdelight:ham", "farmersdelight:minced_beef", "forbidden_arcanus:bat_wing", "autumnity:turkey", "autumnity:turkey_piece", "potionsmaster:bezoar", "potionsmaster:gallbladder", "neapolitan:mint_chops", "biomemakeover:raw_toad", "aquaculture:frog_legs_raw", "croptopia:anchovy", "croptopia:bacon", "croptopia:frog_legs", "croptopia:sausage", "alexsmobs:raw_catfish", "alexsmobs:moose_ribs", "alexsmobs:kangaroo_meat", "alexsdelight:raw_bison", "alexsdelight:raw_bunfungus", "alexsdelight:raw_bunfungus_drumstick", "alexsdelight:kangaroo_shank", "alexsdelight:loose_moose_rib", "alexsdelight:bison_mince", "betteranimalsplus:turkey_leg_raw", "betteranimalsplus:pheasant_raw", "betteranimalsplus:venison_raw", "delightful:venison_chops", "delightful:raw_goat", "nethersdelight:raw_stuffed_hoglin", "nethersdelight:ground_strider", "nethersdelight:strider_slice", "nethersdelight:hoglin_loin", "shepherdsdelight:raw_charque", "shepherdsdelight:raw_charque_strips", "shepherdsdelight:raw_equin", "shepherdsdelight:raw_equin_chunk", "shepherdsdelight:raw_meatloaf", "shepherdsdelight:ghast_tendril", "shepherdsdelight:ghast_fillet", "shepherdsdelight:cured_pufferfish", "shepherdsdelight:cure_pufferfish_cut", "shepherdsdelight:sausage", "shepherdsdelight:strider_meat_roll", "twilightdelight:raw_meef_slice", "twilightdelight:raw_venison_rib", "twilightdelight:experiment_113", "twilightdelight:experiment_110", "twilightdelight:hydra_piece");
            this.tag(ModTags.Items.COOKED_MEAT, "artifacts:eternal_steak", "upgrade_aquatic:cooked_perch", "upgrade_aquatic:cooked_pike", "turtlemancy:rabbit_stew", "twilightforest:cooked_meef", "twilightforest:cooked_venison", "twilightforest:meef_stroganoff", "twilightforest:hydra_chop", "quark:cooked_frog_leg", "turtlemancy:cooked_oyster", "forbidden_arcanus:bat_soup", "farmersdelight:cooked_mutton_chops", "farmersdelight:cooked_bacon", "farmersdelight:cooked_chicken_cuts", "farmersdelight:smoked_ham", "farmersdelight:barbeque_stick", "farmersdelight:roast_chicken", "farmersdelight:honey_glazed_ham", "farmersdelight:shepherds_pie", "undergarden:dweller_steak", "undergarden:cooked_gwibling", "undergarden:gloomper_leg", "blue_skies:cooked_venison", "blue_skies:cooked_carabeef", "blue_skies:cooked_monitor_tail", "farmersdelight:dog_food", "farmersdelight:beef_patty", "farmersdelight:fried_egg", "autumnity:cooked_turkey", "autumnity:cooked_turkey_piece", "neapolitan:cooked_mint_chops", "biomemakeover:cooked_toad", "alexsmobs:cooked_moose_ribs", "alexsmobs:cooked_kangaroo_meat", "alexsdelight:cooked_kangaroo_shank", "alexsdelight:cooked_loose_moose_rib", "alexsdelight:bison_patty", "alexsdelight:cooked_bison", "alexsdelight:cooked_bunfungus", "alexsdelight:cooked_bunfungus_drumstick", "alexsdelight:cooked_centipede_leg", "aquaculture:frog_legs_cooked", "croptopia:cooked_anchovy", "croptopia:cooked_bacon", "croptopia:sunny_side_eggs", "croptopia:fried_frog_legs", "delightful:cooked_venison_chops", "delightful:cooked_goat", "betteranimalsplus:turkey_leg_cooked", "betteranimalsplus:pheasant_cooked", "betteranimalsplus:venison_cooked", "betteranimalsplus:turkey_cooked", "betteranimalsplus:fried_egg", "nethersdelight:hoglin_ear", "nethersdelight:grilled_strider", "shepherdsdelight:roast_charque", "shepherdsdelight:roast_charque_strips", "shepherdsdelight:equin_steak", "shepherdsdelight:equin_steak_chunk", "shepherdsdelight:cooked_meatloaf", "shepherdsdelight:cooked_fugu", "shepherdsdelight:cooked_fugu_cut", "shepherdsdelight:smoked_sausage", "twilightdelight:cooked_meef_slice", "twilightdelight:cooked_venison_rib");
            this.tag(ModTags.Items.RAW_FISH, "upgrade_aquatic:perch", "upgrade_aquatic:pike", "upgrade_aquatic:lionfish", "abnormals_delight:perch_slice", "abnormals_delight:pike_slice", "blue_skies:grittle_flatfish", "blue_skies:municipal_monkfish", "blue_skies:charscale_moki", "blue_skies:horizofin_tunid", "farmersdelight:salmon_slice", "farmersdelight:cod_slice", "forbidden_arcanus:tentacle", "aquaculture:fish_fillet_raw", "croptopia:shrimp", "croptopia:calamari", "croptopia:glowing_calamari", "croptopia:tuna", "croptopia:crab", "croptopia:clam", "croptopia:oyster", "alexsmobs:blobfish", "alexsmobs:lobster_tail", "alexsmobs:flying_fish", "alexsdelight:raw_catfish_slice", "betteranimalsplus:calamari_raw", "betteranimalsplus:eel_meat_raw", "betteranimalsplus:crab_meat_raw", "culturaldelights:squid", "culturaldelights:glow_squid", "culturaldelights:raw_calamari");
            this.tag(ModTags.Items.COOKED_FISH, "upgrade_aquatic:cooked_lionfish", "abnormals_delight:cooked_perch_slice", "abnormals_delight:cooked_pike_slice", "quark:cooked_crab_leg", "forbidden_arcanus:cooked_tentacle", "farmersdelight:cooked_salmon_slice", "farmersdelight:cooked_cod_slice", "blue_skies:cooked_grittle_flatfish", "blue_skies:cooked_municipal_monkfish", "blue_skies:cooked_charscale_moki", "blue_skies:cooked_horizofin_tunid", "biomemakeover:cooked_glowfish", "alexsmobs:cooked_catfish", "alexsmobs:cooked_lobster_tail", "alexsdelight:cooked_catfish_slice", "aquaculture:fish_fillet_cooked", "croptopia:cooked_shrimp", "croptopia:cooked_calamari", "croptopia:cooked_tuna", "croptopia:steamed_crab", "croptopia:crab_legs", "croptopia:steamed_clams", "croptopia:grilled_oysters", "culturaldelights:cooked_squid", "culturaldelights:cooked_calamari", "delightful:crab_rangoon", "ecologics:crab_meat", "betteranimalsplus:calamari_cooked", "betteranimalsplus:eel_meat_cooked", "betteranimalsplus:crab_meat_cooked");
            this.tags(ModTags.Items.RAW_MEAT, "forge:raw_bacon", "forge:raw_beef", "forge:raw_chicken", "forge:raw_mutton", "forge:raw_pork");
            this.tags(ModTags.Items.RAW_FISH, "forge:raw_fishes");
            this.tags(ModTags.Items.COOKED_MEAT, "forge:cooked_bacon", "forge:cooked_beef", "forge:cooked_chicken", "forge:cooked_mutton", "forge:cooked_pork");
            this.tags(ModTags.Items.COOKED_FISH, "forge:cooked_fishes");
            this.tag(ModTags.Items.WOLF_PELT_ARMOR_NORMAL).add((Object[])new Item[]{(Item)ModItems.PELT_HELMET.get(), (Item)ModItems.PELT_CHESTPLATE.get(), (Item)ModItems.PELT_LEGGINGS.get(), (Item)ModItems.PELT_BOOTS.get()});
            this.tag(ModTags.Items.WOLF_PELT_ARMOR_ENHANCED).add((Object[])new Item[]{(Item)ModItems.DARK_PELT_HELMET.get(), (Item)ModItems.DARK_PELT_CHESTPLATE.get(), (Item)ModItems.DARK_PELT_LEGGINGS.get(), (Item)ModItems.DARK_PELT_BOOTS.get()});
            this.tag(ModTags.Items.WOLF_PELT_ARMOR_ULTIMATE).add((Object[])new Item[]{(Item)ModItems.WHITE_PELT_HELMET.get(), (Item)ModItems.WHITE_PELT_CHESTPLATE.get(), (Item)ModItems.WHITE_PELT_LEGGINGS.get(), (Item)ModItems.WHITE_PELT_BOOTS.get()});
            this.tag(ModTags.Items.WOLF_PELT_ARMOR).addTags(new TagKey[]{ModTags.Items.WOLF_PELT_ARMOR_NORMAL, ModTags.Items.WOLF_PELT_ARMOR_ENHANCED, ModTags.Items.WOLF_PELT_ARMOR_ULTIMATE});
            this.tag(ModTags.Items.SILVER_ARMOR).add((Object[])new Item[]{(Item)ModItems.SILVER_CHESTPLATE.get(), (Item)ModItems.SILVER_HELMET.get(), (Item)ModItems.SILVER_LEGGINGS.get(), (Item)ModItems.SILVER_BOOTS.get()});
            this.tag(ModTags.Items.SILVER_ITEM).addTags(new TagKey[]{ModTags.Items.SILVER_INGOT, ModTags.Items.SILVER_TOOL, ModTags.Items.SILVER_NUGGET, ModTags.Items.RAW_MATERIALS_SILVER, ModTags.Items.STORAGE_BLOCKS_RAW_SILVER, ModTags.Items.STORAGE_BLOCKS_SILVER, ModTags.Items.SILVER_ARMOR});
            this.tag(ModTags.Items.RAW_FOOD).addTags(new TagKey[]{ModTags.Items.RAW_MEAT, ModTags.Items.RAW_FISH});
            this.tag(ModTags.Items.COOKED_FOOD).addTags(new TagKey[]{ModTags.Items.COOKED_MEAT, ModTags.Items.COOKED_FISH});
            this.tag(ModTags.Items.WEREWOLF_FOOD).addTags(new TagKey[]{ModTags.Items.RAW_FOOD, ModTags.Items.COOKED_FISH}).addTag(ItemTags.MEAT).add((Object[])new Item[]{(Item)ModItems.WOLF_BERRIES.get(), Items.SWEET_BERRIES, Items.GLOW_BERRIES});
            this.tag(ItemTags.SWORDS).add((Object)((Item)ModItems.SILVER_SWORD.get()));
            this.tag(ItemTags.AXES).add((Object)((Item)ModItems.SILVER_AXE.get()));
            this.tag(ItemTags.PICKAXES).add((Object)((Item)ModItems.SILVER_PICKAXE.get()));
            this.tag(ItemTags.SHOVELS).add((Object)((Item)ModItems.SILVER_SHOVEL.get()));
            this.tag(ItemTags.HOES).add((Object)((Item)ModItems.SILVER_HOE.get()));
            this.tag(ItemTags.HEAD_ARMOR).add((Object[])new Item[]{(Item)ModItems.SILVER_HELMET.get(), (Item)ModItems.PELT_HELMET.get(), (Item)ModItems.DARK_PELT_HELMET.get(), (Item)ModItems.WHITE_PELT_HELMET.get()});
            this.tag(ItemTags.CHEST_ARMOR).add((Object[])new Item[]{(Item)ModItems.SILVER_CHESTPLATE.get(), (Item)ModItems.PELT_CHESTPLATE.get(), (Item)ModItems.DARK_PELT_CHESTPLATE.get(), (Item)ModItems.WHITE_PELT_CHESTPLATE.get()});
            this.tag(ItemTags.LEG_ARMOR).add((Object[])new Item[]{(Item)ModItems.SILVER_LEGGINGS.get(), (Item)ModItems.PELT_LEGGINGS.get(), (Item)ModItems.DARK_PELT_LEGGINGS.get(), (Item)ModItems.WHITE_PELT_LEGGINGS.get()});
            this.tag(ItemTags.FOOT_ARMOR).add((Object[])new Item[]{(Item)ModItems.SILVER_BOOTS.get(), (Item)ModItems.PELT_BOOTS.get(), (Item)ModItems.DARK_PELT_BOOTS.get(), (Item)ModItems.WHITE_PELT_BOOTS.get()});
            this.tag(Tags.Items.MELEE_WEAPON_TOOLS).add((Object[])new Item[]{(Item)ModItems.SILVER_SWORD.get(), (Item)ModItems.SILVER_PICKAXE.get(), (Item)ModItems.SILVER_AXE.get(), (Item)ModItems.SILVER_SHOVEL.get(), (Item)ModItems.SILVER_HOE.get()});
        }

        private TagsProvider.TagAppender<Item> tag(TagKey<Item> tag, String ... locations) {
            return Arrays.stream(locations).map(ResourceLocation::parse).reduce(this.tag(tag), TagsProvider.TagAppender::addOptional, (a, b) -> a);
        }

        private TagsProvider.TagAppender<Item> tags(TagKey<Item> tag, String ... locations) {
            return Arrays.stream(locations).map(l -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)l))).reduce(this.tag(tag), ITagAppenderExtension::addOptionalTag, (a, b) -> a);
        }
    }

    private static class ModBiomeTagsProvider
    extends BiomeTagsProvider {
        public ModBiomeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderProvider) {
            this.tag(ModTags.Biomes.IS_WEREWOLF_BIOME).add(ModBiomes.WEREWOLF_FOREST);
            this.tag(BiomeTags.IS_FOREST).add(ModBiomes.WEREWOLF_FOREST);
            this.tag(ModTags.Biomes.HasSpawn.WEREWOLF).addTag(BiomeTags.IS_TAIGA);
            this.tag(ModTags.Biomes.NoSpawn.WEREWOLF).addTag(ModTags.Biomes.IS_FACTION_BIOME);
            this.tag(ModTags.Biomes.HasSpawn.HUMAN_WEREWOLF).addTag(BiomeTags.IS_TAIGA);
            this.tag(ModTags.Biomes.NoSpawn.HUMAN_WEREWOLF).addTag(ModTags.Biomes.IS_FACTION_BIOME);
            this.tag(ModTags.Biomes.HasGen.SILVER_ORE).addTag(BiomeTags.IS_OVERWORLD);
            this.tag(ModTags.Biomes.HasGen.WOLFSBANE).addTag(BiomeTags.IS_FOREST);
            this.tag(ModTags.Biomes.IS_FACTION_BIOME).addTag(ModTags.Biomes.IS_WEREWOLF_BIOME);
            this.tag(BiomeTags.IS_OVERWORLD).add(ModBiomes.WEREWOLF_FOREST);
            this.tag(BiomeTags.IS_FOREST).add(ModBiomes.WEREWOLF_FOREST);
            this.tag(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD).add(ModBiomes.WEREWOLF_FOREST);
            this.tag(Tags.Biomes.IS_MAGICAL).add(ModBiomes.WEREWOLF_FOREST);
        }

        @Nonnull
        public String getName() {
            return "Werewolves " + super.getName();
        }
    }

    private static class ModPoiTypesProvider
    extends PoiTypeTagsProvider {
        public ModPoiTypesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderProvider) {
            this.tag(ModTags.PoiTypes.IS_WEREWOLF).add(ModVillage.WEREWOLF_FACTION.getKey());
            this.tag(ModTags.PoiTypes.HAS_FACTION).addTags(new TagKey[]{ModTags.PoiTypes.IS_WEREWOLF});
            this.tag(PoiTypeTags.ACQUIRABLE_JOB_SITE).add(ModVillage.WEREWOLF_FACTION.getKey());
            this.tag(PoiTypeTags.VILLAGE).add(ModVillage.WEREWOLF_FACTION.getKey());
        }
    }

    private static class ModVillageProfessionProvider
    extends TagsProvider<VillagerProfession> {
        public ModVillageProfessionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.VILLAGER_PROFESSION, lookupProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderProvider) {
            this.tag(ModTags.Professions.IS_WEREWOLF).add(ModVillage.WEREWOLF_EXPERT.getKey());
            this.tag(ModTags.Professions.HAS_FACTION).addTag(ModTags.Professions.IS_WEREWOLF);
        }
    }

    private static class ModDamageTypeProvider
    extends TagsProvider<DamageType> {
        public ModDamageTypeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.DAMAGE_TYPE, lookupProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(ModTags.DamageTypes.WEREWOLF_FUR_IMMUNE).add(new ResourceKey[]{DamageTypes.SWEET_BERRY_BUSH, DamageTypes.CACTUS, DamageTypes.HOT_FLOOR});
            this.tag(DamageTypeTags.WITCH_RESISTANT_TO).add(ModDamageTypes.BLOOD_LOSS);
            this.tag(DamageTypeTags.BYPASSES_ARMOR).add(ModDamageTypes.BLOOD_LOSS);
            this.tag(ModTags.DamageTypes.WEREWOLF_ARMOR_REDUCTION).addTag(DamageTypeTags.IS_PLAYER_ATTACK).add(ModDamageTypes.BITE);
            this.tag(ModTags.DamageTypes.BITE).add(ModDamageTypes.BITE);
        }
    }

    private static class ModTasksTagProvider
    extends TagsProvider<Task> {
        public ModTasksTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, VampirismRegistries.Keys.TASK, lookupProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(ModTags.Tasks.AWARDS_LORD_LEVEL).add(new ResourceKey[]{ModTasks.WEREWOLF_LORD_1, ModTasks.WEREWOLF_LORD_2, ModTasks.WEREWOLF_LORD_3, ModTasks.WEREWOLF_LORD_4, ModTasks.WEREWOLF_LORD_5});
            this.tag(ModTags.Tasks.HAS_FACTION).addTags(new TagKey[]{ModTags.Tasks.IS_WEREWOLF});
            this.tag(ModTags.Tasks.IS_WEREWOLF).add(new ResourceKey[]{ModTasks.WEREWOLF_LORD_1, ModTasks.WEREWOLF_LORD_2, ModTasks.WEREWOLF_LORD_3, ModTasks.WEREWOLF_LORD_4, ModTasks.WEREWOLF_LORD_5, ModTasks.WEREWOLF_MINION_BINDING, ModTasks.WEREWOLF_MINION_UPGRADE_SIMPLE, ModTasks.WEREWOLF_MINION_UPGRADE_ENHANCED, ModTasks.WEREWOLF_MINION_UPGRADE_SPECIAL, ModTasks.RANDOM_REFINEMENT_1, ModTasks.RANDOM_REFINEMENT_2, ModTasks.RANDOM_REFINEMENT_3, ModTasks.RANDOM_RARE_REFINEMENT});
        }
    }

    private static class ModEntityTagProvider
    extends EntityTypeTagsProvider {
        public ModEntityTagProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pOutput, pProvider, "werewolves", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS).add((Object)((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get()));
            this.tag(ModTags.Entities.WEREWOLF).add((Object[])new EntityType[]{(EntityType)ModEntities.ALPHA_WEREWOLF.get(), (EntityType)ModEntities.WEREWOLF_BEAST.get(), (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), (EntityType)ModEntities.HUMAN_WEREWOLF.get(), (EntityType)ModEntities.WEREWOLF_MINION.get(), (EntityType)ModEntities.TASK_MASTER_WEREWOLF.get()});
        }
    }
}

