/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.tiles;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import de.teamlapen.werewolves.blocks.entity.WolfsbaneDiffuserBlockEntity;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class WolfsbaneDiffuserBESR
implements BlockEntityRenderer<WolfsbaneDiffuserBlockEntity> {
    public WolfsbaneDiffuserBESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull WolfsbaneDiffuserBlockEntity tileEntityIn, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        LivingEntity living;
        Entity e = Minecraft.getInstance().getCameraEntity();
        if (e instanceof LivingEntity && Streams.stream((Iterable)(living = (LivingEntity)e).getHandSlots()).map(ItemStack::getItem).anyMatch(i -> i == ModItems.WOLFSBANE_FINDER.get()) && tileEntityIn.isInRange(e.blockPosition())) {
            long totalWorldTime = tileEntityIn.getLevel() != null ? tileEntityIn.getLevel().getGameTime() : 0L;
            float scale = (float)Mth.clamp((double)(Math.sqrt(tileEntityIn.getBlockPos().distSqr((Vec3i)e.blockPosition())) / 16.0), (double)1.0, (double)3.0);
            VertexConsumer vertexConsumer = bufferIn.getBuffer(Accessor.CUTOUT_NODEPTH);
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, 0.5, 0.5);
            matrixStackIn.scale(scale, scale, scale);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(((float)totalWorldTime + partialTicks) % 360.0f));
            matrixStackIn.translate(-0.5, 0.0, -0.5);
            matrixStackIn.pushPose();
            BakedModel garlic_model = Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)ModBlocks.WOLFSBANE.get()), null, null, 0);
            Minecraft.getInstance().getItemRenderer().renderModelLists(garlic_model, new ItemStack((ItemLike)ModBlocks.WOLFSBANE.get()), combinedLightIn, combinedOverlayIn, matrixStackIn, vertexConsumer);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }

    public boolean shouldRenderOffScreen(@NotNull WolfsbaneDiffuserBlockEntity te) {
        return true;
    }

    private static class Accessor
    extends RenderStateShard {
        private static final RenderType CUTOUT_NODEPTH = RenderType.create((String)"cutout_nodepth", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setDepthTestState(NO_DEPTH_TEST).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET).setShaderState(RenderStateShard.RENDERTYPE_CUTOUT_SHADER).createCompositeState(true));

        public Accessor(@NotNull String nameIn, @NotNull Runnable setupTaskIn, @NotNull Runnable clearTaskIn) {
            super(nameIn, setupTaskIn, clearTaskIn);
        }
    }
}

