/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.api.entities.werewolf;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolfDataholder;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public interface WerewolfTransformable
extends IWerewolfDataholder {
    public static final int TYPES = 126;

    public static <T extends Mob> T copyData(EntityType<T> newEntity, Mob oldEntity) {
        return (T)WerewolfTransformable.copyData((Mob)newEntity.create(oldEntity.getCommandSenderWorld()), oldEntity);
    }

    public static <T extends Mob> T copyData(T entity, Mob oldEntity) {
        UUID uuid = entity.getUUID();
        entity.copyPosition((Entity)oldEntity);
        entity.restoreFrom((Entity)oldEntity);
        entity.setUUID(uuid);
        entity.getCommandSenderWorld().addFreshEntity(entity);
        oldEntity.remove(Entity.RemovalReason.DISCARDED);
        entity.setHealth(oldEntity.getHealth() / oldEntity.getMaxHealth() * entity.getMaxHealth());
        return entity;
    }

    default public WerewolfTransformable transformBack() {
        WerewolfTransformable transformable = this._transformBack();
        transformable.reset();
        return transformable;
    }

    default public WerewolfTransformable transformToWerewolf(TransformType type) {
        WerewolfTransformable transformable = this._transformToWerewolf();
        transformable.start(type);
        return transformable;
    }

    public boolean canTransform();

    @Override
    @Nonnull
    public WerewolfForm getForm();

    public EntityClassType getEntityClass();

    public EntityActionTier getEntityTier();

    default public void reset() {
    }

    default public void start(TransformType type) {
    }

    public WerewolfTransformable _transformToWerewolf();

    public WerewolfTransformable _transformBack();
}

