/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.werewolves.core.ModAdvancements;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public class WerewolfActionCriterionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(@NotNull ServerPlayer player, Action action) {
        this.trigger(player, instance -> instance.matches(action));
    }

    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static enum Action implements StringRepresentable
    {
        HOWLING("howling"),
        TRANSFORM_FULL_MOON("transform_full_moon"),
        TOUCH_SILVER("touch_silver"),
        VILLAGE_CONQUERED("village_conquered"),
        ARMOR_PARTIAL("armor_partial");

        private final String name;

        private Action(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }

    public record TriggerInstance(@NotNull Optional<ContextAwarePredicate> player, @NotNull Action action) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)StringRepresentable.fromEnum(Action::values).fieldOf("action").forGetter(TriggerInstance::action)).apply((Applicative)inst, TriggerInstance::new));

        @NotNull
        public static Criterion<TriggerInstance> of(@NotNull Action action) {
            return ((WerewolfActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), action));
        }

        boolean matches(Action action) {
            return this.action == action;
        }
    }
}

