/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism_kubejs.component;

import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Wrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@Info(value="Various recipe result related helper methods")
public interface WeightedRecipeResultWrapper {
    @Info(value="Returns an WeightedRecipeResult of the input")
    public static WeightedRecipeResult of(WeightedRecipeResult in) {
        return in;
    }

    @Info(value="Returns an WeightedRecipeResult of the input")
    public static WeightedRecipeResult of(WeightedRecipeResult in, int count) {
        return in.copyWithCount(count);
    }

    public static WeightedRecipeResult of(WeightedRecipeResult in, int count, int weight) {
        return in.copyWithCount(count).copyWithWeight(weight);
    }

    public static WeightedRecipeResult wrap(RegistryAccessContainer registries, @Nullable Object o) {
        while (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR || o == Ingredient.EMPTY) {
            return WeightedRecipeResult.of((ItemStack)ItemStack.EMPTY, (int)1);
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return WeightedRecipeResult.of((TagKey)ItemTags.create((ResourceLocation)tag.location()), (int)1);
        }
        if (o instanceof CharSequence) {
            return WeightedRecipeResultWrapper.ofString(registries, o.toString());
        }
        return WeightedRecipeResult.of((ItemStack)ItemStackJS.wrap((RegistryAccessContainer)registries, (Object)o), (int)1);
    }

    public static WeightedRecipeResult ofString(RegistryAccessContainer registries, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return WeightedRecipeResult.of((ItemStack)ItemStack.EMPTY, (int)1);
        }
        if (s.equals("*")) {
            throw new UnsupportedOperationException("Wildcard recipe results are not supported");
        }
        try {
            return WeightedRecipeResultWrapper.read(registries, new StringReader(s));
        }
        catch (CommandSyntaxException e) {
            KubeJS.LOGGER.error("Failed to read recipe result from '" + s + "': " + String.valueOf((Object)e));
            return WeightedRecipeResult.of((ItemStack)ItemStack.EMPTY, (int)1);
        }
    }

    public static WeightedRecipeResult read(RegistryAccessContainer registries, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return WeightedRecipeResult.of((ItemStack)ItemStack.EMPTY, (int)1);
        }
        return switch (reader.peek()) {
            case '-' -> {
                reader.skip();
                yield WeightedRecipeResult.of((ItemStack)ItemStack.EMPTY, (int)1);
            }
            case '*' -> {
                reader.skip();
                throw new UnsupportedOperationException("Wildcard recipe results are not supported");
            }
            case '#' -> {
                reader.skip();
                yield WeightedRecipeResult.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.read((StringReader)reader)), (int)1);
            }
            case '@' -> {
                reader.skip();
                throw new UnsupportedOperationException("Namespaced recipe results are not supported");
            }
            case '%' -> {
                reader.skip();
                throw new UnsupportedOperationException("Creative tab recipe results are not supported");
            }
            case '/' -> throw new UnsupportedOperationException("Regex recipe results are not supported");
            case '[' -> throw new UnsupportedOperationException("Compound recipe results are not supported");
            default -> {
                DataComponentPredicate components;
                char next;
                ResourceLocation itemId = ResourceLocation.read((StringReader)reader);
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                char v1 = next = reader.canRead() ? reader.peek() : (char)'\u0000';
                if ((next == '[' || next == '{') && (components = DataComponentWrapper.readPredicate((DynamicOps)registries.nbt(), (StringReader)reader)) != DataComponentPredicate.EMPTY) {
                    yield WeightedRecipeResult.of((ItemStack)new ItemStack((Holder)item.builtInRegistryHolder(), 1, components.asPatch()), (int)1);
                }
                yield WeightedRecipeResult.of((ItemStack)new ItemStack((ItemLike)item), (int)1);
            }
        };
    }
}

