/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.block.pipes.generic.QuadrupleExtensionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class QuadruplePipeBlock
extends GenericPipeBlock {
    public QuadruplePipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.extensionsPerBlock = 4;
    }

    @Override
    public void incrementSize(LevelAccessor pLevel, BlockPos pPos, boolean playSound) {
        BlockState base = pLevel.getBlockState(pPos);
        if (!base.hasProperty((Property)SIZE)) {
            return;
        }
        Generic.WhistleSize size = (Generic.WhistleSize)((Object)base.getValue((Property)SIZE));
        SoundType soundtype = base.getSoundType();
        BlockPos currentPos = pPos.above();
        Direction facing = (Direction)base.getValue((Property)FACING);
        float pVolume = (soundtype.getVolume() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value();
        SoundEvent hitSound = soundtype.getHitSound();
        for (int i = 1; i <= 12; i += 4) {
            BlockState blockState = pLevel.getBlockState(currentPos);
            if (blockState.getBlock() instanceof QuadrupleExtensionBlock) {
                if (blockState.getValue((Property)QuadrupleExtensionBlock.SHAPE) != Generic.QuadrupleExtensionShape.QUAD && blockState.getValue((Property)QuadrupleExtensionBlock.SHAPE) != Generic.QuadrupleExtensionShape.QUAD_CONNECTED) {
                    pLevel.setBlock(currentPos, (BlockState)((BlockState)blockState.cycle((Property)QuadrupleExtensionBlock.SHAPE)).setValue((Property)FACING, (Comparable)facing), 3);
                    if (playSound) {
                        switch ((Generic.QuadrupleExtensionShape)((Object)blockState.getValue((Property)QuadrupleExtensionBlock.SHAPE))) {
                            case SINGLE: {
                                ++i;
                                break;
                            }
                            case DOUBLE: {
                                i += 2;
                                break;
                            }
                            case TRIPLE: {
                                i += 3;
                            }
                        }
                        float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                        pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                        pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.canBeReplaced()) {
                    return;
                }
                pLevel.setBlock(currentPos, (BlockState)((BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).defaultBlockState().setValue((Property)SIZE, (Comparable)((Object)size))).setValue((Property)FACING, (Comparable)facing), 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                    pLevel.playSound(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.playSound(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.above();
        }
    }
}

