/*
 * Decompiled with CFR 0.152.
 */
package com.listdimsnbiomes.listdimsnbiomesmod;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.LevelStem;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;

@Mod(value="listdimsnbiomes")
public class ListDimsnBiomes {
    public static final String MODID = "listdimsnbiomes";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ListDimsnBiomes(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listdims").requires(source -> source.hasPermission(2))).executes(context -> ListDimsnBiomes.executeListDims((CommandSourceStack)context.getSource())));
    }

    private static int executeListDims(CommandSourceStack source) {
        RegistryAccess.Frozen registryAccess = source.getServer().registryAccess();
        Registry levelStemRegistry = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
        MutableComponent header = Component.literal((String)"Registered Dimensions and Biomes:").withStyle(ChatFormatting.BOLD);
        source.sendSuccess(() -> ListDimsnBiomes.lambda$executeListDims$2((Component)header), false);
        LOGGER.info(header.getString());
        for (ResourceKey dimKey : levelStemRegistry.registryKeySet()) {
            String dimId = dimKey.location().toString();
            MutableComponent dimComponent = Component.literal((String)("- Dimension: " + dimId)).withStyle(ChatFormatting.GREEN);
            source.sendSuccess(() -> ListDimsnBiomes.lambda$executeListDims$3((Component)dimComponent), false);
            LOGGER.info(dimComponent.getString());
            LevelStem stem = (LevelStem)levelStemRegistry.get(dimKey);
            if (stem == null) continue;
            Set biomes = stem.generator().getBiomeSource().possibleBiomes();
            for (Holder biomeHolder : biomes) {
                biomeHolder.unwrapKey().ifPresent(biomeKey -> {
                    String biomeId = biomeKey.location().toString();
                    MutableComponent biomeComponent = Component.literal((String)("  - Biome: " + biomeId));
                    source.sendSuccess(() -> ListDimsnBiomes.lambda$executeListDims$4((Component)biomeComponent), false);
                    LOGGER.info(biomeComponent.getString());
                });
            }
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$executeListDims$4(Component biomeComponent) {
        return biomeComponent;
    }

    private static /* synthetic */ Component lambda$executeListDims$3(Component dimComponent) {
        return dimComponent;
    }

    private static /* synthetic */ Component lambda$executeListDims$2(Component header) {
        return header;
    }
}

