/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.hud_batching.consumer;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.raphimc.immediatelyfast.feature.batching.BatchingRenderLayers;
import net.raphimc.immediatelyfast.feature.batching.BlendFuncDepthFuncState;
import net.raphimc.immediatelyfast.feature.batching.HudBatchingBufferSource;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1500)
public abstract class MixinDrawContext {
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Mutable
    public MultiBufferSource.BufferSource bufferSource;

    @ModifyVariable(method={"fill(Lnet/minecraft/client/renderer/RenderType;IIIIII)V"}, at=@At(value="HEAD"), index=6, argsOnly=true)
    private int mixColor(int color) {
        if (this.bufferSource instanceof HudBatchingBufferSource) {
            return this.immediatelyFast$mixWithShaderColor(color);
        }
        return color;
    }

    @ModifyVariable(method={"fillGradient(Lnet/minecraft/client/renderer/RenderType;IIIIIII)V"}, at=@At(value="HEAD"), index=5, argsOnly=true)
    private int mixStartColor(int color) {
        if (this.bufferSource instanceof HudBatchingBufferSource) {
            return this.immediatelyFast$mixWithShaderColor(color);
        }
        return color;
    }

    @ModifyVariable(method={"fillGradient(Lnet/minecraft/client/renderer/RenderType;IIIIIII)V"}, at=@At(value="HEAD"), index=6, argsOnly=true)
    private int mixEndColor(int color) {
        if (this.bufferSource instanceof HudBatchingBufferSource) {
            return this.immediatelyFast$mixWithShaderColor(color);
        }
        return color;
    }

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, CallbackInfo ci) {
        if (this.bufferSource instanceof HudBatchingBufferSource) {
            ci.cancel();
            Matrix4f matrix = this.pose.last().pose();
            float[] shaderColor = RenderSystem.getShaderColor();
            int r = Mth.clamp((int)((int)(shaderColor[0] * 255.0f)), (int)0, (int)255);
            int g = Mth.clamp((int)((int)(shaderColor[1] * 255.0f)), (int)0, (int)255);
            int b = Mth.clamp((int)((int)(shaderColor[2] * 255.0f)), (int)0, (int)255);
            int a = Mth.clamp((int)((int)(shaderColor[3] * 255.0f)), (int)0, (int)255);
            VertexConsumer vertexConsumer = this.bufferSource.getBuffer(BatchingRenderLayers.COLORED_TEXTURE.apply(this.minecraft.getTextureManager().getTexture(texture).getId(), BlendFuncDepthFuncState.current()));
            vertexConsumer.addVertex(matrix, (float)x1, (float)y2, (float)z).setUv(u1, v2).setColor(r, g, b, a);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2).setColor(r, g, b, a);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y1, (float)z).setUv(u2, v1).setColor(r, g, b, a);
            vertexConsumer.addVertex(matrix, (float)x1, (float)y1, (float)z).setUv(u1, v1).setColor(r, g, b, a);
        }
    }

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (this.bufferSource instanceof HudBatchingBufferSource) {
            ci.cancel();
            Matrix4f matrix = this.pose.last().pose();
            int color = this.immediatelyFast$mixWithShaderColor((int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f));
            RenderSystem.enableBlend();
            VertexConsumer vertexConsumer = this.bufferSource.getBuffer(BatchingRenderLayers.COLORED_TEXTURE.apply(this.minecraft.getTextureManager().getTexture(texture).getId(), BlendFuncDepthFuncState.current()));
            vertexConsumer.addVertex(matrix, (float)x1, (float)y2, (float)z).setUv(u1, v2).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x2, (float)y1, (float)z).setUv(u2, v1).setColor(color);
            vertexConsumer.addVertex(matrix, (float)x1, (float)y1, (float)z).setUv(u1, v1).setColor(color);
            RenderSystem.disableBlend();
        }
    }

    @Inject(method={"flushIfUnmanaged()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontTryDrawIfBatching(CallbackInfo ci) {
        if (this.bufferSource instanceof HudBatchingBufferSource) {
            ci.cancel();
        }
    }

    @WrapWithCondition(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;flush()V")})
    private boolean dontDrawIfBatching(GuiGraphics instance) {
        return !(instance.bufferSource instanceof HudBatchingBufferSource);
    }

    @Unique
    private int immediatelyFast$mixWithShaderColor(int color) {
        float[] shaderColor = RenderSystem.getShaderColor();
        int argb = Mth.clamp((int)((int)(shaderColor[3] * 255.0f)), (int)0, (int)255) << 24 | Mth.clamp((int)((int)(shaderColor[0] * 255.0f)), (int)0, (int)255) << 16 | Mth.clamp((int)((int)(shaderColor[1] * 255.0f)), (int)0, (int)255) << 8 | Mth.clamp((int)((int)(shaderColor[2] * 255.0f)), (int)0, (int)255);
        return FastColor.ARGB32.multiply((int)color, (int)argb);
    }
}

