/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenuFactory;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.WaystoneEditMenu;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    private static final BalmMenus menus = Balm.getMenus();
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> waystoneSelection = menus.registerMenu(ModMenus.id("waystone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, WaystoneSelectionMenu.Data>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, WaystoneSelectionMenu.Data data) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.get()), data.fromWaystone(), windowId, data.waystones(), Collections.emptySet());
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaystoneSelectionMenu.Data> getStreamCodec() {
            return WaystoneSelectionMenu.STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpScrollSelection = menus.registerMenu(ModMenus.id("warp_scroll_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, ItemInitiatedWaystoneMenuData>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, ItemInitiatedWaystoneMenuData data) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpScrollSelection.get()), null, windowId, data.waystones(), Collections.emptySet()).withWarpItem(data.itemStack());
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemInitiatedWaystoneMenuData> getStreamCodec() {
            return ItemInitiatedWaystoneMenuData.STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpStoneSelection = menus.registerMenu(ModMenus.id("warp_stone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, ItemInitiatedWaystoneMenuData>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, ItemInitiatedWaystoneMenuData data) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpStoneSelection.get()), null, windowId, data.waystones(), Collections.emptySet()).withWarpItem(data.itemStack());
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemInitiatedWaystoneMenuData> getStreamCodec() {
            return ItemInitiatedWaystoneMenuData.STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> portstoneSelection = menus.registerMenu(ModMenus.id("portstone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)portstoneSelection.get()), null, windowId, waystones, Collections.emptySet());
        }

        public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
            return WaystoneImpl.LIST_STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> inventorySelection = menus.registerMenu(ModMenus.id("inventory_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)inventorySelection.get()), null, windowId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
        }

        public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
            return WaystoneImpl.LIST_STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> adminSelection = menus.registerMenu(ModMenus.id("admin_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)adminSelection.get()), null, windowId, waystones, Set.of(TeleportFlags.ADMIN));
        }

        public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
            return WaystoneImpl.LIST_STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> sharestoneSelection = menus.registerMenu(ModMenus.id("sharestone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, WaystoneSelectionMenu.Data>(){

        public WaystoneSelectionMenu create(int windowId, Inventory inventory, WaystoneSelectionMenu.Data data) {
            return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)sharestoneSelection.get()), data.fromWaystone(), windowId, data.waystones(), Collections.emptySet());
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaystoneSelectionMenu.Data> getStreamCodec() {
            return WaystoneSelectionMenu.STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneModifierMenu>> waystoneModifiers = menus.registerMenu(ModMenus.id("waystone_modifiers"), (BalmMenuFactory)new BalmMenuFactory<WaystoneModifierMenu, Waystone>(){

        public WaystoneModifierMenu create(int windowId, Inventory inventory, Waystone waystone) {
            return new WaystoneModifierMenu(windowId, inventory, waystone);
        }

        public StreamCodec<RegistryFriendlyByteBuf, Waystone> getStreamCodec() {
            return WaystoneImpl.STREAM_CODEC;
        }
    });
    public static DeferredObject<MenuType<WaystoneEditMenu>> waystoneSettings = menus.registerMenu(ModMenus.id("waystone"), (BalmMenuFactory)new BalmMenuFactory<WaystoneEditMenu, WaystoneEditMenu.Data>(){

        public WaystoneEditMenu create(int windowId, Inventory inventory, WaystoneEditMenu.Data data) {
            return new WaystoneEditMenu(windowId, data.waystone(), data.modifierCount(), data.error().orElse(null), data.visibilityOptions());
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaystoneEditMenu.Data> getStreamCodec() {
            return WaystoneEditMenu.STREAM_CODEC;
        }
    });

    public static void initialize() {
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)name);
    }

    public record ItemInitiatedWaystoneMenuData(Collection<Waystone> waystones, ItemStack itemStack) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemInitiatedWaystoneMenuData> STREAM_CODEC = StreamCodec.composite(WaystoneImpl.LIST_STREAM_CODEC, ItemInitiatedWaystoneMenuData::waystones, (StreamCodec)ItemStack.STREAM_CODEC, ItemInitiatedWaystoneMenuData::itemStack, ItemInitiatedWaystoneMenuData::new);
    }
}

