/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.services;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.forge.services.ForgeRegisterItemHelper;
import com.natamus.collective_common_forge.services.helpers.RegisterBlockHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegisterBlockHelper
implements RegisterBlockHelper {
    private static final HashMap<String, DeferredRegister<Block>> deferredBlockRegisterMap = new HashMap();
    private static final HashMap<ResourceLocation, RegistryObject<Block>> registeredBlocksWithoutItem = new HashMap();
    private static final HashMap<ResourceLocation, Pair<RegistryObject<Block>, RegistryObject<Item>>> registeredBlockWithItemPairs = new HashMap();

    @Override
    public <T extends Block> void registerBlockWithoutItem(Object modEventBusObject, ResourceLocation resourceLocation, Supplier<T> blockSupplier, boolean lastBlock) {
        ForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, resourceLocation, blockSupplier, null, lastBlock, false);
    }

    @Override
    public Block getRegisteredBlockWithoutItem(ResourceLocation resourceLocation) {
        return (Block)registeredBlocksWithoutItem.get(resourceLocation).get();
    }

    @Override
    public <T extends Block> void registerBlockWithItem(Object modEventBusObject, ResourceLocation resourceLocation, Supplier<T> blockSupplier, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock) {
        ForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, resourceLocation, blockSupplier, creativeModeTabResourceKey, lastBlock, true);
    }

    @Override
    public Block getRegisteredBlockWithItem(ResourceLocation resourceLocation) {
        return (Block)((RegistryObject)registeredBlockWithItemPairs.get(resourceLocation).getFirst()).get();
    }

    @Override
    public Pair<Block, BlockItem> getRegisteredBlockWithItemPair(ResourceLocation resourceLocation) {
        Pair<RegistryObject<Block>, RegistryObject<Item>> deferredPair = registeredBlockWithItemPairs.get(resourceLocation);
        return Pair.of((Object)((Block)((RegistryObject)deferredPair.getFirst()).get()), (Object)((BlockItem)((RegistryObject)deferredPair.getSecond()).get()));
    }

    @Override
    public void setRegisteredBlockWithItemPair(ResourceLocation resourceLocation, Class<?> blockClass, String blockFieldName, Class<?> blockItemClass, String blockItemFieldName) {
        Pair<RegistryObject<Block>, RegistryObject<Item>> deferredPair = registeredBlockWithItemPairs.get(resourceLocation);
        try {
            Field blockField = blockClass.getDeclaredField(blockFieldName);
            blockField.setAccessible(true);
            blockField.set(null, ((RegistryObject)deferredPair.getFirst()).get());
            Field blockItemField = blockItemClass.getDeclaredField(blockItemFieldName);
            blockItemField.setAccessible(true);
            blockItemField.set(null, ((RegistryObject)deferredPair.getSecond()).get());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static <T extends Block> void staticRegisterBlock(Object modEventBusObject, ResourceLocation resourceLocation, Supplier<T> blockSupplier, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock, boolean registerAsItem) {
        String namespace = resourceLocation.getNamespace();
        if (!deferredBlockRegisterMap.containsKey(namespace)) {
            DeferredRegister deferredBlockRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
            deferredBlockRegisterMap.put(namespace, (DeferredRegister<Block>)deferredBlockRegister);
        }
        RegistryObject deferredBlockObject = deferredBlockRegisterMap.get(namespace).register(resourceLocation.getPath(), blockSupplier);
        if (registerAsItem) {
            RegistryObject<Item> deferredItemObject = ForgeRegisterItemHelper.staticRegisterItem(modEventBusObject, resourceLocation, () -> new BlockItem((Block)deferredBlockObject.get(), new Item.Properties()), creativeModeTabResourceKey, lastBlock);
            registeredBlockWithItemPairs.put(resourceLocation, (Pair<RegistryObject<Block>, RegistryObject<Item>>)Pair.of((Object)deferredBlockObject, deferredItemObject));
        } else {
            registeredBlocksWithoutItem.put(resourceLocation, (RegistryObject<Block>)deferredBlockObject);
        }
        if (lastBlock) {
            deferredBlockRegisterMap.get(namespace).register((IEventBus)modEventBusObject);
        }
    }
}

