/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.registries;

import java.util.EnumMap;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.TorchBlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CommonBlockProperties;
import tv.soaryn.xycraft.core.content.blocks.ImmortalStoneBlock;
import tv.soaryn.xycraft.core.content.blocks.PillarColoredBlock;
import tv.soaryn.xycraft.core.content.builder.BlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.ColoredBlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.ItemContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.MCLocale;
import tv.soaryn.xycraft.core.content.builder.TorchBlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.datagen.BlockModelType;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.WorldCreativeTab;
import tv.soaryn.xycraft.world.content.blocks.AureyBlock;
import tv.soaryn.xycraft.world.content.blocks.GeyserBlock;
import tv.soaryn.xycraft.world.content.blocks.GlassBlock;
import tv.soaryn.xycraft.world.content.blocks.ImmortalGlassBlock;
import tv.soaryn.xycraft.world.content.blocks.InvertedBlock;
import tv.soaryn.xycraft.world.content.blocks.LampColoredBlock;
import tv.soaryn.xycraft.world.content.blocks.OreColoredBlock;
import tv.soaryn.xycraft.world.content.blocks.PhantomGlassViewerBlock;
import tv.soaryn.xycraft.world.content.blocks.RGBGlassBlock;
import tv.soaryn.xycraft.world.content.blocks.XyTorchBlock;
import tv.soaryn.xycraft.world.content.blocks.XyWallTorchBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampCubeBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampFlushBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampLanternBlock;
import tv.soaryn.xycraft.world.content.blocks.lamps.LampPillarBlock;
import tv.soaryn.xycraft.world.content.registries.WorldParticles;

public final class WorldContent {
    public static final ContentMap Map = ContentMap.map((String)"xycraft_world").withTab(WorldCreativeTab::new);

    private static BlockContent defaultPink(DyeColors color, BlockContent content) {
        return WorldContent.defaultColor(color, content, DyeColors.Pink);
    }

    private static BlockContent defaultWhite(DyeColors color, BlockContent content) {
        return WorldContent.defaultColor(color, content, DyeColors.White);
    }

    private static void defaultWhiteWithCustomItemModel(DyeColors color, BlockContent content) {
        WorldContent.defaultWhite(color, content).withCustomItemModel();
    }

    private static BlockContent defaultColor(DyeColors color, BlockContent content, DyeColors filter) {
        return content.setTab(color == filter ? Map.getTab() : null).withCustomBreakRule();
    }

    private static <T> void customBreakRule(T color, BlockContent content) {
        content.withCustomBreakRule();
    }

    static {
        Map.with(new Object[]{Block.INSTANCE, Item.INSTANCE});
    }

    public static interface Block {
        public static final Block INSTANCE = new Block(){};
        public static final BlockContent Kivi = ((BlockContentRegistrationBuilder)Map.block("Kivi").withBlockProperties(CommonBlockProperties::KiviProperties).withName("Stone", new MCLocale[]{MCLocale.FINNISH})).build();
        public static final BlockContent KiviRajan = ((BlockContentRegistrationBuilder)Map.block("Kivi Rajan").withBlockProperties(CommonBlockProperties::KiviProperties).withName("Bordered Stone", new MCLocale[]{MCLocale.FINNISH})).withModelType(BlockModelType.Connected).build();
        public static final BlockContent SmoothKivi = ((BlockContentRegistrationBuilder)Map.block("Smooth Kivi").withBlockProperties(CommonBlockProperties::KiviProperties).withName("Sile\u00e4 Stone", new MCLocale[]{MCLocale.FINNISH})).withModelType(BlockModelType.Connected).build();
        public static final BlockContent KiviBricks = Map.block("Kivi Bricks").withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Simple).build();
        public static final EnumMap<XyCraftColors, BlockContent> KiviBricksCloud = Map.coloredBlock("%s Kivi Bricks", XyCraftColors.class).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Cloud).build();
        public static final BlockContent KiviTiles = Map.block("Kivi Tiles").withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Simple).build();
        public static final EnumMap<XyCraftColors, BlockContent> KiviTilesCloud = Map.coloredBlock("%s Kivi Tiles", XyCraftColors.class).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Cloud).build();
        public static final EnumMap<XyCraftColors, BlockContent> KiviPillar = Map.coloredBlock("%s Kivi Pillar", XyCraftColors.class, PillarColoredBlock::new).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Custom).build();
        public static final EnumMap<XyCraftColors, BlockContent> KiviTrim = Map.coloredBlock("%s Kivi Trim", XyCraftColors.class).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Custom).build();
        public static final EnumMap<XyCraftColors, BlockContent> ImmortalStone = Map.coloredBlock("%s Immortal Stone", XyCraftColors.class, ImmortalStoneBlock::kivi).withModelType(BlockModelType.Custom).build();
        public static final BlockContent AluminumStorage = ((BlockContentRegistrationBuilder)Map.block("Aluminum Storage").withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Connected).withName("Aluminium Storage", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final BlockContent AluminumBricks = ((BlockContentRegistrationBuilder)Map.block("Aluminum Bricks").withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Simple).withName("Aluminium Bricks", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final BlockContent AluminumTiles = ((BlockContentRegistrationBuilder)Map.block("Aluminum Tiles").withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Simple).withName("Aluminium Tiles", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final EnumMap<XyCraftColors, BlockContent> AluminumBricksCloud = ((ColoredBlockContentRegistrationBuilder)Map.coloredBlock("%s Aluminum Bricks", XyCraftColors.class).withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Cloud).withName("%s Aluminium Bricks", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final EnumMap<XyCraftColors, BlockContent> AluminumTilesCloud = ((ColoredBlockContentRegistrationBuilder)Map.coloredBlock("%s Aluminum Tiles", XyCraftColors.class).withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Cloud).withName("%s Aluminium Tiles", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final EnumMap<XyCraftColors, BlockContent> AluminumPillar = ((ColoredBlockContentRegistrationBuilder)Map.coloredBlock("%s Aluminum Pillar", XyCraftColors.class, PillarColoredBlock::new).withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Custom).withName("%s Aluminium Pillar", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final EnumMap<XyCraftColors, BlockContent> AluminumTrim = ((ColoredBlockContentRegistrationBuilder)Map.coloredBlock("%s Aluminum Trim", XyCraftColors.class).withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Custom).withName("%s Aluminium Trim", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final EnumMap<XyCraftColors, BlockContent> ImmortalAluminum = ((ColoredBlockContentRegistrationBuilder)Map.coloredBlock("%s Immortal Aluminum", XyCraftColors.class, ImmortalStoneBlock::aluminum).withModelType(BlockModelType.Custom).withName("%s Immortal Aluminium", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final EnumMap<XyCraftColors, BlockContent> XychoriumStorage = Map.coloredBlock("%s Xychorium Gem Storage", XyCraftColors.class).withBlockProperties(CommonBlockProperties::XychoriumProperties).withModelType(BlockModelType.Custom).build();
        public static final EnumMap<XyCraftColors, BlockContent> InvertedBricksCloud = Map.coloredBlock("%s Inverted Bricks", XyCraftColors.class, InvertedBlock::new).withBlockProperties(CommonBlockProperties::XychoriumProperties).withModelType(BlockModelType.Custom).build();
        public static final EnumMap<XyCraftColors, BlockContent> InvertedTilesCloud = Map.coloredBlock("%s Inverted Tiles", XyCraftColors.class, InvertedBlock::new).withBlockProperties(CommonBlockProperties::XychoriumProperties).withModelType(BlockModelType.Custom).build();
        public static final EnumMap<XyCraftColors, BlockContent> MatteXychoriumBricks = Map.coloredBlock("Matte %s Bricks", XyCraftColors.class, ColoredBlock::noTint).withModelType(BlockModelType.Simple).withConsumer((customColors, content) -> content.withModelPath(content.id().getPath())).build();
        public static final EnumMap<XyCraftColors, BlockContent> MatteXychoriumBricksShiny = Map.coloredBlock("Matte %s Shiny Bricks", XyCraftColors.class, ColoredBlock::noTint).withModelType(BlockModelType.Special).withConsumer((customColors, content) -> content.withModelPath(content.id().getPath()).withEmissivity(10)).build();
        public static final EnumMap<XyCraftColors, BlockContent> MatteXychoriumLayersShiny = Map.coloredBlock("Matte %s Shiny Layers", XyCraftColors.class, ColoredBlock::noTint).withModelType(BlockModelType.Special).withConsumer((customColors, content) -> content.withModelPath(content.id().getPath()).withEmissivity(10)).build();
        public static final BlockContent GlassViewer = Map.block("Glass Viewer", GlassBlock::new).withBlockProperties(CommonBlockProperties::GlassProperties).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerSilicon = Map.block("Silicon Glass Viewer", GlassBlock::new).withBlockProperties(CommonBlockProperties::GlassProperties).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerDire = Map.block("Dire Glass Viewer", GlassBlock::new).withBlockProperties(CommonBlockProperties::GlassProperties).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerGlowing = Map.block("Glowing Glass Viewer", GlassBlock::new).withBlockProperties(() -> CommonBlockProperties.GlassProperties().lightLevel(value -> 15)).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerGlowingClear = Map.block("Dire Glass Viewer", GlassBlock::new).withBlockProperties(() -> CommonBlockProperties.GlassProperties().lightLevel(value -> 15)).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerDark = Map.block("Dark Glass Viewer", TintedGlassBlock::new).withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TINTED_GLASS).sound(SoundType.AMETHYST)).withModelType(BlockModelType.Custom).build();
        public static final BlockContent GlassViewerReinforced = Map.block("Reinforced Glass Viewer", GlassBlock::new).withBlockProperties(() -> CommonBlockProperties.GlassProperties().destroyTime(Blocks.DEEPSLATE.defaultDestroyTime())).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerImmortal = Map.block("Immortal Glass Viewer", ImmortalGlassBlock::new).withBlockProperties(CommonBlockProperties::GlassProperties).withModelType(BlockModelType.Connected).build();
        public static final BlockContent GlassViewerPhantom = Map.block("Phantom Glass Viewer", PhantomGlassViewerBlock::new).withBlockProperties(CommonBlockProperties::GlassProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent GlassViewerPhantomGlowing = Map.block("Glowing Phantom Glass Viewer", PhantomGlassViewerBlock::glow).withBlockProperties(CommonBlockProperties::GlassProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent GlassViewerPhantomDark = Map.block("Dark Phantom Glass Viewer", PhantomGlassViewerBlock::new).withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TINTED_GLASS).noCollission().sound(SoundType.AMETHYST)).withModelType(BlockModelType.Custom).build();
        public static final EnumMap<DyeColors, BlockContent> GlassViewerRgbGlowing = Map.coloredBlock("Glowing RGB Viewer", DyeColors.class, RGBGlassBlock::glow).copyPropertiesFrom(() -> ((BlockContent)GlassViewer).block()).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhite).build();
        public static final EnumMap<DyeColors, BlockContent> GlassViewerRgb = Map.coloredBlock("RGB Viewer", DyeColors.class, RGBGlassBlock::new).copyPropertiesFrom(() -> ((BlockContent)GlassViewer).block()).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhite).build();
        public static final EnumMap<DyeColors, BlockContent> LampLantern = Map.coloredBlock("RGB Lantern Lamp", DyeColors.class, LampLanternBlock::new).copyPropertiesFrom(() -> Blocks.LANTERN).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhiteWithCustomItemModel).build();
        public static final EnumMap<DyeColors, BlockContent> LampFlush = Map.coloredBlock("RGB Flush Lamp", DyeColors.class, LampFlushBlock::new).copyPropertiesFrom(() -> Blocks.LANTERN).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhiteWithCustomItemModel).build();
        public static final EnumMap<DyeColors, BlockContent> LampCube = Map.coloredBlock("RGB Cube Lamp", DyeColors.class, LampCubeBlock::new).copyPropertiesFrom(() -> Blocks.LANTERN).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhiteWithCustomItemModel).build();
        public static final EnumMap<DyeColors, BlockContent> LampPillar = Map.coloredBlock("RGB Pillar Lamp", DyeColors.class, LampPillarBlock::new).copyPropertiesFrom(() -> Blocks.LANTERN).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhiteWithCustomItemModel).build();
        public static final EnumMap<DyeColors, BlockContent> LampRgbGlowing = Map.coloredBlock("RGB Lamp", DyeColors.class, LampColoredBlock::normal).copyPropertiesFrom(() -> ((BlockContent)AluminumStorage).block()).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultWhite).build();
        public static final EnumMap<DyeColors, BlockContent> LampRgbGlowingInverted = Map.coloredBlock("Inverted RGB Lamp", DyeColors.class, LampColoredBlock::inverted).copyPropertiesFrom(() -> ((BlockContent)AluminumStorage).block()).withModelType(BlockModelType.Custom).withConsumer((color, content) -> WorldContent.defaultWhite(color, content).withModelPath(LampRgbGlowing.get(DyeColors.White).modelPath())).build();
        public static final EnumMap<DyeColors, BlockContent> AureyBlockMatte = Map.coloredBlock("Matte Aurey Block", DyeColors.class, AureyBlock::new).copyPropertiesFrom(() -> ((BlockContent)AluminumStorage).block()).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultPink).build();
        public static final EnumMap<DyeColors, BlockContent> AureyBlockMatteGlowing = Map.coloredBlock("Glowing Matte Aurey Block", DyeColors.class, AureyBlock::glow).copyPropertiesFrom(() -> ((BlockContent)AluminumStorage).block()).withModelType(BlockModelType.Custom).withConsumer(WorldContent::defaultPink).build();
        public static final EnumMap<DyeColors, BlockContent> AureyBlockFx = Map.coloredBlock("Shiny Aurey Block", DyeColors.class, AureyBlock::new).copyPropertiesFrom(() -> ((BlockContent)AluminumStorage).block()).withModelType(BlockModelType.Custom).withTab(null).withConsumer(WorldContent::customBreakRule).build();
        public static final EnumMap<DyeColors, BlockContent> AureyBlockFxGlowing = Map.coloredBlock("Glowing Shiny Aurey Block", DyeColors.class, AureyBlock::glow).copyPropertiesFrom(() -> ((BlockContent)AluminumStorage).block()).withModelType(BlockModelType.Custom).withTab(null).withConsumer(WorldContent::customBreakRule).build();
        public static final TorchBlockContent CopperTorch = (TorchBlockContent)Map.torch("Copper Torch", XyTorchBlock::new, XyWallTorchBlock::new).withParticle(() -> WorldParticles.CopperFlame).withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).mapColor(MapColor.COLOR_LIGHT_GREEN)).build().withCustomItemModel().withCustomBreakRule().withModelType(BlockModelType.Custom);
        public static final TorchBlockContent AluminumTorch = (TorchBlockContent)((TorchBlockContentRegistrationBuilder)Map.torch("Aluminum Torch", XyTorchBlock::new, XyWallTorchBlock::new).withParticle(() -> WorldParticles.AluminumFlame).withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).mapColor(MapColor.TERRACOTTA_WHITE)).withName("Aluminium Torch", MCLocale.OFF_BRAND_ENGLISH)).build().withCustomItemModel().withCustomBreakRule().withModelType(BlockModelType.Custom);
        public static final EnumMap<XyCraftColors, BlockContent> XychoriumOreStone = Map.coloredBlock("%s Xychorium Ore", XyCraftColors.class, OreColoredBlock::new).copyPropertiesFrom(() -> Blocks.STONE).withModelType(BlockModelType.Cloud).withConsumer(WorldContent::customBreakRule).build();
        public static final EnumMap<XyCraftColors, BlockContent> XychoriumOreDeepslate = Map.coloredBlock("Deepslate %s Xychorium Ore", XyCraftColors.class, OreColoredBlock::new).copyPropertiesFrom(() -> Blocks.DEEPSLATE).withModelType(BlockModelType.Cloud).withConsumer(WorldContent::customBreakRule).build();
        public static final EnumMap<XyCraftColors, BlockContent> XychoriumOreKivi = Map.coloredBlock("Kivi %s Xychorium Ore", XyCraftColors.class, OreColoredBlock::new).copyPropertiesFrom(() -> ((BlockContent)Kivi).block()).withModelType(BlockModelType.Cloud).withConsumer(WorldContent::customBreakRule).build();
        public static final BlockContent AluminumOreStone = ((BlockContentRegistrationBuilder)Map.block("Aluminum Ore").copyPropertiesFrom(() -> Blocks.COPPER_ORE).withName("Aluminium Ore", MCLocale.OFF_BRAND_ENGLISH)).build().withCustomBreakRule();
        public static final BlockContent AluminumOreDeepslate = ((BlockContentRegistrationBuilder)Map.block("Deepslate Aluminum Ore").copyPropertiesFrom(() -> Blocks.DEEPSLATE_COPPER_ORE).withName("Deepslate Aluminium Ore", MCLocale.OFF_BRAND_ENGLISH)).build().withCustomBreakRule();
        public static final BlockContent AluminumOreKivi = ((BlockContentRegistrationBuilder)Map.block("Kivi Aluminum Ore").copyPropertiesFrom(() -> ((BlockContent)Kivi).block()).withName("Kivi Aluminium Ore", MCLocale.OFF_BRAND_ENGLISH)).build().withCustomBreakRule();
        public static final BlockContent RawAluminumBlock = ((BlockContentRegistrationBuilder)Map.block("Block of Raw Aluminum").copyPropertiesFrom(() -> Blocks.RAW_COPPER_BLOCK).withName("Block of Raw Aluminium", MCLocale.OFF_BRAND_ENGLISH)).build();
        public static final BlockContent Geyser = Map.block("Ore Geyser", GeyserBlock::new).withModelType(BlockModelType.Custom).build().withCustomBreakRule();
    }

    public static interface Item {
        public static final Item INSTANCE = new Item(){};
        public static final EnumMap<XyCraftColors, ItemContent> XychoriumGem = Map.coloredItem("%s Xychorium Gems", XyCraftColors.class).build();
        public static final ItemContent RawAluminum = ((ItemContentRegistrationBuilder)((ItemContentRegistrationBuilder)((ItemContentRegistrationBuilder)Map.item("Raw Aluminum").withName("Raw Aluminium", MCLocale.OFF_BRAND_ENGLISH)).withName("Raw Alulu shiny", new MCLocale[]{MCLocale.LOL_CAT})).withName("Raw Fighting Words", new MCLocale[]{MCLocale.PIRATE})).build();
        public static final ItemContent AluminumIngot = ((ItemContentRegistrationBuilder)((ItemContentRegistrationBuilder)((ItemContentRegistrationBuilder)Map.item("Aluminum Ingot").withName("Aluminium Ingot", MCLocale.OFF_BRAND_ENGLISH)).withName("Alulu shiny Ingut", new MCLocale[]{MCLocale.LOL_CAT})).withName("Fighting Sentence", new MCLocale[]{MCLocale.PIRATE})).build();
        public static final ItemContent AluminumNugget = ((ItemContentRegistrationBuilder)((ItemContentRegistrationBuilder)((ItemContentRegistrationBuilder)Map.item("Aluminum Nugget").withName("Aluminium Nugget", MCLocale.OFF_BRAND_ENGLISH)).withName("Smol Alulu shiny", new MCLocale[]{MCLocale.LOL_CAT})).withName("Small Disagreement", new MCLocale[]{MCLocale.PIRATE})).build();
    }
}

