/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks.lamps;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.ShapeUtils;
import tv.soaryn.xycraft.world.content.blocks.SidedLightSourceBlock;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.MOD)
public class LampLanternBlock
extends SidedLightSourceBlock {
    private static final VoxelShape[] shapes = (VoxelShape[])Util.make((Object)new VoxelShape[4], voxelShapes -> {
        int offset = 0;
        VoxelShape lanternBox = Shapes.or((VoxelShape)LampLanternBlock.box((double)5.0, (double)offset, (double)5.0, (double)11.0, (double)(7 + offset), (double)11.0), (VoxelShape)LampLanternBlock.box((double)6.0, (double)(7 + offset), (double)6.0, (double)10.0, (double)(9 + offset), (double)10.0));
        VoxelShape upLantern = lanternBox.move(0.0, 0.0625, 0.0);
        VoxelShape mountXl = Shapes.or((VoxelShape)ShapeUtils.rotate((VoxelShape)MountShapeXl, (Direction)Direction.UP), (VoxelShape)LampLanternBlock.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        VoxelShape mount = Shapes.or((VoxelShape)ShapeUtils.rotate((VoxelShape)MountShape, (Direction)Direction.UP), (VoxelShape)LampLanternBlock.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        voxelShapes[0] = lanternBox;
        voxelShapes[1] = Shapes.or((VoxelShape)upLantern, (VoxelShape)mountXl);
        voxelShapes[2] = Shapes.or((VoxelShape)upLantern, (VoxelShape)mount);
    });

    public LampLanternBlock(IColorSource color, BlockBehaviour.Properties properties) {
        super(color, properties);
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new LampLanternBlock((IColorSource)new ColorSource.Dye(color), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN));
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, DeferredBlock<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        EnumMap<DyeColors, BlockContent> map = WorldContent.Block.LampLantern;
        Block[] lamps = (Block[])map.values().stream().map(BlockContent::block).toArray(Block[]::new);
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, ignored1, ignored2, ignored13) -> (player, interactionHand, hitResult) -> {
            BlockState state = level.getBlockState(pos);
            if (state.getValue((Property)CoreStateProperties.StateDirection) == Direction.DOWN) {
                return InteractionResult.CONSUME_PARTIAL;
            }
            level.setBlock(pos, (BlockState)state.cycle((Property)SidedLightSourceBlock.StateProperties.Xl), 8);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }, lamps);
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, LampLanternBlock.coloredLampProvider(map), lamps);
    }

    public VoxelShape getDownShapeForBaking() {
        return MountShape;
    }

    @Override
    public EnumSet<Direction> getValidMountDirections() {
        return EnumSet.of(Direction.UP, Direction.DOWN);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean up = state.getValue((Property)CoreStateProperties.StateDirection) == Direction.UP;
        Boolean large = (Boolean)state.getValue((Property)SidedLightSourceBlock.StateProperties.Xl);
        if (!up) {
            return shapes[0];
        }
        return shapes[large != false ? 1 : 2];
    }

    @Override
    protected EnumMap<DyeColors, BlockContent> getCurrentMap(int light, BlockState state) {
        return WorldContent.Block.LampLantern;
    }
}

