/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks.lamps;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.blocks.SidedLightSourceBlock;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.MOD)
public class LampCubeBlock
extends SidedLightSourceBlock {
    private static final VoxelShape _core = LampCubeBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final Reference2ObjectMap<Direction, VoxelShape> _shapeCache = LampCubeBlock.cacheShape(_core, MountShape);
    private static final Reference2ObjectMap<Direction, VoxelShape> _shapeCacheXL = LampCubeBlock.cacheShape(_core, MountShapeXl);

    public LampCubeBlock(IColorSource color, BlockBehaviour.Properties properties) {
        super(color, properties);
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new LampCubeBlock((IColorSource)new ColorSource.Dye(color), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN));
    }

    public static Supplier<Item> itemSupplier(DyeColor ignored, DeferredBlock<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        EnumMap<DyeColors, BlockContent> map = WorldContent.Block.LampCube;
        Block[] blocks = (Block[])map.values().stream().map(BlockContent::block).toArray(Block[]::new);
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, LampCubeBlock.coloredLampProvider(map), blocks);
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, ignored1, ignored2, ignored13) -> (player, interactionHand, hitResult) -> {
            AABB box = AABB.ofSize((Vec3)hitResult.getBlockPos().getCenter(), (double)0.52f, (double)0.52f, (double)0.52f);
            BlockState state = level.getBlockState(pos);
            if (!box.contains(hitResult.getLocation())) {
                level.setBlock(pos, (BlockState)state.cycle((Property)SidedLightSourceBlock.StateProperties.Xl), 8);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return WrenchCapability.rotate((Level)level, (BlockState)state, (BlockPos)pos, (BlockHitResult)hitResult);
        }, blocks);
    }

    public VoxelShape getDownShapeForBaking() {
        return MountShape;
    }

    @Override
    public EnumSet<Direction> getValidMountDirections() {
        return EnumSet.allOf(Direction.class);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (VoxelShape)((Boolean)state.getValue((Property)SidedLightSourceBlock.StateProperties.Xl) != false ? _shapeCacheXL : _shapeCache).get((Object)SidePartBlock.directionOf((BlockState)state));
    }

    @Override
    protected EnumMap<DyeColors, BlockContent> getCurrentMap(int light, BlockState state) {
        return WorldContent.Block.LampCube;
    }
}

