/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.entity.base;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import es.degrassi.mmreborn.ars.common.block.prop.SourceHatchSize;
import es.degrassi.mmreborn.ars.common.machine.component.SourceComponent;
import es.degrassi.mmreborn.ars.common.network.server.component.SUpdatePosComponentPacket;
import es.degrassi.mmreborn.common.entity.base.BlockEntityRestrictedTick;
import es.degrassi.mmreborn.common.entity.base.MachineComponentEntity;
import es.degrassi.mmreborn.common.machine.IOType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class SourceHatchEntity
extends BlockEntityRestrictedTick
implements MachineComponentEntity<SourceComponent>,
IWandable,
ITooltipProvider,
ISourceTile {
    private SourceStorage tank;
    private IOType ioType;
    private SourceHatchSize hatchSize;
    private BlockPos toPos;
    private BlockPos fromPos;
    private static final String TO = "to_";
    private static final String FROM = "from";

    public SourceHatchEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SourceHatchEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, SourceHatchSize size, IOType ioType) {
        super(type, pos, state);
        this.tank = size.buildTank(this, ioType == IOType.INPUT, ioType == IOType.OUTPUT);
        this.hatchSize = size;
    }

    public void setToPos(BlockPos toPos) {
        this.toPos = toPos;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdatePosComponentPacket(true, toPos, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setFromPos(BlockPos fromPos) {
        this.fromPos = fromPos;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SUpdatePosComponentPacket(false, this.toPos, this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.ioType = compound.getBoolean("input") ? IOType.INPUT : IOType.OUTPUT;
        this.hatchSize = SourceHatchSize.value(compound.getString("size"));
        SourceStorage newTank = this.hatchSize.buildTank(this, this.ioType == IOType.INPUT, this.ioType == IOType.OUTPUT);
        Tag tankTag = compound.get("tank");
        if (tankTag != null) {
            newTank.deserializeNBT(provider, tankTag);
        }
        this.tank = newTank;
        this.toPos = null;
        this.fromPos = null;
        if (NBTUtil.hasBlockPos((CompoundTag)compound, (String)TO)) {
            this.toPos = NBTUtil.getBlockPos((CompoundTag)compound, (String)TO);
        }
        if (NBTUtil.hasBlockPos((CompoundTag)compound, (String)FROM)) {
            this.fromPos = NBTUtil.getBlockPos((CompoundTag)compound, (String)FROM);
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putBoolean("input", this.ioType == IOType.INPUT);
        compound.putString("size", this.hatchSize.getSerializedName());
        Tag tankTag = this.tank.serializeNBT(provider);
        compound.put("tank", tankTag);
        if (this.toPos != null) {
            NBTUtil.storeBlockPos((CompoundTag)compound, (String)TO, (BlockPos)this.toPos.immutable());
        } else {
            NBTUtil.removeBlockPos((CompoundTag)compound, (String)TO);
        }
        if (this.fromPos != null) {
            NBTUtil.storeBlockPos((CompoundTag)compound, (String)FROM, (BlockPos)this.fromPos.immutable());
        } else {
            NBTUtil.removeBlockPos((CompoundTag)compound, (String)FROM);
        }
    }

    public SourceStorage getTank() {
        if (this.tank == null) {
            this.tank = this.hatchSize.buildTank(this, this.ioType == IOType.INPUT, this.ioType == IOType.OUTPUT);
            if (this.level != null) {
                this.level.invalidateCapabilities(this.worldPosition);
            }
        }
        return this.tank;
    }

    public IWandable.Result onFirstConnection(@Nullable GlobalPos globalPos, Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockPos storedPos = Optional.ofNullable(globalPos).map(GlobalPos::pos).orElse(null);
        if (this.level == null || storedPos == null || this.level.isClientSide || storedPos.equals((Object)this.getBlockPos()) || !(this.level.getBlockEntity(storedPos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(storedPos) instanceof SourceHatchEntity)) {
            return IWandable.Result.NONE;
        }
        if (this.setSendTo(storedPos.immutable())) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"modular_machinery_reborn_ars.connections.send", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
            ParticleUtil.beam((BlockPos)storedPos, (BlockPos)this.worldPosition, (Level)this.level);
            return IWandable.Result.SUCCESS;
        }
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"modular_machinery_reborn_ars.connections.fail"));
        return IWandable.Result.FAIL;
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos globalPos, Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockPos storedPos = Optional.ofNullable(globalPos).map(GlobalPos::pos).orElse(null);
        if (this.level == null || storedPos == null || storedPos.equals((Object)this.getBlockPos()) || this.level.getBlockEntity(storedPos) instanceof RelayTile || !(this.level.getBlockEntity(storedPos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(storedPos) instanceof SourceHatchEntity)) {
            return IWandable.Result.NONE;
        }
        if (this.setTakeFrom(storedPos.immutable())) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"modular_machinery_reborn_ars.connections.take", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
            return IWandable.Result.SUCCESS;
        }
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"modular_machinery_reborn_ars.connections.fail"));
        return IWandable.Result.FAIL;
    }

    public IWandable.Result onClearConnections(Player playerEntity) {
        this.clearPos();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.cleared"));
        return IWandable.Result.CLEAR;
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.toPos != null) {
            list.add(ColorPos.centered((BlockPos)this.toPos, (ParticleColor)ParticleColor.TO_HIGHLIGHT));
        }
        if (this.fromPos != null) {
            list.add(ColorPos.centered((BlockPos)this.fromPos, (ParticleColor)ParticleColor.FROM_HIGHLIGHT));
        }
        return list;
    }

    public int getMaxDistance() {
        return 30;
    }

    public boolean setTakeFrom(BlockPos pos) {
        if (BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.worldPosition) > (double)this.getMaxDistance() || pos.equals((Object)this.getBlockPos())) {
            return false;
        }
        this.setFromPos(pos);
        return true;
    }

    public boolean setSendTo(BlockPos pos) {
        if (BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.worldPosition) > (double)this.getMaxDistance() || pos.equals((Object)this.getBlockPos()) || !(Objects.requireNonNull(this.level).getBlockEntity(pos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(pos) instanceof SourceHatchEntity)) {
            return false;
        }
        this.setToPos(pos);
        return true;
    }

    public void clearPos() {
        this.setToPos(null);
        this.setFromPos(null);
    }

    public int transferSource(ISourceTile from, ISourceTile to) {
        int transferRate = this.getTransferRate(from, to);
        from.removeSource(transferRate);
        to.addSource(transferRate);
        this.markForUpdate();
        return transferRate;
    }

    public int transferSource(ISourceCap from, ISourceCap to) {
        int transfer = to.receiveSource(from.extractSource(from.getMaxExtract(), true), true);
        if (transfer == 0) {
            return 0;
        }
        from.extractSource(transfer, false);
        to.receiveSource(transfer, false);
        this.markForUpdate();
        return transfer;
    }

    public int getTransferRate(ISourceTile from, ISourceTile to) {
        return Math.min(Math.min(from.getTransferRate(), from.getSource()), to.getMaxSource() - to.getSource());
    }

    public void getTooltip(List<Component> tooltip) {
        tooltip.clear();
        if (this.toPos == null) {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn_ars.relay.no_to"));
        } else {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn_ars.relay.one_to", (Object[])new Object[]{1}));
        }
        if (this.fromPos == null) {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn_ars.relay.no_from"));
        } else {
            tooltip.add((Component)Component.translatable((String)"modular_machinery_reborn_ars.relay.one_from", (Object[])new Object[]{1}));
        }
    }

    private ParticleColor getParticleColor() {
        return ParticleColor.defaultParticleColor();
    }

    public void doRestrictedTick() {
        SourceHatchEntity from;
        Object object;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 20L != 0L) {
            return;
        }
        if (this.fromPos != null && this.level.isLoaded(this.fromPos)) {
            if (!(this.level.getBlockEntity(this.fromPos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(this.fromPos) instanceof SourceHatchEntity) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.fromPos, null) == null) {
                this.setFromPos(null);
                this.markForUpdate();
                return;
            }
            object = this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.fromPos, null);
            if (object instanceof ISourceCap) {
                ISourceCap handler = (ISourceCap)object;
                if (this.transferSource(handler, (ISourceCap)this.getTank()) > 0) {
                    ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.fromPos, (BlockPos)this.worldPosition, (ParticleColor)this.getParticleColor());
                }
                return;
            }
            object = this.level.getBlockEntity(this.fromPos);
            if (object instanceof SourceHatchEntity) {
                SourceHatchEntity from2 = (SourceHatchEntity)((Object)object);
                if (this.transferSource((ISourceCap)from2.tank, (ISourceCap)this.getTank()) > 0) {
                    ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.fromPos, (BlockPos)this.worldPosition, (ParticleColor)this.getParticleColor());
                }
                return;
            }
            object = this.level.getBlockEntity(this.fromPos);
            if (object instanceof AbstractSourceMachine && this.transferSource((ISourceCap)(from = (AbstractSourceMachine)object).getSourceStorage(), (ISourceCap)this.getTank()) > 0) {
                ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.fromPos, (BlockPos)this.worldPosition, (ParticleColor)this.getParticleColor());
            }
        }
        if (this.toPos != null && this.level.isLoaded(this.toPos)) {
            if (!(this.level.getBlockEntity(this.toPos) instanceof AbstractSourceMachine) && !(this.level.getBlockEntity(this.toPos) instanceof SourceHatchEntity) && this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.toPos, null) == null) {
                this.setToPos(null);
                this.markForUpdate();
                return;
            }
            object = this.level.getCapability(CapabilityRegistry.SOURCE_CAPABILITY, this.toPos, null);
            if (object instanceof ISourceCap) {
                ISourceCap handler = (ISourceCap)object;
                if (this.transferSource(handler, (ISourceCap)this.getTank()) > 0) {
                    ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.worldPosition, (BlockPos)this.toPos, (ParticleColor)this.getParticleColor());
                }
                return;
            }
            object = this.level.getBlockEntity(this.toPos);
            if (object instanceof SourceHatchEntity) {
                from = (SourceHatchEntity)((Object)object);
                if (this.transferSource((ISourceCap)from.tank, (ISourceCap)this.getTank()) > 0) {
                    ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.worldPosition, (BlockPos)this.toPos, (ParticleColor)this.getParticleColor());
                }
                return;
            }
            object = this.level.getBlockEntity(this.toPos);
            if (object instanceof AbstractSourceMachine && this.transferSource((ISourceCap)(from = (AbstractSourceMachine)object).getSourceStorage(), (ISourceCap)this.getTank()) > 0) {
                ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.worldPosition, (BlockPos)this.toPos, (ParticleColor)this.getParticleColor());
            }
        }
    }

    public int getTransferRate() {
        return this.getMaxSource();
    }

    public boolean canAcceptSource() {
        return this.ioType.isInput() && this.tank.getSource() < this.tank.getMaxSource();
    }

    public int getSource() {
        return this.tank.getSource();
    }

    public int getMaxSource() {
        return this.tank.getMaxSource();
    }

    public int setSource(int source) {
        this.tank.setSource(source);
        return this.getMaxSource();
    }

    public int addSource(int source, boolean simulate) {
        return this.tank.receiveSource(source, simulate);
    }

    public int addSource(int source) {
        return this.tank.receiveSource(source, false);
    }

    public int removeSource(int source, boolean simulate) {
        return this.tank.extractSource(source, simulate);
    }

    public int removeSource(int source) {
        return this.tank.receiveSource(source, false);
    }

    @Generated
    public IOType getIoType() {
        return this.ioType;
    }

    @Generated
    public SourceHatchSize getHatchSize() {
        return this.hatchSize;
    }

    @Generated
    public BlockPos getToPos() {
        return this.toPos;
    }

    @Generated
    public BlockPos getFromPos() {
        return this.fromPos;
    }

    @Generated
    public void setTank(SourceStorage tank) {
        this.tank = tank;
    }

    @Generated
    public void setIoType(IOType ioType) {
        this.ioType = ioType;
    }

    @Generated
    public void setHatchSize(SourceHatchSize hatchSize) {
        this.hatchSize = hatchSize;
    }
}

