/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.data;

import es.degrassi.mmreborn.ars.common.block.prop.SourceHatchSize;
import lombok.Generated;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MMRConfig {
    private static final MMRConfig INSTANCE;
    private static final ModConfigSpec spec;
    public final ModConfigSpec.ConfigValue<Integer> TINY_size;
    public final ModConfigSpec.ConfigValue<Integer> SMALL_size;
    public final ModConfigSpec.ConfigValue<Integer> NORMAL_size;
    public final ModConfigSpec.ConfigValue<Integer> REINFORCED_size;
    public final ModConfigSpec.ConfigValue<Integer> BIG_size;
    public final ModConfigSpec.ConfigValue<Integer> HUGE_size;
    public final ModConfigSpec.ConfigValue<Integer> LUDICROUS_size;
    public final ModConfigSpec.ConfigValue<Integer> VACUUM_size;

    public MMRConfig(ModConfigSpec.Builder builder) {
        builder.push(SourceHatchSize.TINY.getSerializedName());
        this.TINY_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.TINY.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.SMALL.getSerializedName());
        this.SMALL_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.SMALL.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.NORMAL.getSerializedName());
        this.NORMAL_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.NORMAL.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.REINFORCED.getSerializedName());
        this.REINFORCED_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.REINFORCED.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.BIG.getSerializedName());
        this.BIG_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.BIG.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.HUGE.getSerializedName());
        this.HUGE_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.HUGE.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.LUDICROUS.getSerializedName());
        this.LUDICROUS_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.LUDICROUS.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push(SourceHatchSize.VACUUM.getSerializedName());
        this.VACUUM_size = builder.comment("Defines the source tank size").defineInRange("size", SourceHatchSize.VACUUM.defaultConfigurationValue, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public int sourceSize(SourceHatchSize size) {
        return switch (size) {
            default -> throw new MatchException(null, null);
            case SourceHatchSize.TINY -> (Integer)this.TINY_size.get();
            case SourceHatchSize.SMALL -> (Integer)this.SMALL_size.get();
            case SourceHatchSize.NORMAL -> (Integer)this.NORMAL_size.get();
            case SourceHatchSize.REINFORCED -> (Integer)this.REINFORCED_size.get();
            case SourceHatchSize.BIG -> (Integer)this.BIG_size.get();
            case SourceHatchSize.HUGE -> (Integer)this.HUGE_size.get();
            case SourceHatchSize.LUDICROUS -> (Integer)this.LUDICROUS_size.get();
            case SourceHatchSize.VACUUM -> (Integer)this.VACUUM_size.get();
        };
    }

    public static MMRConfig get() {
        return INSTANCE;
    }

    @Generated
    public static ModConfigSpec getSpec() {
        return spec;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(MMRConfig::new);
        INSTANCE = (MMRConfig)pair.getLeft();
        spec = (ModConfigSpec)pair.getRight();
    }
}

