/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.ability.enderpearlhungercost;

import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EnderpearlItem.class})
public abstract class EnderPearlItemMixin
extends Item {
    public EnderPearlItemMixin(Item.Properties properties) {
        super(properties);
    }

    @WrapOperation(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;consume(ILnet/minecraft/world/entity/LivingEntity;)V")})
    private void shouldConsumeEnderPearl(ItemStack stack, int amount, LivingEntity entity, Operation<Void> operation) {
        if (EquipmentHelper.hasAbilityActive(ModDataComponents.ENDER_PEARL_HUNGER_COST.get(), entity, true) && entity instanceof Player) {
            Player player = (Player)entity;
            int cost = EquipmentHelper.minInt(ModDataComponents.ENDER_PEARL_HUNGER_COST.get(), (LivingEntity)player, 20, ability -> (Integer)ability.cost().get(), true);
            if (player.getFoodData().getFoodLevel() >= cost) {
                if (cost > 0 && !player.isCreative()) {
                    player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() - cost);
                    entity.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.5f, 0.8f + entity.getRandom().nextFloat() * 0.4f);
                }
                int cooldown = EquipmentHelper.maxInt(ModDataComponents.ENDER_PEARL_HUNGER_COST.get(), (LivingEntity)player, ability -> (Integer)ability.cooldown().get(), true);
                if (!player.isCreative()) {
                    player.getCooldowns().addCooldown((Item)this, cooldown * 20);
                }
                return;
            }
        }
        operation.call(new Object[]{stack, amount, entity});
    }
}

