/*
 * Decompiled with CFR 0.152.
 */
package artifacts.integration.accessories;

import artifacts.equipment.EquipmentSlotProvider;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.function.BiFunction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AccessoriesSlotProvider
implements EquipmentSlotProvider {
    @Override
    public <T> T reduceEquipment(LivingEntity entity, T init, BiFunction<ItemStack, T, T> f) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            for (SlotEntryReference slotEntryReference : capability.getAllEquipped()) {
                init = f.apply(slotEntryReference.stack(), (ItemStack)init);
            }
        }
        return init;
    }

    @Override
    public boolean tryEquipItem(LivingEntity entity, ItemStack stack) {
        Pair possibleLocation;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null && (possibleLocation = capability.canEquipAccessory(stack, false)) != null) {
            ((EquipAction)possibleLocation.second()).equipStack(stack);
            return true;
        }
        return false;
    }
}

