/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.retaliation;

import artifacts.component.ability.retaliation.RetaliationEffect;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class LightningEffect
extends RetaliationEffect {
    public static final Codec<LightningEffect> CODEC = RecordCodecBuilder.create(instance -> LightningEffect.codecStart(instance).apply((Applicative)instance, LightningEffect::new));
    public static final StreamCodec<ByteBuf, LightningEffect> STREAM_CODEC = StreamCodec.composite(ValueTypes.FRACTION.streamCodec(), RetaliationEffect::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationEffect::cooldown, LightningEffect::new);

    public LightningEffect(Value<Double> strikeChance, Value<Integer> cooldown) {
        super("lightning", strikeChance, cooldown);
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        LightningBolt lightningBolt;
        if (attacker.level().canSeeSky(BlockPos.containing((Position)attacker.position())) && (lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(attacker.level())) != null) {
            ServerPlayer player;
            lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)attacker.blockPosition()));
            lightningBolt.setCause(attacker instanceof ServerPlayer ? (player = (ServerPlayer)attacker) : null);
            attacker.level().addFreshEntity((Entity)lightningBolt);
        }
    }
}

