/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.registry.ModTags;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public enum EntityCondition implements StringRepresentable
{
    ALWAYS("always", entity -> true),
    NEVER("never", entity -> false),
    ABOVE_WATER("above_water", entity -> !entity.isEyeInFluid(FluidTags.WATER)),
    IN_WATER("in_water", Entity::isInWater),
    ON_GRASS("on_grass", entity -> entity.onGround() && entity.getBlockStateOn().is(ModTags.ROOTED_BOOTS_GRASS)),
    SNEAKING("while_sneaking", Entity::isCrouching),
    SPRINTING("while_sprinting", entity -> entity.isSprinting() && !entity.isUsingItem() && !entity.isCrouching());

    public static final Codec<EntityCondition> CODEC;
    public static final StreamCodec<ByteBuf, EntityCondition> STREAM_CODEC;
    private final String name;
    private final Predicate<LivingEntity> predicate;

    private EntityCondition(String name, Predicate<LivingEntity> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    public boolean test(LivingEntity entity) {
        return this.predicate.test(entity);
    }

    public String getSerializedName() {
        return this.toString();
    }

    public String toString() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromValues(EntityCondition::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(i -> EntityCondition.values()[i], Enum::ordinal);
    }
}

