/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import com.teammetallurgy.aquaculture.item.BaitItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AquaFishingRodItem
extends FishingRodItem {
    private final Tier tier;
    private final int enchantability;

    public AquaFishingRodItem(Tier tier, Item.Properties properties) {
        super(properties);
        this.enchantability = tier == Tiers.WOOD ? 10 : tier.getEnchantmentValue();
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return this.getDamage(stack) < this.getMaxDamage(stack) && super.isBarVisible(stack);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (player instanceof FakePlayer) {
            return InteractionResultHolder.fail((Object)heldStack);
        }
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && this.tier == AquacultureAPI.MATS.NEPTUNIUM;
        int damage = this.getDamage(heldStack);
        if (damage >= this.getMaxDamage(heldStack)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
        }
        Hook hook = AquaFishingRodItem.getHookType(heldStack);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                int currentDamage;
                int retrieve = player.fishing.retrieve(heldStack);
                if (retrieve >= (currentDamage = this.getMaxDamage(heldStack) - damage)) {
                    retrieve = currentDamage;
                }
                if (!isAdminRod) {
                    if (hook != Hooks.EMPTY && hook.getDurabilityChance() > 0.0) {
                        if (level.random.nextDouble() >= hook.getDurabilityChance()) {
                            heldStack.hurtAndBreak(retrieve, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        }
                    } else {
                        heldStack.hurtAndBreak(retrieve, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                }
            }
            player.swing(hand);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int lureSpeed = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverLevel, (ItemStack)heldStack, (Entity)player) * 20.0f);
                if (this.tier == AquacultureAPI.MATS.NEPTUNIUM) {
                    lureSpeed += 100;
                }
                ItemStack bait = AquaFishingRodItem.getBait(heldStack);
                if (!isAdminRod && !bait.isEmpty()) {
                    lureSpeed += ((BaitItem)bait.getItem()).getLureSpeedModifier() * 100;
                }
                lureSpeed = Math.min(500, lureSpeed);
                int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)heldStack, (Entity)player);
                if (hook != Hooks.EMPTY && hook.getLuckModifier() > 0) {
                    luck += hook.getLuckModifier();
                }
                level.addFreshEntity((Entity)new AquaFishingBobberEntity(player, level, luck, lureSpeed, hook, AquaFishingRodItem.getFishingLine(heldStack), AquaFishingRodItem.getBobber(heldStack), heldStack));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)heldStack, (boolean)level.isClientSide());
    }

    public boolean isValidRepairItem(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.tier.getRepairIngredient().test(repair) || super.isValidRepairItem(toRepair, repair);
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS.contains(toolAction);
    }

    @Nonnull
    public static Hook getHookType(@Nonnull ItemStack fishingRod) {
        Hook hook = Hooks.EMPTY;
        ItemStack hookStack = AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(0);
        if (hookStack.getItem() instanceof HookItem) {
            hook = ((HookItem)hookStack.getItem()).getHookType();
        }
        return hook;
    }

    @Nonnull
    public static ItemStack getBait(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(1);
    }

    @Nonnull
    public static ItemStack getFishingLine(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(2);
    }

    @Nonnull
    public static ItemStack getBobber(@Nonnull ItemStack fishingRod) {
        return AquaFishingRodItem.getHandler(fishingRod).getStackInSlot(3);
    }

    public static ItemStackHandler getHandler(@Nonnull ItemStack fishingRod) {
        ItemStackHandler rodHandler = (ItemStackHandler)fishingRod.getCapability(Capabilities.ItemHandler.ITEM);
        if (rodHandler == null) {
            rodHandler = FishingRodEquipmentHandler.EMPTY;
        } else {
            ItemContainerContents rodInventory = (ItemContainerContents)fishingRod.get(AquaDataComponents.ROD_INVENTORY);
            if (!fishingRod.isEmpty() && rodInventory != null && fishingRod.has(AquaDataComponents.ROD_INVENTORY)) {
                for (int slot = 0; slot < rodInventory.getSlots(); ++slot) {
                    rodHandler.setStackInSlot(slot, rodInventory.getStackInSlot(slot));
                }
            }
        }
        return rodHandler;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag tooltipFlag) {
        Hook hook;
        if (this.getDamage(stack) >= this.getMaxDamage(stack)) {
            MutableComponent broken = Component.translatable((String)"aquaculture.fishing_rod.broken");
            tooltips.add((Component)broken.withStyle(broken.getStyle().withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)));
        }
        if ((hook = AquaFishingRodItem.getHookType(stack)) != Hooks.EMPTY) {
            MutableComponent hookColor = Component.translatable((String)hook.getItem().getDescriptionId());
            tooltips.add((Component)hookColor.withStyle(hookColor.getStyle().withColor(hook.getColor())));
        }
        super.appendHoverText(stack, tooltipContext, tooltips, tooltipFlag);
    }

    public static class FishingRodEquipmentHandler
    extends ItemStackHandler {
        public static final FishingRodEquipmentHandler EMPTY = new FishingRodEquipmentHandler(ItemStack.EMPTY);
        private final ItemStack stack;

        public FishingRodEquipmentHandler(ItemStack stack) {
            super(4);
            this.stack = stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof HookItem;
                case 1 -> stack.getItem() instanceof BaitItem;
                case 2 -> stack.is(AquacultureAPI.Tags.FISHING_LINE);
                case 3 -> stack.is(AquacultureAPI.Tags.BOBBER);
                default -> false;
            };
        }

        protected void onContentsChanged(int slot) {
            ItemContainerContents rodInventory = (ItemContainerContents)this.stack.get(AquaDataComponents.ROD_INVENTORY);
            if (!this.stack.isEmpty() && rodInventory != null && this.stack.has(AquaDataComponents.ROD_INVENTORY)) {
                NonNullList list = NonNullList.create();
                for (int i = 0; i < this.getSlots(); ++i) {
                    list.add((Object)this.getStackInSlot(i));
                }
                this.stack.set(AquaDataComponents.ROD_INVENTORY, (Object)ItemContainerContents.fromItems((List)list));
            }
        }
    }
}

