/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.deco;

import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MantelDecoBallBlock
extends HorizontalDecoBlock {
    protected static final VoxelShape MANTEL_WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)12.0, (double)16.0);
    protected static final VoxelShape MANTEL_EAST_AABB = Block.box((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape MANTEL_NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)9.0);
    protected static final VoxelShape MANTEL_SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)16.0);
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");

    public MantelDecoBallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        switch ((Direction)state.getValue((Property)DIRECTION)) {
            case SOUTH: {
                return MANTEL_SOUTH_AABB;
            }
            default: {
                return MANTEL_NORTH_AABB;
            }
            case WEST: {
                return MANTEL_WEST_AABB;
            }
            case EAST: 
        }
        return MANTEL_EAST_AABB;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == Items.FLINT_AND_STEEL && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, DIRECTION});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (state.getValue((Property)DIRECTION) == Direction.NORTH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)((float)pos.getX() + 0.78f), (double)((float)pos.getY() + 0.35f), (double)((float)pos.getZ() + 0.22f), 0.0, 0.0, 0.0);
            }
            if (state.getValue((Property)DIRECTION) == Direction.SOUTH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)((float)pos.getX() + 0.22f), (double)((float)pos.getY() + 0.35f), (double)((float)pos.getZ() + 0.78f), 0.0, 0.0, 0.0);
            }
            if (state.getValue((Property)DIRECTION) == Direction.WEST) {
                level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)((float)pos.getX() + 0.22f), (double)((float)pos.getY() + 0.35f), (double)((float)pos.getZ() + 0.22f), 0.0, 0.0, 0.0);
            }
            if (state.getValue((Property)DIRECTION) == Direction.EAST) {
                level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)((float)pos.getX() + 0.78f), (double)((float)pos.getY() + 0.35f), (double)((float)pos.getZ() + 0.78f), 0.0, 0.0, 0.0);
            }
        }
        super.animateTick(state, level, pos, random);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return 9;
        }
        return 0;
    }
}

