/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.datagen;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.data.LanguageProvider;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.fluids.XyFluidType;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class MachineLanguageDataGen
extends LanguageProvider
implements IConditionBuilder {
    private final String locale;

    public MachineLanguageDataGen(PackOutput output, String modId, String locale) {
        super(output, modId, locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        MachinesContent.Map.MappedContent.forEach(this::handleLang);
        if (this.locale.equals("en_us")) {
            this.addToolTip((IContent<?>)MachinesContent.Block.VoidContainer, "Black hole contained within! Can be used to void things.");
            this.addToolTip((IContent<?>)MachinesContent.Block.Extractor, "Extracts Items & Fluids out of the environment.");
            this.addToolTip((IContent<?>)MachinesContent.Block.Fabricator, "Crafts items automatically.");
            this.addToolTip((IContent<?>)MachinesContent.Block.WaterBlock, "Schr\u00f6dinger's water block!");
            this.addToolTip((IContent<?>)MachinesContent.Block.FluidVoid, "Stops fluids from flowing into adjacent blocks.");
            this.addToolTip((IContent<?>)MachinesContent.Block.LightField, "Prevents spawns in a cubed volume.", 0);
            this.addToolTip((IContent<?>)MachinesContent.Block.LightField, "Radius: %s", 1);
            this.addToolTip((IContent<?>)MachinesContent.Block.ItemSelector, "Creative item: ", 0);
            this.addToolTip((IContent<?>)MachinesContent.Block.ItemSelector, "Creates an unlimited amount of items!", 1);
            this.addToolTip((IContent<?>)MachinesContent.Block.FluidSelector, "Creative item: ", 0);
            this.addToolTip((IContent<?>)MachinesContent.Block.FluidSelector, "Creates an unlimited amount of a fluid!", 1);
            this.addToolTip((IContent<?>)MachinesContent.Block.HydroPump, "Automatically pumps water into a connected tank.", 0);
            this.addToolTip((IContent<?>)MachinesContent.Block.HydroPump, "Can be extracted from at a higher rate.", 1);
            this.addToolTip((IContent<?>)MachinesContent.Block.HydroPump, "Base Rate: %s per cycle.", 2);
            this.addToolTip((IContent<?>)MachinesContent.Block.HydroPump, "Waterlogged: %s per cycle", 3);
            this.addToolTip((IContent<?>)MachinesContent.Block.Collector, "Filterable & collects items before they become entities.");
            this.addToolTip((IContent<?>)MachinesContent.Item.FlareRod, "Consumes %s to place a light");
            this.addToolTip((IContent<?>)MachinesContent.Block.Stake, "How... did you inflate a wool balloon?");
            this.addToolTip((IContent<?>)MachinesContent.Block.SoarynBox, "It's not random if you put it there!");
            this.addToolTip((IContent<?>)MachinesContent.Block.NitrogenExtractor, "70%% seems excessive! Let's bring it down a bit.");
            this.addToolTip((IContent<?>)MachinesContent.Block.IgnitionPlate, "Fire on demand!");
            this.addToolTip((IContent<?>)MachinesContent.Block.Valve, "Allows the creation of tanks!", 0);
            this.addToolTip((IContent<?>)MachinesContent.Block.Valve, "Maximum size: %s", 1);
            this.addToolTip((IContent<?>)MachinesContent.Block.ItemIo, "The fill or drain side can be toggled with a wrench");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleLooting, "Provides Looting I to a modular weapon");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleFortune, "Provides Fortune I to a modular tool");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleAreaSurvey, "Unlocks a toggleable 3x3 mining ability");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleMiningMk1, "Improves mining speed");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleMiningMk2, "Considerably improves mining speed");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleMiningMk3, "Drastically improves mining speed");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleProspector, "Specializes a modular tool with Fortune VII");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleHunter, "Specializes a modular weapon for  Looting VII");
            this.addToolTip((IContent<?>)MachinesContent.Item.ModuleSnipe, "Utilizes the full extent of the modular tool to snipe its target");
            this.addToolTip((IContent<?>)MachinesContent.Block.Charger, "Charges items using external energy");
            this.addToolTip((IContent<?>)MachinesContent.Block.IlluminationField, "Illuminates a volume of area!");
            this.add("commands.xycraft.buildtank.toobig", "Too many blocks in the specified area (maximum %s, specified %s)");
            this.add("commands.xycraft.buildtank.failed", "No blocks placed");
            this.add("gui.xycraft_machines.tank", "Tank");
            this.add("gui.xycraft_machines.collector", "Collector");
            this.add("gui.xycraft_machines.fabricator.always_on", "Always On");
            this.add("gui.xycraft_machines.fabricator.high_signal", "High Signal");
            this.add("gui.xycraft_machines.fabricator.pulse", "Pulse");
            this.add("gui.xycraft_machines.tank.empty", "Empty");
            this.add("gui.xycraft_machines.tank.capacity", "Capacity");
            this.add("itemGroup.xycraft_machines_tab", "XyCraft Machines");
            this.add("itemGroup.xycraft_machines_fluids", "XyCraft Foils");
            this.add("jei.xycraft.recipe.extractor", "Extractor");
            this.add("jei.xycraft.recipe.extractor.directions", "Orientations");
            this.add("jei.xycraft.recipe.general.time", "Time");
            this.add("jei.xycraft.recipe.general.seconds", "seconds");
            this.add("jei.xycraft.recipe.crusher.tooltip", "%s%% chance");
            this.add("jei.xycraft.recipe.crusher", "Crusher");
            this.add("jei.xycraft.recipe.squasher", "Squasher");
            this.add("jei.xycraft.recipe.refinery", "Refinery");
            this.add("jei.xycraft.recipe.blender", "Blender");
            this.add("jei.xycraft.recipe.centrifuge", "Centrifuge");
            this.add("xycraft.emi.category.extractor", "Extractor");
            this.add("attribute.xycraft.hover_flight", "Hover Flight");
            this.add("sound.xycraft_machines.subtitle.soaryn_box_deposit", "Woop!");
            this.add("sound.xycraft_machines.subtitle.balloon_pop", "Balloon Popped!");
            this.add("sound.xycraft_machines.subtitle.balloon_inflate", "Inflating Balloon");
            IRecipeBuilder.RecipeNames.forEach((arg_0, arg_1) -> ((MachineLanguageDataGen)this).add(arg_0, arg_1));
            this.add("config.jade.plugin_xycraft", "XyCraft");
            this.add("config.jade.plugin_xycraft.tank_component", "Tank Info");
            this.add("config.jade.plugin_xycraft.extractor_component", "Extractor Info");
        }
    }

    private void addToolTip(IContent<?> content, String tooltip) {
        if (content instanceof BlockContent) {
            BlockContent wrapper = (BlockContent)content;
            this.add(wrapper.block().getDescriptionId() + ".tooltip", tooltip);
        } else if (content instanceof ItemContent) {
            ItemContent wrapper = (ItemContent)content;
            this.add(wrapper.item().getDescriptionId() + ".tooltip", tooltip);
        } else if (content instanceof FluidContent) {
            FluidContent wrapper = (FluidContent)content;
            this.add(((XyFluidType)wrapper.Type.get()).getDescriptionId() + ".tooltip", tooltip);
        }
    }

    private void addToolTip(IContent<?> content, String tooltip, int i) {
        IContent<?> iContent = content;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockContent.class, ItemContent.class, FluidContent.class}, iContent, n)) {
            case 0: {
                BlockContent wrapper = (BlockContent)iContent;
                this.add(wrapper.block().getDescriptionId() + ".tooltip." + i, tooltip);
                break;
            }
            case 1: {
                ItemContent wrapper = (ItemContent)iContent;
                this.add(wrapper.item().getDescriptionId() + ".tooltip." + i, tooltip);
                break;
            }
            case 2: {
                FluidContent wrapper = (FluidContent)iContent;
                this.add(((XyFluidType)wrapper.Type.get()).getDescriptionId() + ".tooltip." + i, tooltip);
                break;
            }
        }
    }

    private void handleLang(IContent<?> content) {
        String name = content.getLocalizedName(this.locale);
        if (name == null) {
            return;
        }
        IContent<?> iContent = content;
        Objects.requireNonNull(iContent);
        IContent<?> iContent2 = iContent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockContent.class, ItemContent.class, FluidContent.class}, iContent2, n)) {
            case 0: {
                BlockContent wrapper = (BlockContent)iContent2;
                this.add(wrapper.block(), name);
                break;
            }
            case 1: {
                ItemContent wrapper = (ItemContent)iContent2;
                this.add(wrapper.item(), name);
                break;
            }
            case 2: {
                FluidContent wrapper = (FluidContent)iContent2;
                this.add(((XyFluidType)wrapper.Type.get()).getDescriptionId(), name);
                break;
            }
        }
    }
}

