/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.registries;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.recipes.buildings.BuildingsRecipe;
import tv.soaryn.xycraft.machines.content.recipes.energy.isolator.IsolatorRecipe;
import tv.soaryn.xycraft.machines.content.recipes.fluid.FluidTankDrainRecipe;
import tv.soaryn.xycraft.machines.content.recipes.fluid.FluidTankFillRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.arkmelter.ArkMelterRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.atmospheric.AtmosphericVacuumRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.blender.BlenderRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.centrifuge.CentrifugeRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.crusher.CrusherRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.cryochamber.CryoChamberRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.oretap.OreTapRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.refinery.RefineryRecipe;
import tv.soaryn.xycraft.machines.content.recipes.producers.squasher.SquasherRecipe;
import tv.soaryn.xycraft.machines.content.recipes.solidifier.SolidifierRecipe;

public interface MachinesRecipeTypes {
    public static final IRegister Instance = new IRegister(){

        public void register(IEventBus bus) {
            RecipeTypeMap.register(bus);
            SerializerMap.register(bus);
        }
    };
    public static final DeferredRegister<RecipeType<?>> RecipeTypeMap = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"xycraft_machines");
    public static final DeferredRegister<RecipeSerializer<?>> SerializerMap = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"xycraft_machines");
    public static final RecipeContent<SolidifierRecipe> Solidifier = MachinesRecipeTypes.create("solidifier", SolidifierRecipe::register);
    public static final RecipeContent<CrusherRecipe> Crusher = MachinesRecipeTypes.create("crusher", CrusherRecipe::register);
    public static final RecipeContent<SquasherRecipe> Squasher = MachinesRecipeTypes.create("squasher", SquasherRecipe::register);
    public static final RecipeContent<RefineryRecipe> Refinery = MachinesRecipeTypes.create("refinery", RefineryRecipe::register);
    public static final RecipeContent<CentrifugeRecipe> Centrifuge = MachinesRecipeTypes.create("centrifuge", CentrifugeRecipe::register);
    public static final RecipeContent<BlenderRecipe> Blender = MachinesRecipeTypes.create("blender", BlenderRecipe::register);
    public static final RecipeContent<ExtractorRecipe> Extractor = MachinesRecipeTypes.create("extractor", ExtractorRecipe::register);
    public static final RecipeContent<CryoChamberRecipe> CryoChamber = MachinesRecipeTypes.create("cry_chamber", CryoChamberRecipe::register);
    public static final RecipeContent<ArkMelterRecipe> ArkMelter = MachinesRecipeTypes.create("ark_melter", ArkMelterRecipe::register);
    public static final RecipeContent<OreTapRecipe> OreTap = MachinesRecipeTypes.create("ore_tap", OreTapRecipe::register);
    public static final RecipeContent<AtmosphericVacuumRecipe> AtmosphericVacuum = MachinesRecipeTypes.create("atmospheric_vacuum", AtmosphericVacuumRecipe::register);
    public static final RecipeContent<BuildingsRecipe> Buildings = MachinesRecipeTypes.create("buildings", BuildingsRecipe::register);
    public static final RecipeContent<FluidTankFillRecipe> FluidTankFill = MachinesRecipeTypes.create("fluid_tank_fill", FluidTankFillRecipe::register);
    public static final RecipeContent<FluidTankDrainRecipe> FluidTankDrain = MachinesRecipeTypes.create("fluid_tank_drain", FluidTankDrainRecipe::register);
    public static final RecipeContent<IsolatorRecipe> Isolator = MachinesRecipeTypes.create("isolator", IsolatorRecipe::register);

    public static <S extends Recipe<?>> RecipeContent<S> create(String id, Supplier<RecipeSerializer<S>> serializerSupplier) {
        return new RecipeContent(MachinesRecipeTypes.registerSerializer(id, serializerSupplier), MachinesRecipeTypes.registerRecipeType(id));
    }

    public static <S extends Recipe<?>> DeferredHolder<RecipeSerializer<?>, RecipeSerializer<S>> registerSerializer(String id, Supplier<RecipeSerializer<S>> serializer) {
        return SerializerMap.register(id, serializer);
    }

    public static <S extends Recipe<?>> DeferredHolder<RecipeType<?>, RecipeType<S>> registerRecipeType(String id) {
        return RecipeTypeMap.register(id, () -> RecipeType.simple((ResourceLocation)XyMachines.resource(id)));
    }
}

