/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.registries;

import java.util.function.BooleanSupplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.core.content.FluidContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.blocks.CommonBlockProperties;
import tv.soaryn.xycraft.core.content.builder.BlockContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.ContentMap;
import tv.soaryn.xycraft.core.content.builder.ItemContentRegistrationBuilder;
import tv.soaryn.xycraft.core.content.builder.MCLocale;
import tv.soaryn.xycraft.core.datagen.BlockModelType;
import tv.soaryn.xycraft.core.utils.PrimitiveUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.compat.ExternalMod;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.MachinesCreativeTab;
import tv.soaryn.xycraft.machines.content.MachinesFluidCreativeTab;
import tv.soaryn.xycraft.machines.content.blocks.ChargerBlock;
import tv.soaryn.xycraft.machines.content.blocks.CoagulatedLavaBlock;
import tv.soaryn.xycraft.machines.content.blocks.CoagulatedWaterBlock;
import tv.soaryn.xycraft.machines.content.blocks.FlareBlock;
import tv.soaryn.xycraft.machines.content.blocks.HoverPylonBlock;
import tv.soaryn.xycraft.machines.content.blocks.IlluminationFieldBlock;
import tv.soaryn.xycraft.machines.content.blocks.NitrogenExtractorBlock;
import tv.soaryn.xycraft.machines.content.blocks.PowerCoreBlock;
import tv.soaryn.xycraft.machines.content.blocks.ResinBlock;
import tv.soaryn.xycraft.machines.content.blocks.SoarynBoxBlock;
import tv.soaryn.xycraft.machines.content.blocks.balloonstake.BalloonStakeBlock;
import tv.soaryn.xycraft.machines.content.blocks.balloonstake.BalloonStakeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.basic.FluidVoidBlock;
import tv.soaryn.xycraft.machines.content.blocks.basic.IgnitionPlateBlock;
import tv.soaryn.xycraft.machines.content.blocks.basic.LightFieldBlock;
import tv.soaryn.xycraft.machines.content.blocks.basic.PlanterBlock;
import tv.soaryn.xycraft.machines.content.blocks.basic.WaterBlock;
import tv.soaryn.xycraft.machines.content.blocks.buffer.BufferBlock;
import tv.soaryn.xycraft.machines.content.blocks.collector.CollectorBlock;
import tv.soaryn.xycraft.machines.content.blocks.collector.CollectorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.engineering.EngineeringTableBlock;
import tv.soaryn.xycraft.machines.content.blocks.extractor.ExtractorBlock;
import tv.soaryn.xycraft.machines.content.blocks.extractor.ExtractorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.fabricator.FabricatorBlock;
import tv.soaryn.xycraft.machines.content.blocks.hydropump.HydroPumpBlock;
import tv.soaryn.xycraft.machines.content.blocks.isolator.IsolatorBlock;
import tv.soaryn.xycraft.machines.content.blocks.multiblock.ItemIOBlock;
import tv.soaryn.xycraft.machines.content.blocks.multiblock.ValveBlock;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlockItem;
import tv.soaryn.xycraft.machines.content.blocks.pipe.objects.EnergyPipeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.pipe.objects.FluidPipeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.proto.ProtoBlock;
import tv.soaryn.xycraft.machines.content.blocks.selectors.FluidSelectorBlock;
import tv.soaryn.xycraft.machines.content.blocks.selectors.ItemSelectorBlock;
import tv.soaryn.xycraft.machines.content.blocks.voidcontainer.VoidContainerBlock;
import tv.soaryn.xycraft.machines.content.items.FoilItem;
import tv.soaryn.xycraft.machines.content.items.HoverPackItem;
import tv.soaryn.xycraft.machines.content.items.TabletItem;
import tv.soaryn.xycraft.machines.content.items.VisorItem;
import tv.soaryn.xycraft.machines.content.items.XynergyStorageItem;
import tv.soaryn.xycraft.machines.content.items.modular.proto.ModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular206.FlareRodItem;
import tv.soaryn.xycraft.machines.content.items.modular206.GauntletItemNew;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public final class MachinesContent {
    public static final ContentMap Map = ContentMap.map((String)"xycraft_machines").withTab(MachinesCreativeTab::new);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> FluidTab = Map.createTab("fluids", MachinesFluidCreativeTab::new);

    @NotNull
    private static BooleanSupplier requiresAe2AndCreate() {
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[2];
        booleanSupplierArray[0] = () -> ((ExternalMod)CompatContent.AE2.Mod).isLoaded();
        booleanSupplierArray[1] = () -> ((ExternalMod)CompatContent.Create.Mod).isLoaded();
        return PrimitiveUtils.Suppliers.Bool.aggregate((BooleanSupplier[])booleanSupplierArray);
    }

    public static Item.Properties experimental(Item.Properties props) {
        return props.requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get());
    }

    static {
        Map.with(new Object[]{Block.INSTANCE, Item.INSTANCE, Fluid.INSTANCE});
    }

    public static interface Block {
        public static final Block INSTANCE = new Block(){};
        public static final BlockContent MachineBase = Map.block("Machine Base").withModelType(BlockModelType.Connected).build();
        public static final BlockContent ResinBlock = Map.block("Block of Resin", ResinBlock::new).withModelType(BlockModelType.Custom).build();
        public static final BlockContent WaterBlock = Map.block("Water Block", WaterBlock::new).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent Planter = Map.block("Accelerated Planter", PlanterBlock::new).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent IgnitionPlate = Map.block("Ignition Plate", IgnitionPlateBlock::new).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent FluidVoid = Map.block("Fluid Void", FluidVoidBlock::new).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent LightField = Map.block("Light Field", LightFieldBlock::new).withBlockProperties(CommonBlockProperties::KiviProperties).withModelType(BlockModelType.Cloud).build();
        public static final BlockContent Extractor = Map.block("Extractor", ExtractorBlock::new).withEntity(ExtractorBlockEntity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent VoidContainer = Map.block("Void Container", VoidContainerBlock::new).withEntity(VoidContainerBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent Fabricator = Map.block("Fabricator", FabricatorBlock::new).withEntity(FabricatorBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build();
        public static final BlockContent SoarynBox = Map.block("Soaryn Box", SoarynBoxBlock::new).withEntity(SoarynBoxBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent Charger = Map.block("Charger", ChargerBlock::new).withEntity(ChargerBlock.Entity::new).withBlockProperties(() -> CommonBlockProperties.MachineProperties().requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get())).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent Stake = Map.block("Balloon on a Stick", BalloonStakeBlock::new).withEntity(BalloonStakeBlockEntity::new).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent Valve = Map.block("Valve", ValveBlock::new).withEntity(ValveBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent ItemIo = Map.block("Item IO", ItemIOBlock::new).withEntity(ItemIOBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent HydroPump = Map.block("Hydro Pump", HydroPumpBlock::new).withEntity(HydroPumpBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent IlluminationField = Map.block("Illumination Field", IlluminationFieldBlock::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Cloud).build();
        public static final BlockContent HoverPylon = Map.block("Hover Pylon", HoverPylonBlock::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent Collector = Map.block("Collector", CollectorBlock::new).withEntity(CollectorBlockEntity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent ItemSelector = Map.block("Item Selector", ItemSelectorBlock::new).withEntity(ItemSelectorBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent FluidSelector = Map.block("Fluid Selector", FluidSelectorBlock::new).withEntity(FluidSelectorBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent NitrogenExtractor = Map.block("Nitrogen Extractor", NitrogenExtractorBlock::new).withEntity(NitrogenExtractorBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent EngineeringTable = Map.block("Engineering Table", EngineeringTableBlock::new).withEntity(EngineeringTableBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).build().withCustomItemModel();
        public static final BlockContent Flare = Map.block("Flare", FlareBlock::new).withModelType(BlockModelType.Custom).hidden().build().withCustomBreakRule();
        public static final BlockContent PowerCore = Map.block("Power Core", PowerCoreBlock::new).withModelType(BlockModelType.Custom).build().withCustomBreakRule();
        public static final BlockContent Proto = Map.block("ProtoBlock", ProtoBlock::new).withEntity(ProtoBlock.Entity::new).build();
        public static final BlockContent PipeFluid = ((BlockContentRegistrationBuilder)Map.block("Fluid Pipe", FluidPipeBlockEntity::block).withItem(PipeBlockItem::fluid).withEntity(FluidPipeBlockEntity::new).withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Custom).withName("Flud Xype", new MCLocale[]{MCLocale.LOL_CAT})).build();
        public static final BlockContent PipeEnergy = ((BlockContentRegistrationBuilder)Map.block("Energy Pipe", EnergyPipeBlockEntity::block).withItem(PipeBlockItem::energy).withEntity(EnergyPipeBlockEntity::new).withBlockProperties(CommonBlockProperties::AluminumProperties).withModelType(BlockModelType.Custom).withName("Zippy Zappy Xype", new MCLocale[]{MCLocale.LOL_CAT})).build();
        public static final BlockContent Buffer = ((BlockContentRegistrationBuilder)Map.block("Buffer", BufferBlock::new).withEntity(BufferBlock.Entity::new).withBlockProperties(CommonBlockProperties::MachineProperties).withModelType(BlockModelType.Custom).withName("Buuufer", new MCLocale[]{MCLocale.LOL_CAT})).build();
        public static final BlockContent Isolator = Map.block("Isolator", IsolatorBlock::new).withEntity(IsolatorBlock.Entity::new).withBlockProperties(() -> CommonBlockProperties.MachineProperties().requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get())).withModelType(BlockModelType.Custom).build();
        public static final BlockContent HardenedGravel = Map.block("Hardened Gravel").withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAVEL).requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get())).inTab(WorldContent.Map).build().withCustomBreakRule();
        public static final BlockContent HardenedSand = Map.block("Hardened Sand").withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get())).inTab(WorldContent.Map).build().withCustomBreakRule();
        public static final BlockContent HardenedRedSand = Map.block("Hardened Red Sand").withBlockProperties(() -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_SAND).requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get())).inTab(WorldContent.Map).build().withCustomBreakRule();
        public static final BlockContent CoagulatedWater = Map.block("Coagulated Water", CoagulatedWaterBlock::new).withModelType(BlockModelType.Custom).build().withCustomBreakRule().withDynamicColor();
        public static final BlockContent CoagulatedLava = Map.block("Coagulated Lava", CoagulatedLavaBlock::new).withModelType(BlockModelType.Custom).build().withCustomBreakRule().withColor(-2923498);
    }

    public static interface Item {
        public static final Item INSTANCE = new Item(){};
        public static final ItemContent PortFluid = Map.item("Fluid Port").build().withCustomItemModel();
        public static final ItemContent PortItem = Map.item("Item Port").build().withCustomItemModel();
        public static final ItemContent PortEnergy = Map.item("Energy Port").build().withCustomItemModel();
        public static final ItemContent FlareRod = Map.item("Flare Rod", FlareRodItem::new).build().withCustomItemModel();
        public static final ItemContent IronSheet = Map.item("Iron Sheet").withProperties(MachinesContent::experimental).build();
        public static final ItemContent CopperSheet = Map.item("Copper Sheet").withProperties(MachinesContent::experimental).build();
        public static final ItemContent GoldSheet = Map.item("Gold Sheet").withProperties(MachinesContent::experimental).build();
        public static final ItemContent AluminumSheet = ((ItemContentRegistrationBuilder)Map.item("Aluminum Sheet").withName("Aluminium Sheet", MCLocale.OFF_BRAND_ENGLISH)).withProperties(MachinesContent::experimental).build();
        public static final ItemContent ResinBall = Map.item("Resin Ball").build();
        public static final ItemContent Gauntlet = Map.item("Gauntlet", GauntletItemNew::basic).build().withCustomItemModel();
        public static final ItemContent GauntletImproved = Map.item("Improved Gauntlet", GauntletItemNew::improved).build().withCustomItemModel();
        public static final ItemContent GauntletPerfected = Map.item("Perfected Gauntlet", GauntletItemNew::perfected).build().withCustomItemModel();
        public static final ItemContent DurableCell = Map.item("Durable Cell", properties -> new XynergyStorageItem(XyMachines.ServerConfig.DurableCellCapacity)).inTab(null).build();
        public static final ItemContent CreativeCell = Map.item("Creative Cell").withProperties(properties -> properties.requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true)).build();
        public static final ItemContent HoverPack = Map.item("Hover Pack", HoverPackItem::new).build().withCustomItemModel();
        public static final ItemContent Scanner = Map.item("Visor", VisorItem::new).build().withTempModel();
        public static final ItemContent Tablet = Map.item("Tablet", TabletItem::new).build().withCustomItemModel();
        public static final ItemContent Foil = Map.item("Foil", FoilItem::new).build().withCustomItemModel();
        public static final ItemContent ModuleSilkTouch = Map.item("Silk Touch Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleFortune = Map.item("Fortune Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleEfficiency = Map.item("Energy Efficiency Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleAreaSurvey = Map.item("Area Survey Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleVeinLogic = Map.item("Vein Logic Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleTreeFocus = Map.item("Tree Focus Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleMiningMk1 = Map.item("Mining Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleMiningMk2 = Map.item("Overclocked Mining Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleMiningMk3 = Map.item("AI Mining Module", ModuleItem::legendary).build().withModelPath("upgrade_legendary");
        public static final ItemContent ModuleEnvironmental = Map.item("Environmental Processing Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleAutoSmelt = Map.item("Vulcanization Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleTunneler = Map.item("Tunneler Specialization Module", ModuleItem::specialization).build().withModelPath("upgrade_specialization");
        public static final ItemContent ModuleProspector = Map.item("Prospector Specialization Module", ModuleItem::specialization).build().withModelPath("upgrade_specialization");
        public static final ItemContent ModuleArchonAffinity = Map.item("Archon Affinity Specialization Module", ModuleItem::specialization).build().withModelPath("upgrade_specialization");
        public static final ItemContent ModuleBastille = Map.item("Bastille Specialization Module", ModuleItem::specialization).build().withModelPath("upgrade_specialization");
        public static final ItemContent ModuleProtection = Map.item("Protection Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleMovementSpeed = Map.item("Movement Speed Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleTotemConsumer = Map.item("Totemic Death Specialization Module", ModuleItem::specialization).build().withModelPath("upgrade_specialization");
        public static final ItemContent ModuleStepAssist = Map.item("Step Assist Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleLooting = Map.item("Looting Module", ModuleItem::base).build().withModelPath("upgrade_base");
        public static final ItemContent ModuleHunter = Map.item("Hunter Specialization Module", ModuleItem::specialization).build().withModelPath("upgrade_specialization");
        public static final ItemContent ModuleSnipe = Map.item("Mythical Snipe Module", ModuleItem::mythic).build().withModelPath("upgrade_mythic");
        public static final ItemContent IncompleteProcessor = ((ItemContentRegistrationBuilder)Map.item("Incomplete Processor").requires(MachinesContent.requiresAe2AndCreate())).build();
        public static final ItemContent Slag = Map.item("Slag").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Steel = Map.item("Steel").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Alloy = Map.item("Alloy").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Sulfur = Map.item("Sulfur").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent PolymerResin = Map.item("Polymer Resin").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Flour = Map.item("Flour").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Dough = Map.item("Dough").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent FlatterDough = Map.item("Flatter Dough").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Curds = Map.item("Curds").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Whey = Map.item("Whey").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Cheese = Map.item("Cheese").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Noodles = Map.item("Noodles").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Hushpuppies = Map.item("Hushpuppies").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent Pasta = Map.item("Pasta").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent CakeBase = Map.item("Cake Base").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent KilogramCake = Map.item("Kilogram Cake").withProperties(MachinesContent::experimental).build().withTempModel();
        public static final ItemContent IceCream = Map.item("Ice Cream").withProperties(MachinesContent::experimental).build().withTempModel();
    }

    public static interface Fluid {
        public static final Fluid INSTANCE = new Fluid(){};
        public static final FluidContent OreSlurry = Map.fluid("Ore Slurry").build();
        public static final FluidContent RedstoneSlurry = Map.fluid("Redstone Slurry").build();
        public static final FluidContent Nitrogen = Map.fluid("Nitrogen Gas").build();
        public static final FluidContent Steam = Map.fluid("Steam").build();
        public static final FluidContent Resin = Map.fluid("Bio Resin").build();
        public static final FluidContent SulfuricAcid = Map.fluid("Sulfuric Acid").build();
        public static final FluidContent LiquidNitrogen = Map.fluid("Liquid Nitrogen").build();
        public static final FluidContent LiquidDye = Map.fluid("Liquid Dye").build();
        public static final FluidContent Batter = Map.fluid("Batter").build();
        public static final FluidContent CookingOil = Map.fluid("Cooking Oil").build();
        public static final FluidContent Coolant = Map.fluid("Coolant").build();
        public static final FluidContent CrudeOil = Map.fluid("Crude Oil").build();
        public static final FluidContent CryoCoolant = Map.fluid("Cryo Coolant").build();
        public static final FluidContent HeavyOilResidue = Map.fluid("Heavy Oil Residue").build();
        public static final FluidContent SaltWater = Map.fluid("Salt Water").build();
        public static final FluidContent ShakenMilk = Map.fluid("Shaken Milk").build();
        public static final FluidContent SuperHeatedOre = Map.fluid("Super Heated Ore").build();
        public static final FluidContent Fuel = Map.fluid("Fuel").build();
        public static final FluidContent BioFuel = Map.fluid("Bio Fuel").build();
    }
}

