/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.extractor;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.core.utils.rules.BlockRule;
import tv.soaryn.xycraft.core.utils.rules.BlockTagRule;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;

public class ExtractorRecipeBuilder
implements IRecipeBuilder.WithItem.Output<ExtractorRecipeBuilder, ExtractorRecipe> {
    private Either<FluidStack, ItemStack> _output = null;
    private EnumSet<Direction> _validDirections = EnumSet.allOf(Direction.class);
    private IRule _target;
    private IRule _catalyst;
    private FluidType _waterloggedFluid;
    private final ArrayList<IRule> _adjacentRules = new ArrayList();
    private long _ticks = 10L;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();
    private boolean _hidden = false;

    public static ExtractorRecipeBuilder create() {
        return new ExtractorRecipeBuilder();
    }

    public ExtractorRecipeBuilder output(ItemStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Refinery Recipe!");
        }
        this._output = Either.right((Object)outputIngredient);
        return this;
    }

    public ExtractorRecipeBuilder output(FluidStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Refinery Recipe!");
        }
        this._output = Either.left((Object)outputIngredient);
        return this;
    }

    public ExtractorRecipeBuilder validDirections(EnumSet<Direction> directions) {
        this._validDirections = directions;
        return this;
    }

    public ExtractorRecipeBuilder target(IRule test) {
        this._target = test;
        return this;
    }

    public ExtractorRecipeBuilder target(Block block) {
        this._target = new BlockRule(block);
        return this;
    }

    public ExtractorRecipeBuilder target(TagKey<Block> tag) {
        this._target = new BlockTagRule(tag);
        return this;
    }

    public ExtractorRecipeBuilder catalyst(IRule test) {
        this._catalyst = test;
        return this;
    }

    public ExtractorRecipeBuilder catalyst(Block block) {
        this._catalyst = new BlockRule(block);
        return this;
    }

    public ExtractorRecipeBuilder catalyst(TagKey<Block> tag) {
        this._catalyst = new BlockTagRule(tag);
        return this;
    }

    public ExtractorRecipeBuilder adjacentRule(BlockContent block) {
        return this.adjacentRule(block.block());
    }

    public ExtractorRecipeBuilder adjacentRule(Block block) {
        return this.adjacentRule((IRule)new BlockRule(block));
    }

    public ExtractorRecipeBuilder adjacentRule(IRule tests) {
        this._adjacentRules.add(tests);
        return this;
    }

    public ExtractorRecipeBuilder fluidLoggable(FluidType type) {
        this._waterloggedFluid = type;
        return this;
    }

    public ExtractorRecipeBuilder waterLogged() {
        this._waterloggedFluid = (FluidType)NeoForgeMod.WATER_TYPE.value();
        return this;
    }

    @NotNull
    public ExtractorRecipeBuilder ticks(long ticks) {
        this._ticks = ticks;
        return this;
    }

    @NotNull
    public ExtractorRecipeBuilder hidden() {
        this._hidden = true;
        return this;
    }

    @NotNull
    public ExtractorRecipe makeRecipe() {
        return new ExtractorRecipe(this._output, this._target, this._validDirections, this._adjacentRules, Optional.ofNullable(this._catalyst), Optional.ofNullable(this._waterloggedFluid), this._ticks, this._hidden);
    }

    public void ensureValid(String id) {
        if (this._target == null) {
            throw new RuntimeException("Target is null in Extractor recipe - " + id);
        }
        if (this._output == null) {
            throw new RuntimeException("No result in Extractor recipe - " + id);
        }
        if (this._validDirections.isEmpty()) {
            throw new RuntimeException("No valid direction in Extractor Recipe - " + id);
        }
        if (this._adjacentRules.size() > 4) {
            throw new IllegalArgumentException("Too many rules in Extractor Recipe -" + id);
        }
    }
}

