/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.selectors;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.FluidSelectorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.selectors.BaseSelectorBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class FluidSelectorBlock
extends BaseSelectorBlock
implements ITooltipProvider {
    public FluidSelectorBlock(BlockBehaviour.Properties properties) {
        super(properties, Entity::new);
        this.registerSystem(MachinesSystems.FluidSelector);
        this.registerHasCapability();
    }

    public void appendToolTip(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)this.getToolTipKey(0)).withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)this.getToolTipKey(1)).withStyle(ChatFormatting.GRAY)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        FluidStack fluidInStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluidInStack.isEmpty()) {
            fluidInStack.setAmount(((Integer)XyMachines.ServerConfig.SelectorFluidAmount.get()).intValue());
        }
        FluidSelectorAttachment data = (FluidSelectorAttachment)blockEntity.getData(MachinesAttachments.FluidSelectorData);
        if (data.FluidHandler.setSelected(fluidInStack)) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
            level.setBlockAndUpdate(pos, state);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        FluidSelectorAttachment data = (FluidSelectorAttachment)blockEntity.getData(MachinesAttachments.FluidSelectorData);
        if (!data.FluidHandler.getSelected().isEmpty() && data.FluidHandler.setSelected(FluidStack.EMPTY)) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
            level.setBlockAndUpdate(pos, state);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return level.isClientSide() ? InteractionResult.CONSUME_PARTIAL : InteractionResult.CONSUME;
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (blockEntity == null || FluidSelectorBlock.isInaccessibleSide((Direction)context, (BlockState)state)) {
                return null;
            }
            FluidSelectorAttachment data = (FluidSelectorAttachment)blockEntity.getData(MachinesAttachments.FluidSelectorData);
            return data.FluidHandler;
        }, new Block[]{MachinesContent.Block.FluidSelector.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.FluidSelector.block()});
    }

    public static class Entity
    extends XyBlockEntity {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.FluidSelector.entity(), pos, state, new AttachmentType[]{MachinesAttachments.FluidSelectorData.get()});
        }
    }
}

