/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeNet;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.api.content.pipes.examples.EnergyPipeGraph;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilityCacheAttachment;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.machines.content.multiblock.pipes.FluidPipeGraph;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class PipeBlockItem<TGraph extends PipeGraph<T, TGraph>, T>
extends XyBlockItem {
    private final BlockCapability<T, Direction> _cap;
    private final Supplier<AttachmentType<PipeNetwork<TGraph, T>>> _pipeNetwork;

    public static PipeBlockItem<FluidPipeGraph, IFluidHandler> fluid(Block block) {
        return new PipeBlockItem<FluidPipeGraph, IFluidHandler>(block, Capabilities.FluidHandler.BLOCK, MachinesAttachments.FluidPipeNetwork);
    }

    public static PipeBlockItem<EnergyPipeGraph, IEnergyStorage> energy(Block block) {
        return new PipeBlockItem<EnergyPipeGraph, IEnergyStorage>(block, Capabilities.EnergyStorage.BLOCK, MachinesAttachments.EnergyPipeNetwork);
    }

    public PipeBlockItem(Block block, BlockCapability<T, Direction> cap, Supplier<AttachmentType<PipeNetwork<TGraph, T>>> pipeNetwork) {
        super(block, new Item.Properties());
        this._cap = cap;
        this._pipeNetwork = pipeNetwork;
    }

    protected boolean placeBlock(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        if (!super.placeBlock(context, state)) {
            return false;
        }
        Level levelObj = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction clickedDirection = context.getClickedFace().getOpposite();
        if (!(levelObj instanceof ServerLevel)) {
            return true;
        }
        ServerLevel level = (ServerLevel)levelObj;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return true;
        }
        IPipeConnection pipeConnections = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, pos, null);
        CapabilityCacheAttachment lookup = (CapabilityCacheAttachment)blockEntity.getData(MachinesAttachments.AdjacentPipeCapabilityCache);
        IPipeConnection clickedConnections = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, pos.relative(clickedDirection), null);
        if (pipeConnections == null) {
            return true;
        }
        if (ModifierKey.of((Player)context.getPlayer())) {
            this.clickedSideWithModifier(level, clickedDirection, pos, pipeConnections, (IPipeConnection)lookup.getCap(clickedDirection), pos.relative(clickedDirection));
            PipeGraph lastGraph = PipeNet.getGraph((ServerLevel)level, (BlockPos)pos.relative(clickedDirection), this._pipeNetwork);
            for (Direction side : Direction.values()) {
                BlockPos otherPos = pos.relative(side);
                IPipeConnection adjConnections = (IPipeConnection)lookup.getCap(side);
                if (side == clickedDirection) continue;
                if (adjConnections != null && adjConnections.getHandledCap() == pipeConnections.getHandledCap() && pipeConnections.canConnect(side.getOpposite())) {
                    PipeGraph currentGraph = PipeNet.getGraph((ServerLevel)level, (BlockPos)otherPos, this._pipeNetwork);
                    if (currentGraph != null) {
                        if (!currentGraph.canMerge(lastGraph)) {
                            pipeConnections.setSide(side, PipeConnectionType.None);
                            continue;
                        }
                        lastGraph = currentGraph;
                    }
                    PipeConnectionType logic = switch (adjConnections.getLogic(side.getOpposite())) {
                        default -> throw new MatchException(null, null);
                        case PipeConnectionType.Extract, PipeConnectionType.Insert -> PipeConnectionType.Transfer;
                        case PipeConnectionType.None, PipeConnectionType.Transfer -> PipeConnectionType.None;
                    };
                    pipeConnections.setSide(side, logic);
                    continue;
                }
                pipeConnections.setSide(side, PipeConnectionType.None);
            }
        } else {
            PipeGraph lastGraph = PipeNet.getGraph((ServerLevel)level, (BlockPos)pos.relative(clickedDirection), this._pipeNetwork);
            lastGraph = this.handleClickedFace(level, clickedDirection, pos, (CapabilityCacheAttachment<IPipeConnection>)lookup, pipeConnections, lastGraph);
            for (Direction side : Direction.values()) {
                if (side == clickedDirection) continue;
                lastGraph = this.handleClickedFace(level, side, pos, (CapabilityCacheAttachment<IPipeConnection>)lookup, pipeConnections, lastGraph);
            }
        }
        return true;
    }

    private TGraph handleClickedFace(ServerLevel level, Direction side, BlockPos pos, CapabilityCacheAttachment<IPipeConnection> lookup, IPipeConnection pipeConnections, TGraph lastGraph) {
        PipeConnectionType adjLogic;
        BlockPos otherPos = pos.relative(side);
        IPipeConnection adjConnections = (IPipeConnection)lookup.getCap(side);
        if (!pipeConnections.canConnect(side)) {
            return lastGraph;
        }
        if (!(adjConnections == null || adjConnections.canConnect(side.getOpposite()) && pipeConnections.getHandledCap() == adjConnections.getHandledCap())) {
            return lastGraph;
        }
        if (adjConnections == null && level.getCapability(this._cap, otherPos, (Object)side.getOpposite()) == null) {
            return lastGraph;
        }
        PipeGraph currentGraph = PipeNet.getGraph((ServerLevel)level, (BlockPos)otherPos, this._pipeNetwork);
        boolean canMerge = true;
        if (currentGraph != null) {
            canMerge = currentGraph.canMerge(lastGraph);
            if (!canMerge) {
                pipeConnections.setSide(side, PipeConnectionType.None);
                return lastGraph;
            }
            lastGraph = currentGraph;
        }
        pipeConnections.setSide(side, PipeConnectionType.Transfer);
        if (adjConnections != null && (adjLogic = adjConnections.getLogic(side.getOpposite())) == PipeConnectionType.None) {
            adjConnections.setSide(side.getOpposite(), PipeConnectionType.Transfer);
        }
        return lastGraph;
    }

    private void clickedSideWithModifier(ServerLevel level, Direction side, BlockPos pos, IPipeConnection pipeConnections, IPipeConnection adjConnections, BlockPos otherPos) {
        PipeConnectionType logic = this.canConnect((Level)level, pos, pipeConnections, adjConnections, side);
        pipeConnections.setSide(side, logic);
        if (logic != PipeConnectionType.Transfer || adjConnections == null) {
            return;
        }
        Direction oppositeDirection = side.getOpposite();
        PipeConnectionType otherConnectionLogic = adjConnections.getLogic(oppositeDirection);
        if (otherConnectionLogic != PipeConnectionType.None) {
            return;
        }
        adjConnections.setSide(oppositeDirection, PipeConnectionType.Transfer);
        BlockState otherState = level.getBlockState(otherPos);
        level.sendBlockUpdated(otherPos, otherState, otherState, 3);
        level.markAndNotifyBlock(otherPos, level.getChunkAt(otherPos), otherState, otherState, 3, 512);
    }

    private PipeConnectionType canConnect(Level level, BlockPos pos, IPipeConnection pipeConnections, IPipeConnection adjConnections, Direction side) {
        boolean canConnect = pipeConnections.canConnect(side);
        if (canConnect) {
            canConnect = adjConnections == null ? level.getCapability(this._cap, pos.relative(side), (Object)side.getOpposite()) != null : adjConnections.canConnect(side.getOpposite()) && adjConnections.getHandledCap() == pipeConnections.getHandledCap();
        }
        PipeConnectionType logic = canConnect ? PipeConnectionType.Transfer : PipeConnectionType.None;
        return logic;
    }
}

