/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.level.MultiTankLevelAttachment;
import tv.soaryn.xycraft.machines.content.blocks.multiblock.TankMemberBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IMultiTankMember;
import tv.soaryn.xycraft.machines.content.multiblock.tank.MultiTank;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class ValveBlock
extends XyBlock.WithEntity
implements IColoredBlock,
ITooltipProvider {
    private static final VoxelShape Shape = Shapes.join((VoxelShape)ValveBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)ValveBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);

    public ValveBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion(), Entity::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Axis, (Comparable)Direction.Axis.Y)).setValue((Property)MachineStateProperties.Initialized, (Comparable)Boolean.valueOf(false))).setValue((Property)MachineStateProperties.FluidBalance, (Comparable)Boolean.valueOf(false)));
    }

    public void appendToolTip(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)this.getToolTipKey(0)).withStyle(ChatFormatting.GRAY));
        if (ModifierKey.ofClient()) {
            String s = String.valueOf(XyMachines.ServerConfig.TankSizeLimit.get());
            components.add((Component)Component.translatable((String)this.getToolTipKey(1), (Object[])new Object[]{"%sx%sx%s".formatted(s, s, s)}).withColor(-5592321));
        }
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        IFluidHandler cap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
        if (cap == null) {
            return super.getAnalogOutputSignal(state, level, pos);
        }
        return TankMultiBlock.redstoneLevelFromContents(cap.getFluidInTank(0).getAmount(), cap.getTankCapacity(0));
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)MachineStateProperties.Initialized);
    }

    protected boolean isSignalSource(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)MachineStateProperties.Initialized);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        Object object;
        if (!oldState.is(state.getBlock()) && level instanceof ServerLevel && (object = level.getBlockEntity(pos)) instanceof TankMemberBlockEntity) {
            TankMemberBlockEntity tankEntity = (TankMemberBlockEntity)object;
            for (TankMultiBlock multiBlock : tankEntity.getMultiBlocks()) {
                if (multiBlock == null) continue;
                Long2ObjectOpenHashMap<BlockCapabilityCache<IMultiTankMember, Void>> members = multiBlock.getMembers();
                members.remove(pos.asLong());
                MultiTank parent = multiBlock.getParent();
                if (!members.isEmpty() || parent == null) continue;
                MultiTankLevelAttachment cache = (MultiTankLevelAttachment)level.getData(MachinesAttachments.LevelTankData);
                cache.removeTank(parent.getId());
            }
        }
        super.onRemove(state, level, pos, oldState, moving);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{CoreStateProperties.Axis});
        stateBuilder.add(new Property[]{MachineStateProperties.Initialized});
        stateBuilder.add(new Property[]{MachineStateProperties.FluidBalance});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                Entity valve;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (ModifierKey.of((Player)player)) {
                    return super.useItemOn(stack, state, level, pos, player, hand, hit);
                }
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (blockEntity instanceof Entity && !(valve = (Entity)blockEntity).isFormed() && player instanceof ServerPlayer) break block5;
            }
            return ItemInteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TankMultiBlock.tryForm(serverLevel, pos, hit.getDirection(), serverPlayer);
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        return super.getDrops(state, builder);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return index == -1 ? -1 : XyCraftColors.Blue.getColor();
    }

    @EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
    public static class Entity
    extends TankMemberBlockEntity {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.Valve.entity(), pos, state);
        }

        @Override
        public boolean canPreserveFluid() {
            return true;
        }

        @SubscribeEvent
        private static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, MachinesContent.Block.Valve.entity(), (object, context) -> {
                Entity valve;
                block3: {
                    block2: {
                        if (!(object instanceof Entity)) break block2;
                        valve = (Entity)object;
                        if (valve.tank != null) break block3;
                    }
                    return null;
                }
                return valve.tank.getFluidHandler();
            });
            event.registerBlockEntity(IMultiTankMember.BLOCK, MachinesContent.Block.Valve.entity(), (blockEntity, context) -> {
                TankMemberBlockEntity valve;
                return blockEntity instanceof TankMemberBlockEntity ? (valve = (TankMemberBlockEntity)blockEntity) : null;
            });
        }
    }
}

