/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.config;

import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import tv.soaryn.xycraft.core.config.XyConfig;

public class MachinesServerConfig
extends XyConfig {
    private final ModConfigSpec _configs;
    public final ModConfigSpec.IntValue PlanterLimit;
    public final ModConfigSpec.IntValue HoverPylonRange;
    public final ModConfigSpec.IntValue CollectorRange;
    public final ModConfigSpec.IntValue LightFieldRange;
    public final ModConfigSpec.BooleanValue LightFieldPreventsSieges;
    public final ModConfigSpec.BooleanValue LightFieldPreventEndermenWarpIn;
    public final ModConfigSpec.BooleanValue WaterBlockFillsContainer;
    public final ModConfigSpec.BooleanValue FluidVoidEmptiesContainer;
    public final ModConfigSpec.IntValue VoidContainmentItemAmount;
    public final ModConfigSpec.IntValue VoidContainmentFluidAmount;
    public final ModConfigSpec.IntValue VoidContainmentPowerAmount;
    public final ModConfigSpec.IntValue HydroPumpFluidAmount;
    public final ModConfigSpec.IntValue HydroPumpFluidAmountWaterLogged;
    public final ModConfigSpec.IntValue HydroPumpFluidExternalAmount;
    public final ModConfigSpec.IntValue SelectorItemAmount;
    public final ModConfigSpec.IntValue SelectorFluidAmount;
    public final ModConfigSpec.IntValue TankSizeLimit;
    public final ModConfigSpec.IntValue TankStoragePerBlock;
    public final ModConfigSpec.IntValue ExtractorInternalBufferSize;
    public final ModConfigSpec.IntValue BalloonOnAStickRange;
    public final ModConfigSpec.IntValue DurableCellCapacity;
    public final ModConfigSpec.IntValue FlareRodEnergyCost;
    public final ModConfigSpec.IntValue GauntletEnergyCost;

    public MachinesServerConfig() {
        super(ModConfig.Type.SERVER, "machines");
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Blocks");
        this.WaterBlockFillsContainer = builder.comment("Allow the Water Block to fill a fluid container with water in hand").define("water_block_fills_container", true);
        this.FluidVoidEmptiesContainer = builder.comment("Allow the Fluid Void to empty a fluid container in hand").define("fluid_void_empties_container", true);
        this.PlanterLimit = builder.comment("How many planters in a line are allowed to accelerate a plant growth").defineInRange("planter_limit", 16, 1, 128);
        builder.push("LightField");
        this.LightFieldRange = builder.comment("How Large of a radius should spawns be prevented").worldRestart().defineInRange("light_field_range", 24, 4, 512);
        this.LightFieldPreventsSieges = builder.comment("Determines if a light field block can prevent a siege from occurring.").define("light_field_siege_prevention", true);
        this.LightFieldPreventEndermenWarpIn = builder.comment("Determines if a light field block can prevent endermen from warping to within the field range.").define("light_field_ender_warp_prevention", true);
        builder.pop();
        this.BalloonOnAStickRange = builder.comment("How far a player may fly before severing the connection of the Balloon on a stick. Note, this is not a sphere.").defineInRange("balloon_on_a_stick_radius", 9, 3, 32);
        this.HoverPylonRange = builder.comment("How large of a radius should the player be able to fly around a hover pylon").worldRestart().defineInRange("hover_pylon_range", 16, 8, 64);
        this.CollectorRange = builder.comment("How large of a radius should the collector be allowed to pick up items").worldRestart().defineInRange("collector_pickup_range", 3, 1, 64);
        builder.push("HydroPump");
        this.HydroPumpFluidAmount = builder.comment("How much fluid can the hydro pump push in a single cycle in milli-buckets").defineInRange("hydro_pump_fluid_push_amount", 100, 0, 1000000000);
        this.HydroPumpFluidAmountWaterLogged = builder.comment("How much fluid can the hydro pump push in a single cycle in milli-buckets while water logged").defineInRange("hydro_pump_fluid_push_amount_water_logged", 1000, 0, 1000000000);
        this.HydroPumpFluidExternalAmount = builder.comment("How much fluid can an external source pull in milli-buckets").defineInRange("hydro_pump_fluid_external_pull_amount", 1000000000, 0, 1000000000);
        builder.pop();
        builder.push("VoidContainment");
        this.VoidContainmentItemAmount = builder.comment("How many items can the void containment pull in a single process").defineInRange("void_containment_item_pull_amount", 8, 0, 576);
        this.VoidContainmentFluidAmount = builder.comment("How much fluid can the void containment pull in a single process in milli-buckets").defineInRange("void_containment_fluid_pull_amount", 1000, 0, 1000000000);
        this.VoidContainmentPowerAmount = builder.comment("How much forge energy can the void containment pull in a single process").defineInRange("void_containment_power_pull_amount", 100, 0, 1000000000);
        builder.pop();
        builder.comment("How much can a Creative Selector can create. Note, this is only how much it can push, anything pulling can pull as much as it desires!").push("Selector");
        this.SelectorItemAmount = builder.comment("How many items can the selector push per cycle").defineInRange("selector_item_amount", 64, 1, 576);
        this.SelectorFluidAmount = builder.comment("How much fluid can the selector push per cycle in milli-buckets").defineInRange("selector_fluid_amount", 1000000000, 1, 1000000000);
        builder.pop();
        builder.pop();
        builder.push("MultiBlocks");
        builder.comment("Cuboid fluid storage.").push("Tank");
        this.TankSizeLimit = builder.comment("Maximum dimensions of a tank. A single dimension is measured from wall to wall (inclusive).").worldRestart().defineInRange("tank_size_limit", 13, 3, 33);
        this.TankStoragePerBlock = builder.comment("How much fluid can be stored for each empty air block in the defined box. Measured in milli-buckets (mB)").worldRestart().defineInRange("tank_storage_per_block", 8000, 1, 64000);
        builder.pop();
        builder.pop();
        builder.push("PowerItems");
        this.DurableCellCapacity = builder.comment("The amount of power the durable cell can store").defineInRange("durable_cell_capacity", 500, 1, 1000000000);
        this.FlareRodEnergyCost = builder.comment("The amount of power the flare rod needs to place a light").defineInRange("flare_rod_cost", 5, 0, 1000000000);
        this.GauntletEnergyCost = builder.comment("The amount of power the gauntlet needs to use an action (example is placing or destroying a block is one action)").defineInRange("flare_rod_cost", 5, 0, 1000000000);
        builder.pop();
        builder.comment("These features can be tweaked, but consider carefully if you absolutely need to").push("Internals");
        this.ExtractorInternalBufferSize = builder.worldRestart().comment("Amount of fluid a single Extractor can hold internally. This is recommended to keep low or default unless you are making a custom pack with a recipe that requires a large fluid output").defineInRange("extractor_buffer", 1000, 1000, 10000);
        builder.pop();
        this._configs = builder.build();
    }

    public ModConfigSpec getSpec() {
        return this._configs;
    }
}

