/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;
import tv.soaryn.xycraft.machines.content.attachments.BalloonStakeAttachment;
import tv.soaryn.xycraft.machines.content.blocks.balloonstake.BalloonStakeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class BalloonStakeRender
implements BlockEntityRenderer<BalloonStakeBlockEntity> {
    private final BlockRenderDispatcher _renderDispatcherCache;

    public BalloonStakeRender(BlockEntityRendererProvider.Context context) {
        this._renderDispatcherCache = context.getBlockRenderDispatcher();
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull BalloonStakeBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate((double)((Integer)XyMachines.ServerConfig.BalloonOnAStickRange.get() + 2));
    }

    public boolean shouldRenderOffScreen(@NotNull BalloonStakeBlockEntity entity) {
        return true;
    }

    public void render(@NotNull BalloonStakeBlockEntity entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        BlockState state = entity.getBlockState();
        Vec3 stakePos = Vec3.atCenterOf((Vec3i)entity.getBlockPos());
        Boolean bound = (Boolean)entity.getBlockState().getValue((Property)MachineStateProperties.Connected);
        Level level = entity.getLevel();
        if (!bound.booleanValue() || level == null) {
            return;
        }
        Player player = ((BalloonStakeAttachment)entity.getData(MachinesAttachments.BalloonData)).getPlayer(level);
        if (player == null) {
            return;
        }
        Vec3 playerPos = BalloonStakeRender.getPlayerBodyCenterPos(partialTick, player);
        Vec3 ropeOffset = new Vec3(0.0, 0.0, 0.5);
        double theta = (double)(Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)java.lang.Math.PI / 180)) + 1.5707963267948966;
        double cos = Math.cos((double)theta);
        double sin = Math.sin((double)theta);
        double d1 = cos * ropeOffset.z + sin * ropeOffset.x;
        double d2 = sin * ropeOffset.z - cos * ropeOffset.x;
        this.renderLeash(player, partialTick, poseStack, bufferSource, stakePos);
        this.renderLeash(player, partialTick, poseStack, bufferSource, stakePos);
        poseStack.pushPose();
        Vec3 dif = playerPos.subtract(stakePos).subtract(d1, -1.5, d2);
        poseStack.translate(dif.x(), dif.y(), dif.z());
        poseStack.translate(0.0f, Mth.sin((float)(((float)Ticks.ofClient() + partialTick) * 0.05f)) * 0.05f, 0.0f);
        poseStack.pushPose();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.leash());
        Matrix4f matrix4f = poseStack.last().pose();
        float z = 0.3f;
        float x = 0.0f;
        dif = new Vec3(cos * (double)z + sin * (double)x, -1.5, sin * (double)z - cos * (double)x);
        float iSquare = (float)(Math.invsqrt((double)(dif.x() * dif.x() + dif.z() * dif.z())) * (double)0.025f / 2.0);
        float inverseZ = (float)(dif.z() * (double)iSquare);
        float inverseX = (float)(dif.x() * (double)iSquare);
        poseStack.translate(0.5, 0.5, 0.5);
        float ropeScale = 0.025f;
        this.addVertexPairs(dif, inverseZ, inverseX, ropeScale, vertexconsumer, matrix4f);
        poseStack.translate(-0.5, -0.5, -0.5);
        float scale = 0.8f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(1.0f - scale, 1.0f - scale, 1.0f - scale);
        for (RenderType rt : MachinesModelBakery.Balloon.getRenderTypes(state, RandomSource.create((long)42L), ModelData.EMPTY)) {
            VertexConsumer bufferSrc = bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false));
            Vector3f color = ColorUtils.convertToRGBVec((int)FavoredColor.of((IAttachmentHolder)player));
            this._renderDispatcherCache.getModelRenderer().renderModel(poseStack.last(), bufferSrc, state, MachinesModelBakery.Balloon, color.x(), color.y(), color.z(), light, overlay, ModelData.EMPTY, rt);
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private void renderLeash(Player targetPlayer, float partialTick, PoseStack poseStack, MultiBufferSource source, Vec3 stakePosition) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        Vec3 playerPos = BalloonStakeRender.getPlayerBodyCenterPos(partialTick, targetPlayer);
        double d0 = (double)(Mth.lerp((float)partialTick, (float)targetPlayer.yBodyRotO, (float)targetPlayer.yBodyRot) * ((float)java.lang.Math.PI / 180)) + 1.5707963267948966;
        Vec3 ropeOffset = new Vec3(0.0, (double)targetPlayer.getEyeHeight() * (double)0.4f, (double)(targetPlayer.getBbWidth() * -0.2f));
        double d1 = Math.cos((double)d0) * ropeOffset.z + Math.sin((double)d0) * ropeOffset.x;
        double d2 = Math.sin((double)d0) * ropeOffset.z - Math.cos((double)d0) * ropeOffset.x;
        double d3 = Mth.lerp((double)partialTick, (double)targetPlayer.xo, (double)targetPlayer.getX()) + d1;
        double d4 = Mth.lerp((double)partialTick, (double)targetPlayer.yo, (double)targetPlayer.getY()) + ropeOffset.y;
        double d5 = Mth.lerp((double)partialTick, (double)targetPlayer.zo, (double)targetPlayer.getZ()) + d2;
        poseStack.translate(d1, ropeOffset.y, d2);
        float f = (float)(stakePosition.x - d3);
        float f1 = (float)(stakePosition.y - d4);
        float f2 = (float)(stakePosition.z - d5);
        Vec3 dif = new Vec3((double)f, (double)f1, (double)f2);
        dif = playerPos.subtract(stakePosition);
        float iSquare = (float)(Math.invsqrt((double)(dif.x() * dif.x() + dif.z() * dif.z())) * (double)0.025f / 2.0);
        float inverseZ = (float)(dif.z() * (double)iSquare);
        float inverseX = (float)(dif.x() * (double)iSquare);
        float scale = 0.025f;
        VertexConsumer vertexconsumer = source.getBuffer(RenderType.leash());
        Matrix4f matrix4f = poseStack.last().pose();
        this.addVertexPairs(dif, inverseZ, inverseX, scale, vertexconsumer, matrix4f);
        poseStack.popPose();
    }

    private void addVertexPairs(Vec3 dif, float inverseZ, float inverseX, float scale, VertexConsumer vertexconsumer, Matrix4f matrix4f) {
        for (int i1 = 0; i1 <= 24; ++i1) {
            BalloonStakeRender.addVertexPair(vertexconsumer, matrix4f, (float)dif.x(), (float)dif.y(), (float)dif.z(), 9, 9, 9, 9, scale, scale, inverseZ, inverseX, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            BalloonStakeRender.addVertexPair(vertexconsumer, matrix4f, (float)dif.x(), (float)dif.y(), (float)dif.z(), 9, 9, 9, 9, scale, 0.0f, inverseZ, inverseX, j1, true);
        }
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix, float x, float y, float z, int lightA, int skyA, int blockA, int blockB, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.lerp((float)f, (float)lightA, (float)skyA);
        int j = (int)Mth.lerp((float)f, (float)blockA, (float)blockB);
        int k = LightTexture.pack((int)i, (int)j);
        float f1 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float f2 = 0.5f * f1;
        float f3 = 0.4f * f1;
        float f4 = 0.3f * f1;
        float f5 = x * f;
        float f6 = y > 0.0f ? y * f * f : y - y * (1.0f - f) * (1.0f - f);
        float f7 = z * f;
        vertexConsumer.addVertex(matrix, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).setColor(f2, f3, f4, 1.0f).setLight(k);
        vertexConsumer.addVertex(matrix, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).setColor(f2, f3, f4, 1.0f).setLight(k);
    }

    @NotNull
    private static Vec3 getPlayerBodyCenterPos(float partialTick, Player player) {
        float rotX = Mth.lerp((float)(partialTick * 0.5f), (float)player.getXRot(), (float)player.xRotO) * ((float)java.lang.Math.PI / 180);
        float rotY = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)java.lang.Math.PI / 180);
        if (!player.isFallFlying() && !player.isAutoSpinAttack()) {
            if (player.isVisuallySwimming()) {
                return player.getPosition(partialTick).add(new Vec3(0.0, 0.2, -0.15).xRot(-rotX).yRot(-rotY));
            }
            double d5 = player.getBoundingBox().getYsize() - 0.75;
            double d6 = player.isCrouching() ? -0.2 : 0.07;
            return player.getPosition(partialTick).add(new Vec3(0.0, d5, d6).yRot(-rotY));
        }
        Vec3 view = player.getViewVector(partialTick);
        Vec3 moveDelta = player.getDeltaMovement();
        double deltaDistX = moveDelta.horizontalDistanceSqr();
        double viewDistX = view.horizontalDistanceSqr();
        double d3 = (moveDelta.x * view.x + moveDelta.z * view.z) / Math.sqrt((double)(deltaDistX * viewDistX));
        double d4 = moveDelta.x * view.z - moveDelta.z * view.x;
        float zRot = deltaDistX > 0.0 && viewDistX > 0.0 ? (float)(Math.signum((double)d4) * Math.acos((double)d3)) : 0.0f;
        return player.getPosition(partialTick).add(new Vec3(0.0, -0.11, 0.85).zRot(-zRot).xRot(-rotX).yRot(-rotY));
    }
}

